/*
 * Decompiled with CFR 0.152.
 */
package com.dothantech.lpapi;

import android.annotation.SuppressLint;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import com.dothantech.lpapi.IAtBitmap;
import com.dothantech.printer.IDzPrinter;
import com.dothantech.view.a;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;

public class LPAPI {
    protected final IDzPrinter mPrinter;
    protected final IAtBitmap mBitmap;

    protected LPAPI() {
        this(null);
    }

    protected LPAPI(Callback callback) {
        this(null, callback);
    }

    protected LPAPI(IDzPrinter iDzPrinter, Callback callback) {
        a.a();
        if (iDzPrinter == null) {
            iDzPrinter = IDzPrinter.Factory.getInstance();
        }
        this.mPrinter = iDzPrinter;
        this.mBitmap = IAtBitmap.Factory.createInstance(this.mPrinter);
        this.mPrinter.init(null, callback);
    }

    @JavascriptInterface
    public String getAllPrinters(String object) {
        if ((object = IDzPrinter.Factory.getAllPrinters((String)object)) == null || object.isEmpty()) {
            return "";
        }
        String string = "";
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            object = (IDzPrinter.PrinterAddress)iterator.next();
            string = String.valueOf(string) + "," + ((IDzPrinter.PrinterAddress)object).shownName;
        }
        return string.substring(1);
    }

    public List<IDzPrinter.PrinterAddress> getAllPrinterAddresses(String string) {
        return IDzPrinter.Factory.getAllPrinters(string);
    }

    public IDzPrinter.PrinterAddress getFirstPrinter() {
        return IDzPrinter.Factory.getFirstPrinter();
    }

    @JavascriptInterface
    public boolean openPrinter(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return this.mPrinter.connect(IDzPrinter.Factory.getFirstPrinter());
        }
        return this.mPrinter.connect(string);
    }

    public boolean openPrinterByAddress(IDzPrinter.PrinterAddress printerAddress) {
        return this.mPrinter.connect(printerAddress);
    }

    @JavascriptInterface
    public boolean openPrinterSync(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return this.mPrinter.connectSync(IDzPrinter.Factory.getFirstPrinter());
        }
        return this.mPrinter.connectSync(string);
    }

    public boolean openPrinterByAddressSync(IDzPrinter.PrinterAddress printerAddress) {
        return this.mPrinter.connectSync(printerAddress);
    }

    @JavascriptInterface
    public String getPrinterName() {
        IDzPrinter.PrinterInfo printerInfo = this.mPrinter.getPrinterInfo();
        if (printerInfo == null) {
            return "";
        }
        return printerInfo.deviceName;
    }

    public IDzPrinter.PrinterInfo getPrinterInfo() {
        return this.mPrinter.getPrinterInfo();
    }

    public IDzPrinter.PrinterState getPrinterState() {
        return this.mPrinter.getPrinterState();
    }

    @JavascriptInterface
    public boolean isPrinterOpened() {
        switch (this.mPrinter.getPrinterState()) {
            case Disconnected: {
                return false;
            }
            case Connecting: {
                return false;
            }
        }
        return true;
    }

    @JavascriptInterface
    public void cancel() {
        this.mPrinter.cancel();
    }

    @JavascriptInterface
    public void closePrinter() {
        this.mPrinter.disconnect();
    }

    @JavascriptInterface
    public boolean reopenPrinter() {
        return this.mPrinter.reconnect();
    }

    @JavascriptInterface
    public boolean reopenPrinterSync() {
        return this.mPrinter.reconnectSync();
    }

    @JavascriptInterface
    public void quit() {
        this.mPrinter.quit();
    }

    public boolean printBitmap(Bitmap bitmap, Bundle bundle) {
        return this.mPrinter.print(bitmap, bundle);
    }

    public boolean printATBitmap(IAtBitmap iAtBitmap, Bundle bundle) {
        return this.mPrinter.print(iAtBitmap, bundle);
    }

    public boolean waitPrinterState(IDzPrinter.PrinterState printerState, int n2) {
        return this.mPrinter.waitPrinterState(printerState, n2);
    }

    @JavascriptInterface
    public boolean startJob(double d2, double d3, int n2) {
        this.mBitmap.setItemOrientation(0);
        this.mBitmap.setItemHorizontalAlignment(0);
        this.mBitmap.setItemVerticalAlignment(0);
        this.mBitmap.setItemPenAlignment(0);
        return this.mBitmap.startJob(LPAPI.MM_2_01MM(d2), LPAPI.MM_2_01MM(d3), 0, n2, 1, null) == 0;
    }

    @JavascriptInterface
    public void abortJob() {
        this.mBitmap.abortJob();
    }

    @JavascriptInterface
    public boolean commitJob() {
        return this.commitJobWithParam(null);
    }

    public boolean commitJobWithParam(Bundle bundle) {
        this.mBitmap.endJob();
        return this.mPrinter.print(this.mBitmap, bundle);
    }

    @JavascriptInterface
    public boolean startPage() {
        return this.mBitmap.startPage() == 0;
    }

    @JavascriptInterface
    public void endPage() {
        this.mBitmap.endPage();
    }

    @JavascriptInterface
    public void endJob() {
        this.mBitmap.endJob();
    }

    public List<Bitmap> getJobPages() {
        return this.mBitmap.a();
    }

    @JavascriptInterface
    public int getItemOrientation() {
        return this.mBitmap.getItemOrientation();
    }

    @JavascriptInterface
    public void setItemOrientation(int n2) {
        this.mBitmap.setItemOrientation(n2);
    }

    @JavascriptInterface
    public int getItemHorizontalAlignment() {
        return this.mBitmap.getItemHorizontalAlignment();
    }

    @JavascriptInterface
    public void setItemHorizontalAlignment(int n2) {
        this.mBitmap.setItemHorizontalAlignment(n2);
    }

    @JavascriptInterface
    public int getItemVerticalAlignment() {
        return this.mBitmap.getItemVerticalAlignment();
    }

    @JavascriptInterface
    public void setItemVerticalAlignment(int n2) {
        this.mBitmap.setItemVerticalAlignment(n2);
    }

    @JavascriptInterface
    public int getItemPenAlignment() {
        return this.mBitmap.getItemPenAlignment();
    }

    @JavascriptInterface
    public void setItemPenAlignment(int n2) {
        this.mBitmap.setItemPenAlignment(n2);
    }

    @JavascriptInterface
    public boolean drawText(String string, double d2, double d3, double d4, double d5, double d6) {
        return this.drawTextRegular(string, d2, d3, d4, d5, d6, 0);
    }

    @JavascriptInterface
    public boolean drawTextRegular(String string, double d2, double d3, double d4, double d5, double d6, int n2) {
        return this.mBitmap.drawText(string, LPAPI.MM_2_01MM(d2), LPAPI.MM_2_01MM(d3), LPAPI.MM_2_01MM(d4), LPAPI.MM_2_01MM(d5), LPAPI.MM_2_01MM(d6), n2) == 0;
    }

    @JavascriptInterface
    public boolean drawRichText(String string, double d2, double d3, double d4, double d5, double d6, int n2) {
        return this.mBitmap.drawRichText(string, LPAPI.MM_2_01MM(d2), LPAPI.MM_2_01MM(d3), LPAPI.MM_2_01MM(d4), LPAPI.MM_2_01MM(d5), LPAPI.MM_2_01MM(d6), n2) == 0;
    }

    @JavascriptInterface
    public boolean draw1DBarcode(String string, int n2, double d2, double d3, double d4, double d5, double d6) {
        return this.mBitmap.draw1DBarcode(string, n2, LPAPI.MM_2_01MM(d2), LPAPI.MM_2_01MM(d3), LPAPI.MM_2_01MM(d4), LPAPI.MM_2_01MM(d5), LPAPI.MM_2_01MM(d6)) == 0;
    }

    @JavascriptInterface
    public boolean draw2DQRCode(String string, double d2, double d3, double d4) {
        return this.mBitmap.draw2DQRCode(string, LPAPI.MM_2_01MM(d2), LPAPI.MM_2_01MM(d3), LPAPI.MM_2_01MM(d4), LPAPI.MM_2_01MM(d4)) == 0;
    }

    @JavascriptInterface
    public boolean draw2DPdf417(String string, double d2, double d3, double d4, double d5) {
        return this.mBitmap.draw2DPdf417(string, LPAPI.MM_2_01MM(d2), LPAPI.MM_2_01MM(d3), LPAPI.MM_2_01MM(d4), LPAPI.MM_2_01MM(d5)) == 0;
    }

    @JavascriptInterface
    public boolean drawRectangle(double d2, double d3, double d4, double d5, double d6) {
        return this.mBitmap.drawRectangle(LPAPI.MM_2_01MM(d2), LPAPI.MM_2_01MM(d3), LPAPI.MM_2_01MM(d4), LPAPI.MM_2_01MM(d5), LPAPI.MM_2_01MM(d6)) == 0;
    }

    @JavascriptInterface
    public boolean fillRectangle(double d2, double d3, double d4, double d5) {
        return this.mBitmap.drawFillRectangle(LPAPI.MM_2_01MM(d2), LPAPI.MM_2_01MM(d3), LPAPI.MM_2_01MM(d4), LPAPI.MM_2_01MM(d5)) == 0;
    }

    @JavascriptInterface
    public boolean drawRoundRectangle(double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        return this.mBitmap.drawRoundRectangle(LPAPI.MM_2_01MM(d2), LPAPI.MM_2_01MM(d3), LPAPI.MM_2_01MM(d4), LPAPI.MM_2_01MM(d5), LPAPI.MM_2_01MM(d6), LPAPI.MM_2_01MM(d7), LPAPI.MM_2_01MM(d8)) == 0;
    }

    @JavascriptInterface
    public boolean fillRoundRectangle(double d2, double d3, double d4, double d5, double d6, double d7) {
        return this.mBitmap.drawFillRoundRectangle(LPAPI.MM_2_01MM(d2), LPAPI.MM_2_01MM(d3), LPAPI.MM_2_01MM(d4), LPAPI.MM_2_01MM(d5), LPAPI.MM_2_01MM(d6), LPAPI.MM_2_01MM(d7)) == 0;
    }

    @JavascriptInterface
    public boolean drawEllipse(double d2, double d3, double d4, double d5, double d6) {
        return this.mBitmap.drawEllipse(LPAPI.MM_2_01MM(d2), LPAPI.MM_2_01MM(d3), LPAPI.MM_2_01MM(d4), LPAPI.MM_2_01MM(d5), LPAPI.MM_2_01MM(d6)) == 0;
    }

    @JavascriptInterface
    public boolean fillEllipse(double d2, double d3, double d4, double d5) {
        return this.mBitmap.drawFillEllipse(LPAPI.MM_2_01MM(d2), LPAPI.MM_2_01MM(d3), LPAPI.MM_2_01MM(d4), LPAPI.MM_2_01MM(d5)) == 0;
    }

    @JavascriptInterface
    public boolean drawCircle(double d2, double d3, double d4, double d5) {
        return this.mBitmap.drawEllipse(LPAPI.MM_2_01MM(d2), LPAPI.MM_2_01MM(d3), LPAPI.MM_2_01MM(d4 * 2.0), LPAPI.MM_2_01MM(d5)) == 0;
    }

    @JavascriptInterface
    public boolean fillCircle(double d2, double d3, double d4) {
        return this.mBitmap.drawFillEllipse(LPAPI.MM_2_01MM(d2), LPAPI.MM_2_01MM(d3), LPAPI.MM_2_01MM(d4 * 2.0)) == 0;
    }

    @JavascriptInterface
    public boolean drawLine(double d2, double d3, double d4, double d5, double d6) {
        return this.mBitmap.drawLine(LPAPI.MM_2_01MM(d2), LPAPI.MM_2_01MM(d3), LPAPI.MM_2_01MM(d4), LPAPI.MM_2_01MM(d5), LPAPI.MM_2_01MM(d6)) == 0;
    }

    @JavascriptInterface
    public boolean drawDashLine(double d2, double d3, double d4, double d5, double d6, double[] dArray, int n2) {
        if (dArray == null) {
            return false;
        }
        int[] nArray = new int[dArray.length];
        int n3 = 0;
        while (n3 < nArray.length) {
            nArray[n3] = LPAPI.MM_2_01MM(dArray[n3]);
            ++n3;
        }
        return this.mBitmap.drawDashLine(LPAPI.MM_2_01MM(d2), LPAPI.MM_2_01MM(d3), LPAPI.MM_2_01MM(d4), LPAPI.MM_2_01MM(d5), LPAPI.MM_2_01MM(d6), nArray, n2) == 0;
    }

    @JavascriptInterface
    public boolean drawDashLine2(double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        return this.mBitmap.drawDashLine(LPAPI.MM_2_01MM(d2), LPAPI.MM_2_01MM(d3), LPAPI.MM_2_01MM(d4), LPAPI.MM_2_01MM(d5), LPAPI.MM_2_01MM(d6), LPAPI.MM_2_01MM(d7), LPAPI.MM_2_01MM(d8)) == 0;
    }

    @JavascriptInterface
    public boolean drawDashLine4(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10) {
        return this.mBitmap.drawDashLine(LPAPI.MM_2_01MM(d2), LPAPI.MM_2_01MM(d3), LPAPI.MM_2_01MM(d4), LPAPI.MM_2_01MM(d5), LPAPI.MM_2_01MM(d6), LPAPI.MM_2_01MM(d7), LPAPI.MM_2_01MM(d8), LPAPI.MM_2_01MM(d9), LPAPI.MM_2_01MM(d10)) == 0;
    }

    @JavascriptInterface
    public boolean drawImageWithThreshold(String string, double d2, double d3, double d4, double d5, int n2) {
        return this.mBitmap.drawImage(string, LPAPI.MM_2_01MM(d2), LPAPI.MM_2_01MM(d3), LPAPI.MM_2_01MM(d4), LPAPI.MM_2_01MM(d5), n2) == 0;
    }

    @JavascriptInterface
    public boolean drawImage(String string, double d2, double d3, double d4, double d5) {
        return this.mBitmap.drawImage(string, LPAPI.MM_2_01MM(d2), LPAPI.MM_2_01MM(d3), LPAPI.MM_2_01MM(d4), LPAPI.MM_2_01MM(d5)) == 0;
    }

    @JavascriptInterface
    public boolean drawImageWithActualSize(String string, double d2, double d3) {
        return this.mBitmap.drawImage(string, LPAPI.MM_2_01MM(d2), LPAPI.MM_2_01MM(d3)) == 0;
    }

    public boolean drawBitmapWithThreshold(Bitmap bitmap, double d2, double d3, double d4, double d5, int n2) {
        return this.mBitmap.drawBitmap(bitmap, LPAPI.MM_2_01MM(d2), LPAPI.MM_2_01MM(d3), LPAPI.MM_2_01MM(d4), LPAPI.MM_2_01MM(d5), n2) == 0;
    }

    public boolean drawBitmap(Bitmap bitmap, double d2, double d3, double d4, double d5) {
        return this.mBitmap.drawBitmap(bitmap, LPAPI.MM_2_01MM(d2), LPAPI.MM_2_01MM(d3), LPAPI.MM_2_01MM(d4), LPAPI.MM_2_01MM(d5)) == 0;
    }

    public boolean drawBitmapWithActualSize(Bitmap bitmap, double d2, double d3) {
        return this.mBitmap.drawBitmap(bitmap, LPAPI.MM_2_01MM(d2), LPAPI.MM_2_01MM(d3)) == 0;
    }

    @JavascriptInterface
    public boolean drawBitmapStreamWithThreshold(InputStream inputStream, double d2, double d3, double d4, double d5, int n2) {
        return this.mBitmap.drawBitmap(inputStream, LPAPI.MM_2_01MM(d2), LPAPI.MM_2_01MM(d3), LPAPI.MM_2_01MM(d4), LPAPI.MM_2_01MM(d5), n2) == 0;
    }

    @JavascriptInterface
    public boolean drawBitmapStream(InputStream inputStream, double d2, double d3, double d4, double d5) {
        return this.mBitmap.drawBitmap(inputStream, LPAPI.MM_2_01MM(d2), LPAPI.MM_2_01MM(d3), LPAPI.MM_2_01MM(d4), LPAPI.MM_2_01MM(d5)) == 0;
    }

    @JavascriptInterface
    public boolean drawBitmapStreamWithActualSize(InputStream inputStream, double d2, double d3) {
        return this.mBitmap.drawBitmap(inputStream, LPAPI.MM_2_01MM(d2), LPAPI.MM_2_01MM(d3)) == 0;
    }

    private static int MM_2_01MM(double d2) {
        return (int)(d2 * 100.0);
    }

    public static class BarcodeType
    extends IAtBitmap.BarcodeType1D {
    }

    public static interface Callback
    extends IDzPrinter.IDzPrinterCallback {
    }

    public static class Factory {
        public static LPAPI createInstance() {
            return Factory.createInstance(null);
        }

        public static LPAPI createInstance(Callback callback) {
            return new LPAPI(callback);
        }

        public static LPAPI createInstance(WebView webView) {
            return Factory.createInstance(webView, null);
        }

        public static LPAPI createInstance(WebView webView, Callback callback) {
            return Factory.createInstance(webView, "DzLPAPI", callback);
        }

        @SuppressLint(value={"SetJavaScriptEnabled"})
        public static LPAPI createInstance(WebView webView, String string, Callback object) {
            object = new LPAPI((Callback)object);
            if (webView == null || Build.VERSION.SDK_INT < 17) {
                return object;
            }
            try {
                webView.getSettings().setJavaScriptEnabled(true);
            }
            catch (Exception exception) {}
            webView.addJavascriptInterface(object, string);
            return object;
        }
    }

    public static interface FontStyle
    extends IAtBitmap.FontStyle {
    }

    public static interface ItemAlignment
    extends IAtBitmap.ItemAlignment {
    }

    public static interface PenAlignment
    extends IAtBitmap.PenAlignment {
    }
}

