/*
 * Decompiled with CFR 0.152.
 */
package bogda.common;

import bogda.common.Empty;
import bogda.common.JsonSerializer;
import bogda.common.StrKit;
import bogda.common.date.DateKit;
import java.lang.reflect.Array;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class JsonKit {
    private static final String a = "yyyy-MM-dd HH:mm:ss";
    private static final String b = "yyyy-MM-dd";
    private static final String c = "HH:mm:ss";

    public static StringBuilder appendKey(Object object, StringBuilder stringBuilder) {
        stringBuilder.append('\"');
        String string = StrKit.toStr(object, true);
        block3: for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '\"': {
                    stringBuilder.append("\\\"");
                    continue block3;
                }
                default: {
                    stringBuilder.append(c2);
                }
            }
        }
        stringBuilder.append('\"');
        return stringBuilder;
    }

    public static StringBuilder appendVal(Object object, StringBuilder stringBuilder) {
        if (object == null || object instanceof Empty) {
            stringBuilder.append("null");
        } else if (object instanceof String) {
            stringBuilder.append('\"').append(JsonKit.a((String)object)).append('\"');
        } else if (object instanceof Double) {
            if (((Double)object).isInfinite() || ((Double)object).isNaN()) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append(object.toString());
            }
        } else if (object instanceof Float) {
            if (((Float)object).isInfinite() || ((Float)object).isNaN()) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append(object.toString());
            }
        } else if (object instanceof Number) {
            stringBuilder.append(object.toString());
        } else if (object instanceof Boolean) {
            stringBuilder.append(object.toString());
        } else if (object instanceof Date) {
            JsonKit.a((Date)object, stringBuilder);
        } else if (object instanceof Map) {
            JsonKit.mapToJson((Map)object, stringBuilder);
        } else if (object instanceof List) {
            JsonKit.listToJson((List)object, stringBuilder);
        } else if (object.getClass().isArray()) {
            JsonKit.arrToJson(object, stringBuilder);
        } else if (object instanceof JsonSerializer) {
            ((JsonSerializer)object).toJson(stringBuilder);
        } else {
            stringBuilder.append('\"').append(JsonKit.a(object.toString())).append('\"');
        }
        return stringBuilder;
    }

    public static String valToJson(Object object) {
        if (object == null) {
            return "null";
        }
        if (object instanceof String) {
            return "\"" + JsonKit.a((String)object) + "\"";
        }
        if (object instanceof Double) {
            if (((Double)object).isInfinite() || ((Double)object).isNaN()) {
                return "null";
            }
            return object.toString();
        }
        if (object instanceof Float) {
            if (((Float)object).isInfinite() || ((Float)object).isNaN()) {
                return "null";
            }
            return object.toString();
        }
        if (object instanceof Number) {
            return object.toString();
        }
        if (object instanceof Boolean) {
            return object.toString();
        }
        if (object instanceof Date) {
            return JsonKit.a((Date)object, null);
        }
        if (object instanceof Map) {
            return JsonKit.mapToJson((Map)object, null);
        }
        if (object instanceof List) {
            return JsonKit.listToJson((List)object, null);
        }
        if (object.getClass().isArray()) {
            return JsonKit.arrToJson(object, null);
        }
        if (object instanceof JsonSerializer) {
            return ((JsonSerializer)object).toJson(null);
        }
        return "\"" + JsonKit.a(object.toString()) + "\"";
    }

    public static String mapToJson(Map<?, ?> map, StringBuilder stringBuilder) {
        StringBuilder stringBuilder2 = stringBuilder != null ? stringBuilder : new StringBuilder();
        stringBuilder2.append('{');
        int n2 = 0;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (n2++ > 0) {
                stringBuilder2.append(',');
            }
            JsonKit.appendKey(entry.getKey(), stringBuilder2).append(':');
            JsonKit.appendVal(entry.getValue(), stringBuilder2);
        }
        stringBuilder2.append('}');
        return stringBuilder != null ? null : stringBuilder2.toString();
    }

    public static String listToJson(List<?> list, StringBuilder stringBuilder) {
        StringBuilder stringBuilder2 = stringBuilder != null ? stringBuilder : new StringBuilder();
        stringBuilder2.append('[');
        int n2 = 0;
        for (Object obj : list) {
            if (n2++ > 0) {
                stringBuilder2.append(',');
            }
            JsonKit.appendVal(obj, stringBuilder2);
        }
        stringBuilder2.append(']');
        return stringBuilder != null ? null : stringBuilder2.toString();
    }

    public static String arrToJson(Object object, StringBuilder stringBuilder) {
        StringBuilder stringBuilder2 = stringBuilder != null ? stringBuilder : new StringBuilder();
        stringBuilder2.append('[');
        int n2 = Array.getLength(object);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 > 0) {
                stringBuilder2.append(',');
            }
            JsonKit.appendVal(Array.get(object, i2), stringBuilder2);
        }
        stringBuilder2.append(']');
        return stringBuilder != null ? null : stringBuilder2.toString();
    }

    private static String a(String string) {
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        JsonKit.a(string, stringBuilder);
        return stringBuilder.toString();
    }

    private static void a(String string, StringBuilder stringBuilder) {
        block9: for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '\"': {
                    stringBuilder.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    stringBuilder.append("\\\\");
                    continue block9;
                }
                case '\b': {
                    stringBuilder.append("\\b");
                    continue block9;
                }
                case '\f': {
                    stringBuilder.append("\\f");
                    continue block9;
                }
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block9;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block9;
                }
                case '\t': {
                    stringBuilder.append("\\t");
                    continue block9;
                }
                default: {
                    if (c2 >= '\u0000' && c2 <= '\u001f' || c2 >= '\u007f' && c2 <= '\u009f' || c2 >= '\u2000' && c2 <= '\u20ff') {
                        String string2 = Integer.toHexString(c2);
                        stringBuilder.append("\\u");
                        for (int i3 = 0; i3 < 4 - string2.length(); ++i3) {
                            stringBuilder.append('0');
                        }
                        stringBuilder.append(string2.toUpperCase());
                        continue block9;
                    }
                    stringBuilder.append(c2);
                }
            }
        }
    }

    private static String a(Date date, StringBuilder stringBuilder) {
        String string = date instanceof Timestamp ? DateKit.format(date, a) : (date instanceof java.sql.Date ? DateKit.format(date, b) : (date instanceof Time ? DateKit.format(date, c) : DateKit.format(date, a)));
        if (stringBuilder != null) {
            stringBuilder.append('\"').append(string).append('\"');
            return null;
        }
        return "\"" + string + "\"";
    }
}

