/*
 * Decompiled with CFR 0.152.
 */
package bogda.common.grid;

import bogda.common.SmartId;
import bogda.common.grid.Cell;
import bogda.common.grid.Column;
import bogda.common.grid.ForEachCell;
import bogda.common.grid.ICell;
import bogda.common.grid.IColumn;
import bogda.common.grid.IGrid;
import bogda.common.grid.IRow;
import bogda.common.grid.Row;
import bogda.common.model.Model;
import bogda.common.model.Prop;
import bogda.common.props.BaseProps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@Model(description="grid")
public class Grid
extends BaseProps
implements IGrid {
    @Prop(name="rowCount")
    private int a;
    @Prop(name="colCount")
    private int b;
    @Prop(name="rows")
    private List<Row> c;
    @Prop(name="columns")
    private List<Column> d;
    @Prop(name="cells")
    private List<List<Cell>> e;
    private HashMap<Integer, Integer> f;
    private SmartId g = new SmartId(12);

    public Grid(int n2, int n3) {
        int n4;
        this.a = n2;
        this.b = n3;
        this.c = new ArrayList<Row>(n2);
        for (n4 = 0; n4 < n2; ++n4) {
            this.c.add(null);
            this.setRow(n4, this.newRow());
        }
        this.d = new ArrayList<Column>(n3);
        for (n4 = 0; n4 < n3; ++n4) {
            this.d.add(null);
            this.setColumn(n4, this.newColumn());
        }
        this.e = new ArrayList<List<Cell>>(n2);
        for (n4 = 0; n4 < n2; ++n4) {
            this.e.add(this.a());
        }
    }

    public void useMerge() {
        this.f = new HashMap();
    }

    @Override
    public int getRowCount() {
        return this.a;
    }

    @Override
    public Row getRow(int n2) {
        return this.c.get(n2);
    }

    @Override
    public void setRow(int n2, IRow iRow) {
        this.c.set(n2, (Row)iRow);
        if (iRow != null) {
            iRow.setIndex(n2);
            iRow.setGrid(this);
        }
    }

    @Override
    public int getColCount() {
        return this.b;
    }

    @Override
    public Column getColumn(int n2) {
        return this.d.get(n2);
    }

    @Override
    public void setColumn(int n2, IColumn iColumn) {
        this.d.set(n2, (Column)iColumn);
        if (iColumn != null) {
            iColumn.setIndex(n2);
            iColumn.setGrid(this);
        }
    }

    @Override
    public void setCell(int n2, int n3, ICell iCell) {
        Cell cell = (Cell)iCell;
        this.e.get(n2).set(n3, cell);
        if (cell != null) {
            cell.setRowIndex(n2);
            cell.setColIndex(n3);
            cell.setGrid(this);
            if (this.f != null && cell.span()) {
                int n4 = this.g.getId(n2, n3);
                for (int i2 = n2; i2 < n2 + cell.getRowSpan(); ++i2) {
                    for (int i3 = n3; i3 < n3 + cell.getColSpan(); ++i3) {
                        this.f.put(this.g.getId(i2, i3), n4);
                    }
                }
            }
        }
    }

    @Override
    public Cell getCell(int n2, int n3) {
        return this.e.get(n2).get(n3);
    }

    @Override
    public boolean isTopLeft(int n2, int n3) {
        return this.getCell(n2, n3) != null;
    }

    @Override
    public Cell getTopLeft(int n2, int n3) {
        Integer n4;
        Cell cell = this.getCell(n2, n3);
        if (cell == null && this.f != null && (n4 = this.f.get(this.g.getId(n2, n3))) != null) {
            cell = this.getCell(this.g.getX(n4), this.g.getY(n4));
        }
        return cell;
    }

    public void mergeCells(int n2, int n3, int n4, int n5) {
        int n6 = this.g.getId(n2, n3);
        for (int i2 = n2; i2 <= n4; ++i2) {
            List<Cell> list = this.e.get(i2);
            for (int i3 = n3; i3 <= n5; ++i3) {
                if (i2 == n2 && i3 == n3) {
                    Cell cell = list.get(i3);
                    cell.setRowSpan(n4 - n2 + 1);
                    cell.setColSpan(n5 - n3 + 1);
                } else {
                    list.set(i3, null);
                }
                if (this.f == null) continue;
                this.f.put(this.g.getId(i2, i3), n6);
            }
        }
    }

    public void splitCells(int n2, int n3, int n4, int n5) {
        for (int i2 = n2; i2 <= n4; ++i2) {
            List<Cell> list = this.e.get(i2);
            for (int i3 = n3; i3 <= n5; ++i3) {
                Cell cell = list.get(i3);
                if (cell == null || !cell.span()) continue;
                for (int i4 = i2; i4 < i2 + cell.getRowSpan(); ++i4) {
                    for (int i5 = i3; i5 < i3 + cell.getColSpan(); ++i5) {
                        if (i4 != i2 || i5 != i3) {
                            this.setCell(i4, i5, this.newCell());
                        }
                        if (this.f == null) continue;
                        this.f.remove(this.g.getId(i4, i5));
                    }
                }
                cell.setRowSpan(1);
                cell.setColSpan(1);
            }
        }
    }

    public void addRows(int n2, int n3) {
        if (n3 == 1) {
            this.e.add(this.a());
            this.c(n2);
            ++this.a;
        } else if (n3 > 1) {
            this.e.addAll(n2, this.a(n3));
            for (int i2 = 0; i2 < n3; ++i2) {
                this.c(n2 + i2);
            }
            this.a += n3;
        }
        this.a(n2 + n3, n3);
    }

    public void addCols(int n2, int n3) {
        if (n3 == 1) {
            for (List<Cell> list : this.e) {
                list.add(n2, null);
            }
            this.d(n2);
            ++this.b;
        } else if (n3 > 1) {
            List<Cell> list = this.b(n3);
            for (List<Cell> list2 : this.e) {
                list2.addAll(n2, list);
            }
            for (int i2 = 0; i2 < n3; ++i2) {
                this.d(n2 + i2);
            }
            this.b += n3;
        }
        this.b(n2 + n3, n3);
    }

    public void removeRows(int n2, int n3) {
        if (n3 > 0) {
            int n4;
            int n5 = this.a - n2;
            n3 = n3 > n5 ? n5 : n3;
            for (n4 = 0; n4 < n3; ++n4) {
                this.e.remove(n2);
            }
            for (n4 = 0; n4 < n3; ++n4) {
                this.c.remove(n2);
            }
            this.a -= n3;
            this.a(n2, -n3);
        }
    }

    public void removeCols(int n2, int n3) {
        if (n3 > 0) {
            int n4 = this.b - n2;
            n3 = n3 > n4 ? n4 : n3;
            for (List<Cell> list : this.e) {
                for (int i2 = 0; i2 < n3; ++i2) {
                    list.remove(n2);
                }
            }
            for (int i3 = 0; i3 < n3; ++i3) {
                this.d.remove(n2);
            }
            this.b -= n3;
            this.b(n2, -n3);
        }
    }

    private List<Cell> a() {
        ArrayList<Cell> arrayList = new ArrayList<Cell>(this.b);
        for (int i2 = 0; i2 < this.b; ++i2) {
            arrayList.add(null);
        }
        return arrayList;
    }

    private List<List<Cell>> a(int n2) {
        ArrayList<List<Cell>> arrayList = new ArrayList<List<Cell>>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            arrayList.add(this.a());
        }
        return arrayList;
    }

    private List<Cell> b(int n2) {
        ArrayList<Cell> arrayList = new ArrayList<Cell>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            arrayList.add(null);
        }
        return arrayList;
    }

    private void c(int n2) {
        Row row = this.newRow();
        row.setIndex(n2);
        this.c.add(n2, row);
    }

    private void a(int n2, int n3) {
        for (int i2 = n2; i2 < this.a; ++i2) {
            for (Cell cell : this.e.get(i2)) {
                if (cell == null) continue;
                cell.move(n3, 0);
            }
            this.c.get(i2).move(n3);
        }
    }

    private void d(int n2) {
        Column column = this.newColumn();
        column.setIndex(n2);
        this.d.add(n2, column);
    }

    private void b(int n2, int n3) {
        for (int i2 = n2; i2 < this.b; ++i2) {
            for (int i3 = 0; i3 < this.a; ++i3) {
                Cell cell = this.e.get(i3).get(i2);
                if (cell == null) continue;
                cell.move(0, n3);
            }
            this.d.get(i2).move(n3);
        }
    }

    public void transpos() {
        ArrayList<List<Cell>> arrayList = new ArrayList<List<Cell>>(this.b);
        for (int i2 = 0; i2 < this.b; ++i2) {
            arrayList.add(new ArrayList(this.a));
        }
        for (List<Cell> list : this.e) {
            for (int i3 = 0; i3 < this.b; ++i3) {
                ((List)arrayList.get(i3)).add(list.get(i3));
            }
        }
        this.e = arrayList;
        int n2 = this.a;
        this.a = this.b;
        this.b = n2;
    }

    public void forEachCell(ForEachCell<Cell> forEachCell) {
        int n2 = 0;
        for (List<Cell> list : this.e) {
            int n3 = 0;
            for (Cell cell : list) {
                if (!forEachCell.handle(cell, n2, n3)) {
                    return;
                }
                ++n3;
            }
            ++n2;
        }
    }

    protected Cell newCell() {
        return new Cell();
    }

    protected Row newRow() {
        return new Row();
    }

    protected Column newColumn() {
        return new Column();
    }
}

