/*
 * Decompiled with CFR 0.152.
 */
package bogda.common.props;

import bogda.common.Empty;
import bogda.common.StrKit;
import bogda.common.model.DataTypeUtil;
import bogda.common.model.Prop;
import bogda.common.props.IProps;
import java.util.Arrays;

public abstract class PropsHolder
implements IProps,
Cloneable {
    protected static final String[] EMPTY_PROPS = new String[0];
    @Prop(name="_PROPS", filters={3})
    private Object[] a;
    @Prop(name="_MY_PROPS", filters={3})
    private Object[] b;

    public PropsHolder() {
        this.initProps();
    }

    protected void initProps() {
        String[] stringArray = this.propNames();
        if (stringArray.length > 0) {
            this.a = new Object[stringArray.length];
            Object[] objectArray = this.defaultProps();
            if (objectArray != null) {
                System.arraycopy(objectArray, 0, this.a, 0, objectArray.length);
            }
        }
    }

    @Override
    public Object getOriginProp(int n2) {
        return this.a[n2];
    }

    @Override
    public void setOriginProp(int n2, Object object) {
        this.a[n2] = object;
    }

    public void setOriginProps(PropsHolder propsHolder) {
        System.arraycopy(propsHolder.a, 0, this.a, 0, this.a.length);
    }

    @Override
    public boolean isOriginProp(int n2) {
        return this.b == null || this.b[n2] == Empty.NULL;
    }

    @Override
    public Object getProp(int n2) {
        Object object;
        if (this.b != null && (object = this.b[n2]) != Empty.NULL) {
            return object;
        }
        return this.a[n2];
    }

    public String getPropStr(int n2) {
        return StrKit.toStr(this.getProp(n2), false);
    }

    public <T extends Number> T getPropNumber(int n2, Class<T> clazz) {
        return (T)((Number)DataTypeUtil.transData(this.getProp(n2), clazz));
    }

    @Override
    public void setProp(int n2, Object object) {
        if (this.b == null) {
            this.b = new Object[this.a.length];
            Arrays.fill(this.b, Empty.NULL);
        }
        this.b[n2] = object;
    }

    public boolean hasProps() {
        return this.a != null;
    }

    public PropsHolder clone() {
        try {
            PropsHolder propsHolder = (PropsHolder)super.clone();
            propsHolder.b = null;
            return propsHolder;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    public static boolean isDefault(IProps iProps, int n2) {
        Object object = iProps.getProp(n2);
        Object[] objectArray = iProps.defaultProps();
        if (objectArray != null) {
            return object != null ? object.equals(objectArray[n2]) : objectArray[n2] == null;
        }
        return object == null;
    }

    public static int getPropId(IProps iProps, String string) {
        String[] stringArray = iProps.propNames();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (!stringArray[i2].equals(string)) continue;
            return i2;
        }
        return -1;
    }
}

