/*
 * Decompiled with CFR 0.152.
 */
package bogda.core.cache.redis;

import bogda.core.cache.redis.ISerializer;
import bogda.core.log.BogdaLog;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.nustaq.serialization.FSTObjectInput;
import org.nustaq.serialization.FSTObjectOutput;
import redis.clients.jedis.util.SafeEncoder;

public class FstSerializer
implements ISerializer {
    public static final ISerializer me = new FstSerializer();

    @Override
    public byte[] keyToBytes(String string) {
        return SafeEncoder.encode((String)string);
    }

    @Override
    public String keyFromBytes(byte[] byArray) {
        return SafeEncoder.encode((byte[])byArray);
    }

    @Override
    public byte[] fieldToBytes(Object object) {
        return this.valueToBytes(object);
    }

    @Override
    public Object fieldFromBytes(byte[] byArray) {
        return this.valueFromBytes(byArray);
    }

    @Override
    public byte[] valueToBytes(Object object) {
        FSTObjectOutput fSTObjectOutput = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            fSTObjectOutput = new FSTObjectOutput((OutputStream)byteArrayOutputStream);
            fSTObjectOutput.writeObject(object);
            fSTObjectOutput.flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        finally {
            if (fSTObjectOutput != null) {
                try {
                    fSTObjectOutput.close();
                }
                catch (IOException iOException) {
                    BogdaLog.sys().error(iOException.getMessage(), iOException);
                }
            }
        }
    }

    @Override
    public Object valueFromBytes(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        FSTObjectInput fSTObjectInput = null;
        try {
            fSTObjectInput = new FSTObjectInput((InputStream)new ByteArrayInputStream(byArray));
            Object object = fSTObjectInput.readObject();
            return object;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        finally {
            if (fSTObjectInput != null) {
                try {
                    fSTObjectInput.close();
                }
                catch (IOException iOException) {
                    BogdaLog.sys().error(iOException.getMessage(), iOException);
                }
            }
        }
    }
}

