/*
 * Decompiled with CFR 0.152.
 */
package bogda.core.cache.redis;

import bogda.core.cache.redis.ISerializer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import redis.clients.jedis.JedisCluster;

public class MyJedisCluster {
    protected JedisCluster jedisCluster;
    protected ISerializer serializer;

    protected MyJedisCluster() {
    }

    public MyJedisCluster(JedisCluster jedisCluster, ISerializer iSerializer) {
        this.jedisCluster = jedisCluster;
        this.serializer = iSerializer;
    }

    public String set(Object object, Object object2) {
        JedisCluster jedisCluster = this.getJedisCluster();
        return jedisCluster.set(this.keyToBytes(object), this.valueToBytes(object2));
    }

    public String setex(Object object, int n2, Object object2) {
        JedisCluster jedisCluster = this.getJedisCluster();
        return jedisCluster.setex(this.keyToBytes(object), n2, this.valueToBytes(object2));
    }

    public <T> T get(Object object) {
        JedisCluster jedisCluster = this.getJedisCluster();
        return (T)this.valueFromBytes(jedisCluster.get(this.keyToBytes(object)));
    }

    public Long del(Object object) {
        JedisCluster jedisCluster = this.getJedisCluster();
        return jedisCluster.del(this.keyToBytes(object));
    }

    public Long del(Object ... objectArray) {
        JedisCluster jedisCluster = this.getJedisCluster();
        return jedisCluster.del(this.keysToBytesArray(objectArray));
    }

    public boolean exists(Object object) {
        JedisCluster jedisCluster = this.getJedisCluster();
        return jedisCluster.exists(this.keyToBytes(object));
    }

    public Long expire(Object object, int n2) {
        JedisCluster jedisCluster = this.getJedisCluster();
        return jedisCluster.expire(this.keyToBytes(object), n2);
    }

    public Long expireAt(Object object, long l2) {
        JedisCluster jedisCluster = this.getJedisCluster();
        return jedisCluster.expireAt(this.keyToBytes(object), l2);
    }

    public Long pexpire(Object object, long l2) {
        JedisCluster jedisCluster = this.getJedisCluster();
        return jedisCluster.pexpire(this.keyToBytes(object), l2);
    }

    public Long pexpireAt(Object object, long l2) {
        JedisCluster jedisCluster = this.getJedisCluster();
        return jedisCluster.pexpireAt(this.keyToBytes(object), l2);
    }

    public <T> T getSet(Object object, Object object2) {
        JedisCluster jedisCluster = this.getJedisCluster();
        return (T)this.valueFromBytes(jedisCluster.getSet(this.keyToBytes(object), this.valueToBytes(object2)));
    }

    public Long persist(Object object) {
        JedisCluster jedisCluster = this.getJedisCluster();
        return jedisCluster.persist(this.keyToBytes(object));
    }

    public String type(Object object) {
        JedisCluster jedisCluster = this.getJedisCluster();
        return jedisCluster.type(this.keyToBytes(object));
    }

    public Long hdel(Object object, Object ... objectArray) {
        JedisCluster jedisCluster = this.getJedisCluster();
        return jedisCluster.hdel(this.keyToBytes(object), this.fieldsToBytesArray(objectArray));
    }

    public boolean hexists(Object object, Object object2) {
        JedisCluster jedisCluster = this.getJedisCluster();
        return jedisCluster.hexists(this.keyToBytes(object), this.fieldToBytes(object2));
    }

    public Long hset(Object object, Object object2, Object object3) {
        JedisCluster jedisCluster = this.getJedisCluster();
        return jedisCluster.hset(this.keyToBytes(object), this.fieldToBytes(object2), this.valueToBytes(object3));
    }

    public String hmset(Object object, Map<Object, Object> map) {
        JedisCluster jedisCluster = this.getJedisCluster();
        HashMap<byte[], byte[]> hashMap = new HashMap<byte[], byte[]>();
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            hashMap.put(this.fieldToBytes(entry.getKey()), this.valueToBytes(entry.getValue()));
        }
        return jedisCluster.hmset(this.keyToBytes(object), hashMap);
    }

    public <T> T hget(Object object, Object object2) {
        JedisCluster jedisCluster = this.getJedisCluster();
        return (T)this.valueFromBytes(jedisCluster.hget(this.keyToBytes(object), this.fieldToBytes(object2)));
    }

    public Map hgetAll(Object object) {
        JedisCluster jedisCluster = this.getJedisCluster();
        Map map = jedisCluster.hgetAll(this.keyToBytes(object));
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        for (Map.Entry entry : map.entrySet()) {
            hashMap.put(this.fieldFromBytes((byte[])entry.getKey()), this.valueFromBytes((byte[])entry.getValue()));
        }
        return hashMap;
    }

    protected byte[] keyToBytes(Object object) {
        return this.serializer.keyToBytes(object.toString());
    }

    protected byte[][] keysToBytesArray(Object ... objectArray) {
        byte[][] byArrayArray = new byte[objectArray.length][];
        for (int i2 = 0; i2 < byArrayArray.length; ++i2) {
            byArrayArray[i2] = this.keyToBytes(objectArray[i2]);
        }
        return byArrayArray;
    }

    protected byte[] fieldToBytes(Object object) {
        return this.serializer.fieldToBytes(object);
    }

    protected Object fieldFromBytes(byte[] byArray) {
        return this.serializer.fieldFromBytes(byArray);
    }

    protected byte[][] fieldsToBytesArray(Object ... objectArray) {
        byte[][] byArrayArray = new byte[objectArray.length][];
        for (int i2 = 0; i2 < byArrayArray.length; ++i2) {
            byArrayArray[i2] = this.fieldToBytes(objectArray[i2]);
        }
        return byArrayArray;
    }

    protected void fieldSetFromBytesSet(Set<byte[]> set, Set<Object> set2) {
        for (byte[] byArray : set) {
            set2.add(this.fieldFromBytes(byArray));
        }
    }

    protected byte[] valueToBytes(Object object) {
        return this.serializer.valueToBytes(object);
    }

    protected Object valueFromBytes(byte[] byArray) {
        return this.serializer.valueFromBytes(byArray);
    }

    protected byte[][] valuesToBytesArray(Object ... objectArray) {
        byte[][] byArrayArray = new byte[objectArray.length][];
        for (int i2 = 0; i2 < byArrayArray.length; ++i2) {
            byArrayArray[i2] = this.valueToBytes(objectArray[i2]);
        }
        return byArrayArray;
    }

    protected void valueSetFromBytesSet(Set<byte[]> set, Set<Object> set2) {
        for (byte[] byArray : set) {
            set2.add(this.valueFromBytes(byArray));
        }
    }

    protected List valueListFromBytesList(List<byte[]> list) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (byte[] byArray : list) {
            arrayList.add(this.valueFromBytes(byArray));
        }
        return arrayList;
    }

    public ISerializer getSerializer() {
        return this.serializer;
    }

    public JedisCluster getJedisCluster() {
        return this.jedisCluster;
    }
}

