/*
 * Decompiled with CFR 0.152.
 */
package bogda.core.db;

import bogda.common.StrKit;
import bogda.core.db.BogdaDbException;
import bogda.core.db.DataSourceFactory;
import bogda.core.db.DataSourceProvider;
import bogda.core.db.Db;
import bogda.core.db.DbConfig;
import bogda.core.db.Dialect;
import bogda.core.db.ShardingDsProvider;
import bogda.core.db.dialect.H2Dialect;
import bogda.core.db.dialect.MysqlDialect;
import bogda.core.db.dialect.OracleDialect;
import bogda.core.log.BogdaLog;
import com.alibaba.druid.pool.DruidDataSource;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;

public class BogdaDataSource {
    private final ThreadLocal<Connection> a = new ThreadLocal();
    private DataSource b;
    private DbConfig c;
    private Dialect d;
    private Boolean e;

    public BogdaDataSource(DbConfig dbConfig) {
        this(dbConfig, null);
    }

    public BogdaDataSource(DbConfig dbConfig, DataSourceProvider dataSourceProvider) {
        this.c = dbConfig;
        if (dataSourceProvider == null) {
            dataSourceProvider = this.a(dbConfig);
        }
        this.b = dataSourceProvider != null ? dataSourceProvider.getDataSource(this.c) : DataSourceFactory.buildDataSource(dbConfig);
        if (Db.getDataSourceProxy() != null) {
            this.b = Db.getDataSourceProxy().genetate(this.b, dbConfig);
        }
        this.a();
    }

    private DataSourceProvider a(DbConfig dbConfig) {
        String string = dbConfig.getDbType();
        if ("master_slave".equals(string) || "sharding".equals(string) || "sharding_master_slave".equals(string)) {
            return new ShardingDsProvider();
        }
        return null;
    }

    public DataSource getDataSource() {
        return this.b;
    }

    public DbConfig getConfig() {
        return this.c;
    }

    private void a() {
        if (StrKit.isBlank(this.c.getDialectClass())) {
            if ("oracle".equals(this.c.getDbType())) {
                this.d = new OracleDialect();
            } else if ("mysql".equals(this.c.getDbType())) {
                this.d = new MysqlDialect();
            } else if ("h2".equals(this.c.getDbType())) {
                this.d = new H2Dialect();
            }
        }
    }

    public Dialect getDialect() {
        return this.d;
    }

    public void setDialect(Dialect dialect) {
        this.d = dialect;
    }

    public boolean isOracle() {
        if (this.e == null) {
            this.e = "oracle".equalsIgnoreCase(this.c.getDbType());
        }
        return this.e;
    }

    public final void setThreadLocalConnection(Connection connection) {
        this.a.set(connection);
    }

    public final void removeThreadLocalConnection() {
        this.a.remove();
    }

    public final Connection getConnection() {
        Connection connection = this.a.get();
        if (connection != null) {
            return connection;
        }
        return this.b.getConnection();
    }

    public final Connection getThreadLocalConnection() {
        return this.a.get();
    }

    public final boolean isInTransaction() {
        return this.a.get() != null;
    }

    public final void close(ResultSet resultSet, Statement statement, Connection connection) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                BogdaLog.sys().error(sQLException.getMessage(), sQLException);
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                BogdaLog.sys().error(sQLException.getMessage(), sQLException);
            }
        }
        if (this.a.get() == null && connection != null) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                throw new BogdaDbException(sQLException);
            }
        }
    }

    public final void close(Statement statement, Connection connection) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                BogdaLog.sys().error(sQLException.getMessage(), sQLException);
            }
        }
        if (this.a.get() == null && connection != null) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                throw new BogdaDbException(sQLException);
            }
        }
    }

    public final void close(Connection connection) {
        if (this.a.get() == null && connection != null) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                throw new BogdaDbException(sQLException);
            }
        }
    }

    public void close() {
        if (this.b instanceof DruidDataSource) {
            ((DruidDataSource)this.b).close();
        }
    }
}

