/*
 * Decompiled with CFR 0.152.
 */
package bogda.core.db;

import bogda.common.StrKit;
import bogda.common.model.Init;
import bogda.common.model.Model;
import bogda.common.model.Prop;
import java.util.HashMap;

@Model(type="data_source")
public class DbConfig {
    public static final String DB_MYSQL = "mysql";
    public static final String DB_ORACLE = "oracle";
    public static final String DB_SQLSERVER = "sqlserver";
    public static final String DB_DB2 = "db2";
    public static final String DB_H2 = "h2";
    public static final String DB_SHARDING = "sharding";
    public static final String DB_MASTER_SLAVE = "master_slave";
    public static final String DB_SHARDING_MASTER_SLAVE = "sharding_master_slave";
    public static final String PROP_MAX_POOL_SIZE = "max_pool_size";
    public static final String PROP_MIN_POOL_SIZE = "min_pool_size";
    public static final String PROP_INIT_POOL_SIZE = "init_pool_size";
    public static final String PROP_TRANSACTION_ISOLATION = "transaction_isolation";
    @Prop(name="name")
    private String a;
    @Prop(name="db_type")
    private String b;
    @Prop(name="config_yaml")
    private String c;
    @Prop(name="jndi")
    private String d;
    @Prop(name="jdbc_url")
    private String e;
    @Prop(name="driver")
    private String f;
    @Prop(name="user")
    private String g;
    @Prop(name="password")
    private String h;
    @Prop(name="dialect")
    private String i;
    @Prop(name="case_insensitive")
    private Boolean j;
    @Prop(name="sql_log")
    private boolean k = false;
    @Prop(name="props")
    private HashMap<String, Object> l;
    private HashMap<String, Object> m = new HashMap();
    private boolean n = false;

    public DbConfig() {
        this.setProp(PROP_MAX_POOL_SIZE, 100);
        this.setProp(PROP_MIN_POOL_SIZE, 10);
        this.setProp(PROP_INIT_POOL_SIZE, 10);
        this.setProp(PROP_TRANSACTION_ISOLATION, 2);
    }

    @Init
    public void init() {
        if (this.l != null) {
            this.m.putAll(this.l);
        }
        this.b();
        this.a();
    }

    public String getName() {
        return this.a;
    }

    public void setName(String string) {
        this.a = string;
    }

    public String getDbType() {
        return this.b;
    }

    public void setDbType(String string) {
        this.b = string;
        this.b();
        this.a();
    }

    public String getConfigYaml() {
        return this.c;
    }

    public void setConfigYaml(String string) {
        this.c = string;
    }

    public String getJndi() {
        return this.d;
    }

    public void setJndi(String string) {
        this.d = string;
    }

    public String getJdbcUrl() {
        return this.e;
    }

    public void setJdbcUrl(String string) {
        this.e = string;
    }

    public String getDriver() {
        return this.f;
    }

    public void setDriver(String string) {
        this.f = string;
    }

    private void a() {
        if (StrKit.isBlank(this.f)) {
            if (DB_ORACLE.equalsIgnoreCase(this.b)) {
                this.f = "oracle.jdbc.OracleDriver";
            } else if (DB_MYSQL.equalsIgnoreCase(this.b)) {
                this.f = "com.mysql.jdbc.Driver";
            } else if (DB_H2.equalsIgnoreCase(this.b)) {
                this.f = "org.h2.Driver";
            } else if (DB_SQLSERVER.equals(this.b)) {
                this.f = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
            } else if (DB_DB2.equals(this.b)) {
                this.f = "com.ibm.db2.jcc.DB2Driver";
            }
        }
    }

    public String getUser() {
        return this.g;
    }

    public void setUser(String string) {
        this.g = string;
    }

    public String getPassword() {
        return this.h;
    }

    public void setPassword(String string) {
        this.h = string;
    }

    public String getDialectClass() {
        return this.i;
    }

    public void setDialectClass(String string) {
        this.i = string;
    }

    public boolean isCaseInsensitive() {
        return this.j != null ? this.j : false;
    }

    public void setCaseInsensitive(boolean bl) {
        this.j = bl;
    }

    private void b() {
        if (this.j == null && (DB_ORACLE.equalsIgnoreCase(this.b) || DB_H2.equalsIgnoreCase(this.b))) {
            this.j = true;
        }
    }

    public boolean isSqlLog() {
        return this.k;
    }

    public void setSqlLog(boolean bl) {
        this.k = bl;
    }

    public void setProp(String string, Object object) {
        this.m.put(string, object);
    }

    public Object getProp(String string) {
        return this.m.get(string);
    }

    public int getPropInt(String string) {
        return (Integer)this.m.get(string);
    }

    public String getPropStr(String string) {
        return (String)this.m.get(string);
    }

    public boolean getPropBool(String string) {
        Object object = this.m.get(string);
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            return Boolean.parseBoolean((String)object);
        }
        return false;
    }

    public boolean hasProp(String string) {
        return this.getProp(string) != null;
    }

    public boolean isJdbcMode() {
        return this.n;
    }

    public void setJdbcMode(boolean bl) {
        this.n = bl;
    }
}

