/*
 * Decompiled with CFR 0.152.
 */
package bogda.core.db;

import bogda.common.JsonKit;
import bogda.core.b.a.c.ab;
import bogda.core.db.BogdaDataSource;
import bogda.core.db.BogdaDbException;
import bogda.core.db.DataSourceProvider;
import bogda.core.db.DbConfig;
import bogda.core.db.IAtom;
import bogda.core.db.NestedTransactionException;
import bogda.core.db.Page;
import bogda.core.db.QueryRecord;
import bogda.core.db.Record;
import bogda.core.db.RecordBuilder;
import bogda.core.db.RecordMetaData;
import bogda.core.db.SqlHelper;
import bogda.core.log.BogdaLog;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DbImpl {
    private static final Object[] a = new Object[0];
    private BogdaDataSource b;
    private boolean c = false;

    public DbImpl(DbConfig dbConfig) {
        this(dbConfig, null);
    }

    public DbImpl(DbConfig dbConfig, DataSourceProvider dataSourceProvider) {
        this.b = new BogdaDataSource(dbConfig, dataSourceProvider);
        this.c = dbConfig.isSqlLog();
    }

    public BogdaDataSource getDataSource() {
        return this.b;
    }

    public List<Record> find(String string, Object ... objectArray) {
        return this.a(string, false, objectArray);
    }

    public List<Record> find(String string) {
        return this.a(string, false, a);
    }

    public List<QueryRecord> query(String string, Object ... objectArray) {
        return this.a(string, true, objectArray);
    }

    public List<QueryRecord> query(String string) {
        return this.a(string, true, a);
    }

    private List<? extends Record> a(String string, boolean bl, Object ... objectArray) {
        Connection connection = null;
        try {
            this.a(string, (Object)objectArray, (Exception)null);
            connection = this.b.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            if (objectArray.length > 0) {
                this.b.getDialect().fillStatement(preparedStatement, objectArray);
            }
            ResultSet resultSet = preparedStatement.executeQuery();
            List<? extends Record> list = RecordBuilder.buildList(this, resultSet, bl);
            this.a(resultSet, preparedStatement);
            List<? extends Record> list2 = list;
            this.b.close(connection);
            return list2;
        }
        catch (Exception exception) {
            try {
                this.a(string, (Object)objectArray, exception);
                throw new BogdaDbException(exception);
            }
            catch (Throwable throwable) {
                this.b.close(connection);
                throw throwable;
            }
        }
    }

    public Record findFirst(String string, Object ... objectArray) {
        Connection connection = null;
        try {
            this.a(string, (Object)objectArray, (Exception)null);
            connection = this.b.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            if (objectArray.length > 0) {
                this.b.getDialect().fillStatement(preparedStatement, objectArray);
            }
            ResultSet resultSet = preparedStatement.executeQuery();
            Object t2 = RecordBuilder.build(this, resultSet, false);
            this.a(resultSet, preparedStatement);
            Object t3 = t2;
            this.b.close(connection);
            return t3;
        }
        catch (Exception exception) {
            try {
                this.a(string, (Object)objectArray, exception);
                throw new BogdaDbException(exception);
            }
            catch (Throwable throwable) {
                this.b.close(connection);
                throw throwable;
            }
        }
    }

    public Record findFirst(String string) {
        return this.findFirst(string, a);
    }

    public int save(String string, Record record) {
        return this.save(string, null, record);
    }

    public int save(String string, String string2, Record record) {
        return this.a(string, string2, record, null);
    }

    private int a(String string, String string2, Record record, String[] stringArray) {
        Connection connection = null;
        String string3 = null;
        Object[] objectArray = null;
        try {
            PreparedStatement preparedStatement;
            connection = this.b.getConnection();
            String[] stringArray2 = this.a(string2);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            string3 = this.a(string, record, arrayList, null, stringArray);
            objectArray = arrayList.toArray();
            this.a(string3, (Object)objectArray, (Exception)null);
            if (stringArray2 != null) {
                if (this.b.isOracle()) {
                    String[] stringArray3;
                    if (stringArray2.length == 1 && "_bogda_generated_key".equals(stringArray2[0])) {
                        String[] stringArray4 = new String[1];
                        stringArray3 = stringArray4;
                        stringArray4[0] = "id";
                    } else {
                        stringArray3 = stringArray2;
                    }
                    String[] stringArray5 = stringArray3;
                    preparedStatement = connection.prepareStatement(string3, stringArray5);
                } else {
                    preparedStatement = connection.prepareStatement(string3, 1);
                }
            } else {
                preparedStatement = connection.prepareStatement(string3);
            }
            this.b.getDialect().fillStatement(preparedStatement, objectArray);
            int n2 = preparedStatement.executeUpdate();
            if (stringArray2 != null) {
                this.a(preparedStatement, record, stringArray2);
            }
            this.a(preparedStatement);
            this.a(1);
            int n3 = n2;
            return n3;
        }
        catch (Exception exception) {
            this.a(string3, objectArray, exception);
            throw new BogdaDbException(exception);
        }
        finally {
            this.b.close(connection);
        }
    }

    private void a(PreparedStatement preparedStatement, Record record, String ... stringArray) {
        ResultSet resultSet = preparedStatement.getGeneratedKeys();
        if (stringArray.length == 1 && "_bogda_generated_key".equals(stringArray[0])) {
            if (resultSet.next()) {
                record.setGeneratedKey(resultSet.getObject(1));
            }
        } else {
            for (String string : stringArray) {
                if (record.containsColumn(string) && !this.b.isOracle() || !resultSet.next()) continue;
                record.setData(string, resultSet.getObject(1));
            }
        }
        resultSet.close();
    }

    public int update(String string, String string2, Record record) {
        return this.a(string, this.a(string2), record, null);
    }

    private int a(String string, String[] stringArray, Record record, String[] stringArray2) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string2 = this.a(string, stringArray, record, arrayList, null, stringArray2);
        if (arrayList.size() == stringArray.length && !record.isHasStatementCol()) {
            return 0;
        }
        return this.update(string2.toString(), arrayList.toArray());
    }

    private boolean a(String string, String[] stringArray) {
        for (String string2 : stringArray) {
            if (!string.equalsIgnoreCase(string2)) continue;
            return true;
        }
        return false;
    }

    public int deleteById(String string, String string2, Object object) {
        StringBuilder stringBuilder = new StringBuilder("delete from ");
        this.b.getDialect().appendTableName(stringBuilder, string);
        stringBuilder.append(" where ");
        this.b.getDialect().appendObjectName(stringBuilder, string2);
        if (object == null) {
            stringBuilder.append(" is null");
            return this.update(stringBuilder.toString(), a);
        }
        if (object instanceof ab) {
            stringBuilder.append(((ab)object).a());
            return this.update(stringBuilder.toString(), a);
        }
        stringBuilder.append("=?");
        return this.update(stringBuilder.toString(), object);
    }

    public int deleteByFields(String string, Map<String, Object> map) {
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        stringBuilder.append("delete from ");
        this.b.getDialect().appendTableName(stringBuilder, string);
        this.a(stringBuilder, map.keySet().toArray(new String[map.size()]), map, arrayList);
        return this.update(stringBuilder.toString(), arrayList.toArray());
    }

    public int delete(String string, String string2, Record record) {
        String[] stringArray = this.a(string2);
        if (stringArray.length > 1) {
            StringBuilder stringBuilder = new StringBuilder();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            stringBuilder.append("delete from ");
            this.b.getDialect().appendTableName(stringBuilder, string);
            this.a(stringBuilder, stringArray, record.getColumns(), arrayList);
            return this.update(stringBuilder.toString(), arrayList.toArray());
        }
        return this.deleteById(string, stringArray[0], record.getData(stringArray[0]));
    }

    private String[] a(String string) {
        if (string == null) {
            return null;
        }
        if (string.indexOf(44) > 0) {
            String[] stringArray = string.split(",");
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                stringArray[i2] = stringArray[i2].trim();
            }
            return stringArray;
        }
        return new String[]{string.trim()};
    }

    private void a(StringBuilder stringBuilder, String[] stringArray, Map<String, Object> map, List<Object> list) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        stringBuilder.append(" where ");
        int n2 = 0;
        for (String string : stringArray) {
            if (n2++ > 0) {
                stringBuilder.append(" and ");
            }
            this.b.getDialect().appendObjectName(stringBuilder, string);
            if (map != null && list != null) {
                Object object = map.get(string);
                if (object == null) {
                    stringBuilder.append(" is null");
                    continue;
                }
                if (object instanceof ab) {
                    stringBuilder.append(((ab)object).a());
                    continue;
                }
                stringBuilder.append("=?");
                list.add(object);
                continue;
            }
            stringBuilder.append("=?");
        }
    }

    private String a(String string, Record record, List<Object> list, List<String> list2, String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("insert into ");
        this.b.getDialect().appendTableName(stringBuilder, string);
        stringBuilder.append("(");
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder2.append(") values(");
        int n2 = 0;
        for (Map.Entry<String, Object> entry : record.getColumns().entrySet()) {
            Object object;
            String string2 = entry.getKey();
            if (this.a(string2, object = entry.getValue(), stringArray)) continue;
            if (n2++ > 0) {
                stringBuilder.append(",");
                stringBuilder2.append(",");
            }
            this.b.getDialect().appendObjectName(stringBuilder, string2);
            if (list != null) {
                if (this.b.isOracle() && object instanceof String && ((String)object).endsWith(".nextval")) {
                    stringBuilder2.append(object);
                } else if (object instanceof ab) {
                    stringBuilder2.append(((ab)object).a());
                } else {
                    stringBuilder2.append("?");
                    list.add(object);
                }
            } else {
                stringBuilder2.append("?");
            }
            if (list2 == null) continue;
            list2.add(string2);
        }
        stringBuilder.append(stringBuilder2.toString()).append(")");
        return stringBuilder.toString();
    }

    private String a(String string, String[] stringArray, Record record, List<Object> list, List<String> list2, String[] stringArray2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("update ");
        this.b.getDialect().appendTableName(stringBuilder, string);
        stringBuilder.append(" set ");
        Map<String, Object> map = record.getColumns();
        boolean bl = list == null;
        int n2 = 0;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object object;
            String string2 = entry.getKey();
            if (this.a(string2, stringArray) || this.a(string2, object = entry.getValue(), stringArray2)) continue;
            if (n2++ > 0) {
                stringBuilder.append(",");
            }
            this.b.getDialect().appendObjectName(stringBuilder, string2);
            stringBuilder.append("=");
            if (object instanceof ab) {
                stringBuilder.append(((ab)object).a());
            } else {
                stringBuilder.append("?");
                if (!bl) {
                    list.add(object);
                }
            }
            if (list2 == null) continue;
            list2.add(string2);
        }
        this.a(stringBuilder, stringArray, !bl ? map : null, !bl ? list : null);
        return stringBuilder.toString();
    }

    private boolean a(String string, Object object, String[] stringArray) {
        if (object == "$disabled") {
            return true;
        }
        if (stringArray != null) {
            for (String string2 : stringArray) {
                if (!string.equals(string2)) continue;
                return true;
            }
        }
        return false;
    }

    public int update(String string, Object ... objectArray) {
        Connection connection = null;
        try {
            this.a(string, (Object)objectArray, (Exception)null);
            connection = this.b.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            if (objectArray.length > 0) {
                this.b.getDialect().fillStatement(preparedStatement, objectArray);
            }
            int n2 = preparedStatement.executeUpdate();
            this.a(preparedStatement);
            this.a(n2);
            int n3 = n2;
            this.b.close(connection);
            return n3;
        }
        catch (Exception exception) {
            try {
                this.a(string, (Object)objectArray, exception);
                throw new BogdaDbException(exception);
            }
            catch (Throwable throwable) {
                this.b.close(connection);
                throw throwable;
            }
        }
    }

    public int update(String string) {
        return this.update(string, a);
    }

    public int[] saveOrUpdate(String string, String string2, Record record) {
        return this.saveOrUpdate(string, string2, record, null);
    }

    public int[] saveOrUpdate(String string, String string2, Record record, List<String[]> list) {
        String[] stringArray;
        boolean bl;
        if (record.getAutoMode() != null) {
            bl = "update".equals(record.getAutoMode());
        } else {
            stringArray = new StringBuilder();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            stringArray.append("select count(*) from ");
            this.b.getDialect().appendTableName((StringBuilder)stringArray, string);
            this.a((StringBuilder)stringArray, this.a(string2), record.getColumns(), arrayList);
            Record record2 = this.findFirst(stringArray.toString(), arrayList.toArray());
            bl = ((Number)record2.getData()).longValue() > 0L;
        }
        stringArray = null;
        if (list != null) {
            stringArray = bl ? list.get(1) : list.get(0);
        }
        if (bl) {
            return new int[]{0, this.a(string, this.a(string2), record, stringArray)};
        }
        return new int[]{this.a(string, "_bogda_generated_key", record, stringArray), 0};
    }

    public int[] saveOrUpdate(String string, String string2, List<Record> list) {
        return this.saveOrUpdate(string, string2, list, null);
    }

    /*
     * WARNING - void declaration
     */
    public int[] saveOrUpdate(String string, String string2, List<Record> list, List<String[]> list2) {
        if (list == null || list.size() == 0) {
            return new int[]{0, 0};
        }
        if (list.size() == 1) {
            return this.saveOrUpdate(string, string2, list.get(0));
        }
        int[] nArray = new int[]{0, 0};
        String[] stringArray = this.a(string2);
        String string3 = null;
        String string4 = null;
        String string5 = null;
        ArrayList<String> arrayList = null;
        ArrayList<String> arrayList2 = null;
        for (Record record : list) {
            boolean bl = false;
            ArrayList<Object> arrayList3 = new ArrayList<Object>();
            for (String string6 : stringArray) {
                Object object = record.getData(string6);
                if (object == null) {
                    bl = true;
                    break;
                }
                arrayList3.add(object);
            }
            if (!(bl || record.isHasStatementCol() || record.isHasDisabledCol())) {
                Object[] objectArray;
                void var16_19;
                if (record.getAutoMode() != null) {
                    boolean bl2 = "update".equals(record.getAutoMode());
                } else {
                    Record record2;
                    boolean bl2;
                    if (string3 == null) {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("select count(*) from ");
                        this.b.getDialect().appendTableName(stringBuilder, string);
                        this.a(stringBuilder, stringArray, null, null);
                        string3 = stringBuilder.toString();
                    }
                    boolean bl3 = bl2 = ((Number)(record2 = this.findFirst(string3, arrayList3.toArray())).getData()).longValue() > 0L;
                }
                if (var16_19 != false) {
                    if (string5 == null) {
                        arrayList2 = new ArrayList<String>();
                        string5 = this.a(string, stringArray, record, null, arrayList2, list2 != null ? list2.get(1) : null);
                    }
                    objectArray = new ArrayList();
                    for (String string7 : arrayList2) {
                        objectArray.add(record.getData(string7));
                    }
                    objectArray.addAll(arrayList3);
                    nArray[1] = nArray[1] + this.update(string5, objectArray.toArray());
                    continue;
                }
                if (string4 == null) {
                    arrayList = new ArrayList<String>();
                    string4 = this.a(string, record, null, arrayList, list2 != null ? list2.get(0) : null);
                }
                objectArray = new Object[arrayList.size()];
                int n2 = 0;
                for (Object object : arrayList) {
                    objectArray[n2++] = record.getData((String)object);
                }
                nArray[0] = nArray[0] + this.update(string4, objectArray);
                continue;
            }
            int[] nArray2 = this.saveOrUpdate(string, string2, record);
            nArray[0] = nArray[0] + nArray2[0];
            nArray[1] = nArray[1] + nArray2[1];
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean tx(int n2, IAtom iAtom) {
        Connection connection = this.b.getThreadLocalConnection();
        if (connection != null) {
            try {
                boolean bl;
                if (connection.getTransactionIsolation() < n2) {
                    connection.setTransactionIsolation(n2);
                }
                if (!(bl = iAtom.run())) throw new NestedTransactionException("Notice the outer transaction that the nested transaction return false");
                return true;
            }
            catch (SQLException sQLException) {
                throw new BogdaDbException(sQLException);
            }
        }
        Boolean bl = null;
        try {
            connection = this.b.getConnection();
            bl = connection.getAutoCommit();
            this.b.setThreadLocalConnection(connection);
            connection.setTransactionIsolation(n2);
            connection.setAutoCommit(false);
            boolean bl2 = iAtom.run();
            if (bl2) {
                connection.commit();
            } else {
                this.a(connection);
            }
            boolean bl3 = bl2;
            return bl3;
        }
        catch (NestedTransactionException nestedTransactionException) {
            if (connection != null) {
                this.a(connection);
            }
            boolean bl4 = false;
            return bl4;
        }
        catch (Throwable throwable) {
            RuntimeException runtimeException;
            if (connection != null) {
                this.a(connection);
            }
            if (throwable instanceof RuntimeException) {
                runtimeException = (RuntimeException)throwable;
                throw runtimeException;
            }
            runtimeException = new BogdaDbException(throwable);
            throw runtimeException;
        }
        finally {
            try {
                if (connection != null) {
                    if (bl != null) {
                        connection.setAutoCommit(bl);
                    }
                    connection.close();
                }
            }
            catch (Throwable throwable) {
                BogdaLog.sys().error(throwable.getMessage(), throwable);
            }
            finally {
                this.b.removeThreadLocalConnection();
            }
        }
    }

    private void a(Connection connection) {
        try {
            connection.rollback();
            BogdaLog.sql().warn("\u4e8b\u52a1\u6267\u884c\u5931\u8d25\uff0c\u5df2\u8fdb\u884c\u56de\u6eda\u64cd\u4f5c");
        }
        catch (Exception exception) {
            BogdaLog.sys().error(exception.getMessage(), exception);
        }
    }

    public boolean tx(IAtom iAtom) {
        return this.tx(this.b.getConfig().getPropInt("transaction_isolation"), iAtom);
    }

    public Page<Record> paginate(int n2, int n3, String string, Object ... objectArray) {
        return this.paginate(n2, n3, -1L, string, objectArray);
    }

    public Page<Record> paginate(int n2, int n3, long l2, String string, Object ... objectArray) {
        List<Record> list;
        if (n2 < 1 || n3 < 1) {
            throw new IllegalArgumentException("pageNumber and pageSize must be more than 0");
        }
        if (l2 < 0L) {
            String string2 = SqlHelper.getTotalRowSql(string);
            list = this.find(string2, objectArray);
            if (SqlHelper.isGroupBySql(string)) {
                l2 = list.size();
            } else {
                long l3 = l2 = list.size() > 0 ? ((Number)list.get(0).getData()).longValue() : 0L;
            }
        }
        if (l2 == 0L) {
            return new Page<Record>(new ArrayList(0), n2, n3, 0, 0L);
        }
        int n4 = (int)(l2 / (long)n3) + (l2 % (long)n3 > 0L ? 1 : 0);
        if (n2 > n4) {
            return new Page<Record>(new ArrayList(0), n2, n3, n4, l2);
        }
        string = this.b.getDialect().forPaginate(n2, n3, string);
        list = this.find(string, objectArray);
        return new Page<Record>(list, n2, n3, n4, l2);
    }

    public int[] batch(String string, List<Object[]> list, int n2) {
        return this.a(string, list, n2, null);
    }

    private int[] a(String string, List<Object[]> list, int n2, List<Object> list2) {
        Connection connection = null;
        Boolean bl = null;
        try {
            Object object;
            connection = this.b.getConnection();
            bl = connection.getAutoCommit();
            connection.setAutoCommit(false);
            if (list == null || list.size() == 0) {
                int[] nArray = new int[]{};
                return nArray;
            }
            if (n2 < 1) {
                throw new IllegalArgumentException("The batchSize must more than 0.");
            }
            this.a(string, (Object)list, (Exception)null);
            boolean bl2 = this.b.isInTransaction();
            int n3 = 0;
            int[] nArray = new int[list.size()];
            PreparedStatement preparedStatement = list2 != null ? (this.b.isOracle() ? connection.prepareStatement(string, new String[]{"id"}) : connection.prepareStatement(string, 1)) : connection.prepareStatement(string);
            int n4 = 0;
            for (Object[] objectArray : list) {
                this.b.getDialect().fillStatement(preparedStatement, objectArray);
                preparedStatement.addBatch();
                if (++n4 % n2 != 0 && n4 != list.size()) continue;
                int[] nArray2 = preparedStatement.executeBatch();
                if (!bl2) {
                    connection.commit();
                }
                for (int i2 = 0; i2 < nArray2.length; ++i2) {
                    nArray[n3++] = nArray2[i2];
                }
            }
            if (list2 != null) {
                object = preparedStatement.getGeneratedKeys();
                while (object.next()) {
                    list2.add(object.getObject(1));
                }
            }
            this.a(preparedStatement);
            this.a(nArray);
            object = nArray;
            return object;
        }
        catch (Exception exception) {
            throw new BogdaDbException(exception);
        }
        finally {
            if (bl != null) {
                try {
                    connection.setAutoCommit(bl);
                }
                catch (Exception exception) {
                    BogdaLog.sys().error(exception.getMessage(), exception);
                }
            }
            this.b.close(connection);
        }
    }

    public int[] batchUpdate(String string, String string2, List<Record> list, int n2) {
        Object object;
        if (list == null || list.size() == 0) {
            return new int[0];
        }
        String[] stringArray = this.a(string2);
        boolean bl = true;
        for (Record object2 : list) {
            if (object2.isHasStatementCol() || object2.isHasDisabledCol()) {
                bl = false;
                break;
            }
            for (String string3 : stringArray) {
                if (object2.getData(string3) != null) continue;
                bl = false;
                break;
            }
            if (bl) continue;
            break;
        }
        if (!bl) {
            object = new ArrayList();
            String n4 = this.a(string, stringArray, list.get(0), null, (List<String>)object, null);
            ArrayList arrayList = new ArrayList();
            for (Record record : list) {
                Object[] objectArray = new Object[record.colCount()];
                int n3 = 0;
                String[] stringArray2 = object.iterator();
                while (stringArray2.hasNext()) {
                    String string4 = (String)stringArray2.next();
                    objectArray[n3++] = record.getData(string4);
                }
                for (String string5 : stringArray) {
                    objectArray[n3++] = record.getData(string5);
                }
                arrayList.add(objectArray);
            }
            return this.batch(n4, arrayList, n2);
        }
        object = new int[list.size()];
        boolean bl2 = false;
        for (Record record : list) {
            object[++var8_11] = this.a(string, stringArray, record, null);
        }
        return object;
    }

    public int[] batchSave(String string, List<Record> list, int n2) {
        Object object;
        if (list == null || list.size() == 0) {
            return new int[0];
        }
        boolean bl = true;
        for (Record object2 : list) {
            if (!object2.isHasStatementCol() && !object2.isHasDisabledCol()) continue;
            bl = false;
            break;
        }
        if (bl) {
            object = new ArrayList();
            String n4 = this.a(string, list.get(0), null, (List<String>)object, null);
            ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
            for (Record record : list) {
                Object[] objectArray = new Object[object.size()];
                int n3 = 0;
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    objectArray[n3++] = record.getData(string2);
                }
                arrayList.add(objectArray);
            }
            ArrayList arrayList2 = new ArrayList(list.size());
            int[] nArray = this.a(n4, arrayList, n2, (List<Object>)arrayList2);
            if (arrayList2.size() == list.size()) {
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    list.get(i2).setGeneratedKey(arrayList2.get(i2));
                }
            }
            return nArray;
        }
        object = new int[list.size()];
        boolean bl2 = false;
        for (Record record : list) {
            object[++var6_9] = this.save(string, record);
        }
        return object;
    }

    public int[] batchDelete(String string, List<Map<String, Object>> list, int n2) {
        Object object;
        if (list == null || list.size() == 0) {
            return new int[0];
        }
        boolean bl = true;
        block0: for (Map<String, Object> map : list) {
            for (Object iterator : map.values()) {
                if (iterator != null && iterator != "$disabled" && !(iterator instanceof ab)) continue;
                bl = false;
                continue block0;
            }
        }
        if (bl) {
            Map<String, Object> map;
            object = new StringBuilder();
            ((StringBuilder)object).append("delete from ");
            this.b.getDialect().appendTableName((StringBuilder)object, string);
            map = list.get(0);
            this.a((StringBuilder)object, map.keySet().toArray(new String[map.size()]), null, null);
            ArrayList arrayList = new ArrayList(list.size());
            for (Map<String, Object> map2 : list) {
                arrayList.add(map2.values().toArray());
            }
            return this.batch(((StringBuilder)object).toString(), arrayList, n2);
        }
        object = new int[list.size()];
        int n3 = 0;
        for (Map map : list) {
            object[n3++] = this.deleteByFields(string, map);
        }
        return object;
    }

    public Record newRecord() {
        return new Record(this.b.getConfig().isCaseInsensitive());
    }

    public RecordMetaData newRecordMetaData() {
        return new RecordMetaData(this.b.getConfig().isCaseInsensitive());
    }

    public String[] getSqlFields(String string, Object ... objectArray) {
        Connection connection = null;
        try {
            string = this.b.getDialect().forSqlColumns(string);
            connection = this.b.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            if (objectArray.length > 0) {
                this.b.getDialect().fillStatement(preparedStatement, objectArray);
            }
            ResultSet resultSet = preparedStatement.executeQuery();
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n2 = resultSetMetaData.getColumnCount();
            String[] stringArray = new String[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                stringArray[i2] = this.b(resultSetMetaData.getColumnLabel(i2 + 1));
            }
            this.a(resultSet, preparedStatement);
            String[] stringArray2 = stringArray;
            this.b.close(connection);
            return stringArray2;
        }
        catch (Exception exception) {
            try {
                this.a(string, (Object)objectArray, exception);
                throw new BogdaDbException(exception);
            }
            catch (Throwable throwable) {
                this.b.close(connection);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String[]> getTableFields(String string, String string2) {
        try {
            BogdaLog.sql().setTempOff(true);
            List<? extends Record> list = this.a(this.b.getDialect().forTableColumns(string, string2), false, a);
            ArrayList<String[]> arrayList = new ArrayList<String[]>();
            for (Record record : list) {
                arrayList.add(new String[]{this.b(record.getStr("column_name")), record.getStr("data_type"), record.getStr("is_nullable"), record.getStr("column_comment")});
            }
            ArrayList<String[]> arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            BogdaLog.sql().setTempOff(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String[]> listTables(String string) {
        try {
            BogdaLog.sql().setTempOff(true);
            List<? extends Record> list = this.a(this.b.getDialect().forTables(string), false, a);
            ArrayList<String[]> arrayList = new ArrayList<String[]>();
            for (Record record : list) {
                arrayList.add(new String[]{this.b(record.getStr("table_name")), record.getStr("table_comment")});
            }
            ArrayList<String[]> arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            BogdaLog.sql().setTempOff(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> listSchemas() {
        try {
            BogdaLog.sql().setTempOff(true);
            List<? extends Record> list = this.a(this.b.getDialect().forSchemas(), false, a);
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Record record : list) {
                arrayList.add(this.b((String)record.getData()));
            }
            ArrayList<String> arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            BogdaLog.sql().setTempOff(false);
        }
    }

    public String defaultSchema() {
        try {
            BogdaLog.sql().setTempOff(true);
            List<? extends Record> list = this.a(this.b.getDialect().forDefaultSchema(), false, a);
            String string = this.b((String)list.get(0).getData());
            return string;
        }
        finally {
            BogdaLog.sql().setTempOff(false);
        }
    }

    private String b(String string) {
        if (string != null && this.b.getConfig().isCaseInsensitive()) {
            return string.toLowerCase();
        }
        return string;
    }

    private void a(ResultSet resultSet, Statement statement) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                throw new BogdaDbException(sQLException);
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                throw new BogdaDbException(sQLException);
            }
        }
    }

    private void a(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                throw new BogdaDbException(sQLException);
            }
        }
    }

    private void a(String string, Object object, Exception exception) {
        if (exception != null) {
            BogdaLog.sql().warn(this.a(string, object, true), exception);
        } else if (this.c) {
            BogdaLog.sql().info(this.a(string, object, false));
        }
    }

    private String a(String string, Object object, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[SQL").append(bl ? "_ERROR" : "").append(":").append(this.b.getConfig().getName()).append("] ").append(string);
        if (object instanceof Object[]) {
            if (((Object[])object).length > 0) {
                stringBuilder.append("\nparameters: ").append(JsonKit.valToJson(object));
            }
        } else if (object instanceof List) {
            int n2 = 0;
            for (Object e2 : (List)object) {
                stringBuilder.append("\nparameters_").append(n2++).append(": ").append(JsonKit.valToJson(e2));
            }
        }
        return stringBuilder.toString();
    }

    private void a(Object object) {
        if (this.c) {
            BogdaLog.sql().info("[SQL_FINISHED:" + this.b.getConfig().getName() + "] " + JsonKit.valToJson(object) + " records updated");
        }
    }

    protected void setLog(boolean bl) {
        this.c = bl;
    }
}

