/*
 * Decompiled with CFR 0.152.
 */
package bogda.core.db;

import bogda.core.db.Db;
import bogda.core.db.DbImpl;
import io.shardingsphere.api.HintManager;
import io.shardingsphere.core.hint.HintManagerHolder;
import io.shardingsphere.transaction.api.TransactionType;
import io.shardingsphere.transaction.api.TransactionTypeHolder;

public class ShardingDb {
    public static DbImpl use() {
        return Db.use();
    }

    public static DbImpl getMasterDb() {
        HintManager hintManager = HintManager.getInstance();
        hintManager.setMasterRouteOnly();
        return Db.use();
    }

    public static void useMasterDb() {
        HintManager hintManager = HintManager.getInstance();
        hintManager.setMasterRouteOnly();
    }

    public static DbImpl getShardingDb(Comparable<?> comparable) {
        HintManager hintManager = HintManager.getInstance();
        hintManager.setDatabaseShardingValue(comparable);
        return Db.use();
    }

    public static void useShardingDb(Comparable<?> comparable) {
        HintManager hintManager = HintManager.getInstance();
        hintManager.setDatabaseShardingValue(comparable);
    }

    public static DbImpl getTableDb(String string, Comparable<?> comparable, String string2, Comparable<?> comparable2) {
        HintManager hintManager = HintManager.getInstance();
        hintManager.addDatabaseShardingValue(string, comparable);
        hintManager.addTableShardingValue(string2, comparable2);
        return Db.use();
    }

    public static void useTable(String string, Comparable<?> comparable, String string2, Comparable<?> comparable2) {
        HintManager hintManager = HintManager.getInstance();
        hintManager.addDatabaseShardingValue(string, comparable);
        hintManager.addTableShardingValue(string2, comparable2);
    }

    public static DbImpl getXADb() {
        TransactionTypeHolder.set((TransactionType)TransactionType.XA);
        return Db.use();
    }

    public static void useXA() {
        TransactionTypeHolder.set((TransactionType)TransactionType.XA);
    }

    public static DbImpl getLocalTXDb() {
        TransactionTypeHolder.set((TransactionType)TransactionType.LOCAL);
        return Db.use();
    }

    public static void useLocalTX() {
        TransactionTypeHolder.set((TransactionType)TransactionType.LOCAL);
    }

    public static void clearHint() {
        HintManagerHolder.clear();
    }
}

