/*
 * Decompiled with CFR 0.152.
 */
package bogda.core.db.dialect;

import bogda.common.StrKit;
import bogda.core.db.Dialect;

public class H2Dialect
extends Dialect {
    @Override
    public String forTableColumns(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("select column_name, type_name data_type, remarks column_comment, is_nullable from information_schema.columns where ");
        if (StrKit.notBlank(string2)) {
            stringBuilder.append("table_schema='").append(string2.toUpperCase()).append("' and ");
        }
        stringBuilder.append("table_name='").append(string.toUpperCase()).append("'");
        return stringBuilder.toString();
    }

    @Override
    public String forSqlColumns(String string) {
        return "select * from (" + string + ") where 1=2";
    }

    @Override
    public String forPaginate(int n2, int n3, String string) {
        int n4 = n3 * (n2 - 1);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append(" limit ").append(n4).append(", ").append(n3);
        return stringBuilder.toString();
    }

    @Override
    public String forTotalCount(String string) {
        return "select count(1) from (" + string + ")";
    }

    @Override
    public String forTables(String string) {
        return "select table_name, remarks table_comment from information_schema.tables where table_schema='" + string.toUpperCase() + "' and table_type='TABLE'";
    }

    @Override
    public String forSchemas() {
        return "select schema_name from information_schema.schemata where schema_name<>'INFORMATION_SCHEMA'";
    }

    @Override
    public String forDefaultSchema() {
        return "select schema_name from information_schema.schemata where is_default=true";
    }
}

