/*
 * Decompiled with CFR 0.152.
 */
package bogda.core.db.dialect;

import bogda.common.StrKit;
import bogda.core.db.Dialect;

public class MysqlDialect
extends Dialect {
    @Override
    public String forTableColumns(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("select column_name, column_type data_type, column_comment, is_nullable from information_schema.columns where ");
        if (StrKit.notBlank(string2)) {
            stringBuilder.append("table_schema='").append(string2).append("' and ");
        }
        stringBuilder.append("table_name='").append(string).append("'");
        return stringBuilder.toString();
    }

    @Override
    public String forSqlColumns(String string) {
        return "select _sql.* from (" + string + ") _sql where 1=2";
    }

    @Override
    public String forPaginate(int n2, int n3, String string) {
        int n4 = n3 * (n2 - 1);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append(" limit ").append(n4).append(", ").append(n3);
        return stringBuilder.toString();
    }

    @Override
    public String forTotalCount(String string) {
        return "select count(1) from (" + string + ") _sql";
    }

    @Override
    public void appendObjectName(StringBuilder stringBuilder, String string) {
        stringBuilder.append('`').append(string).append('`');
    }

    @Override
    public void appendTableName(StringBuilder stringBuilder, String string) {
        int n2 = string.indexOf(46);
        if (n2 > 0) {
            stringBuilder.append('`').append(string.substring(0, n2)).append("`.`").append(string.substring(n2 + 1)).append('`');
        } else {
            stringBuilder.append('`').append(string).append('`');
        }
    }

    @Override
    public String forTables(String string) {
        return "select table_name, table_comment from information_schema.tables where table_schema='" + string + "' and table_type='BASE TABLE'";
    }

    @Override
    public String forSchemas() {
        return "select schema_name from information_schema.schemata";
    }

    @Override
    public String forDefaultSchema() {
        return "select database() db_name";
    }
}

