/*
 * Decompiled with CFR 0.152.
 */
package bogda.core.log;

import bogda.core.log.ILogFactory;
import bogda.core.log.JdkLog;
import bogda.core.log.JdkLog$LogFormatter;
import bogda.core.log.Log;
import bogda.core.log.LogConfig;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JdkLogFactory
implements ILogFactory {
    public JdkLogFactory(LogConfig logConfig) {
        Object object;
        Level level = JdkLog.a(logConfig.getLevel());
        String string = logConfig.getFile();
        Boolean bl = logConfig.getConsole();
        if (bl == null) {
            bl = true;
        }
        Logger logger = Logger.getLogger("");
        logger.setLevel(level);
        logger.setUseParentHandlers(false);
        for (Handler handler : logger.getHandlers()) {
            logger.removeHandler(handler);
        }
        if (bl.booleanValue()) {
            object = new ConsoleHandler();
            ((Handler)object).setLevel(Level.ALL);
            ((Handler)object).setFormatter(new JdkLog$LogFormatter());
            logger.addHandler((Handler)object);
        }
        try {
            object = new FileHandler(string, true);
            ((Handler)object).setLevel(Level.ALL);
            ((Handler)object).setFormatter(new JdkLog$LogFormatter());
            logger.addHandler((Handler)object);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Log getLog(Class<?> clazz) {
        return new JdkLog(clazz);
    }

    @Override
    public Log getLog(String string) {
        if ("bogda_default_log".equals(string)) {
            JdkLog jdkLog = new JdkLog("");
            jdkLog.a(1);
            return jdkLog;
        }
        if ("bogda_sys_log".equals(string)) {
            JdkLog jdkLog = new JdkLog(string);
            jdkLog.a(-1);
            return jdkLog;
        }
        if ("bogda_sql_log".equals(string)) {
            JdkLog jdkLog = new JdkLog(string);
            jdkLog.a(-1);
            jdkLog.setLevel("info");
            return jdkLog;
        }
        return new JdkLog(string);
    }

    @Override
    public void setLevel(String string) {
        Logger logger = Logger.getLogger("");
        logger.setLevel(JdkLog.a(string));
    }
}

