/*
 * Decompiled with CFR 0.152.
 */
package bogda.core.webapp.auth;

import bogda.common.ClassKit;
import bogda.common.StrKit;
import bogda.core.log.BogdaLog;
import bogda.core.webapp.BogdaSettings;
import bogda.core.webapp.auth.AuthConfig;
import bogda.core.webapp.auth.AuthPlugin;
import bogda.core.webapp.auth.Captcha;
import bogda.core.webapp.auth.GateController;
import bogda.core.webapp.auth.IAuthStrategy;
import bogda.core.webapp.auth.ISSOService;
import bogda.core.webapp.auth.IndexController;
import bogda.core.webapp.auth.Module;
import bogda.core.webapp.auth.SessionManager;
import bogda.core.webapp.auth.UserSession;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AuthManager {
    private static final String a = "null_passowrd";
    protected static final String ERR_VALIDATE_CODE = "error_validate_code";
    protected static final String ERR_USER_PASSWORD = "error_user_password";
    private static AuthConfig b;
    private static AuthPlugin c;
    private static IAuthStrategy d;
    private static ISSOService e;

    public static void init(AuthConfig authConfig, AuthPlugin authPlugin) {
        b = authConfig;
        c = authPlugin;
        String string = authConfig.strategy;
        if (StrKit.isBlank(string)) {
            string = "bogda.platform.BogdaAuthStrategy";
        }
        try {
            d = (IAuthStrategy)ClassKit.get().loadClass(string).newInstance();
        }
        catch (Exception exception) {
            BogdaLog.sys().error("Auth strategy load error : " + exception.getMessage(), exception);
        }
        if (StrKit.notBlank(authConfig.ssoService)) {
            try {
                e = (ISSOService)ClassKit.get().loadClass(authConfig.strategy).newInstance();
            }
            catch (Exception exception) {
                BogdaLog.sys().error("SSO Service load error : " + exception.getMessage(), exception);
            }
        }
    }

    public static UserSession loadUserSession(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        UserSession userSession = SessionManager.get(httpServletRequest, httpServletResponse);
        if (userSession == null) {
            Object object;
            Map<String, Object> map;
            if (e != null && (map = e.getUser((ServletRequest)httpServletRequest)) != null && (object = map.get("user_name")) instanceof String) {
                userSession = AuthManager.login((String)object, a, httpServletRequest, httpServletResponse, map);
            }
            if (BogdaSettings.developMode && userSession == null) {
                userSession = AuthManager.a(httpServletRequest, httpServletResponse, null);
            }
        } else if (BogdaSettings.developMode) {
            userSession = AuthManager.a(httpServletRequest, httpServletResponse, userSession);
        }
        return userSession;
    }

    private static UserSession a(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, UserSession userSession) {
        String string = httpServletRequest.getParameter("debug_user");
        if (string != null) {
            if (userSession != null) {
                if (!string.equals(userSession.getUserName())) {
                    SessionManager.remove(httpServletRequest, httpServletResponse, userSession.getSessionId());
                } else {
                    return userSession;
                }
            }
            if ((userSession = AuthManager.login(string, a, httpServletRequest, httpServletResponse, null)) != null) {
                userSession.setDebug(true);
            }
        }
        return userSession;
    }

    public static boolean isFreeResource(String string) {
        if (GateController.gateActions.contains(string)) {
            return true;
        }
        for (Module module : c.getModuleList()) {
            if (!module.isFreeResource(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasRight(String string, UserSession userSession, HttpServletRequest httpServletRequest) {
        if (IndexController.indexActions.contains(string)) {
            return true;
        }
        return d.hasRight(string, userSession, httpServletRequest);
    }

    public static UserSession login(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (AuthManager.b.validateCode && !Captcha.validate(httpServletRequest, httpServletResponse, httpServletRequest.getParameter("validatecode"), true)) {
            throw new RuntimeException(ERR_VALIDATE_CODE);
        }
        return AuthManager.login(httpServletRequest.getParameter("user"), httpServletRequest.getParameter("passowrd"), httpServletRequest, httpServletResponse, null);
    }

    public static UserSession login(String string, String string2, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Map<String, Object> map) {
        if (!AuthManager.a(string, string2)) {
            throw new RuntimeException(ERR_USER_PASSWORD);
        }
        UserSession userSession = new UserSession();
        userSession.setUserName(string);
        if (map != null) {
            userSession.setSso(true);
        }
        d.loadUserInfo(userSession);
        if (map != null) {
            e.buildUserSession(userSession, map);
        }
        userSession = SessionManager.save(httpServletRequest, httpServletResponse, userSession);
        for (Module module : c.getModuleList()) {
            module.onLogin(userSession, httpServletRequest, httpServletResponse);
        }
        return userSession;
    }

    private static boolean a(String string, String string2) {
        if (a == string2) {
            return true;
        }
        return d.checkUserPassword(string, string2);
    }

    protected static void onLogout(UserSession userSession, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        for (Module module : c.getModuleList()) {
            module.onLogout(userSession, httpServletRequest, httpServletResponse);
        }
    }
}

