/*
 * Decompiled with CFR 0.152.
 */
package bogda.core.webapp.auth;

import bogda.core.webapp.auth.AuthManager;
import bogda.core.webapp.auth.SessionManager;
import bogda.core.webapp.auth.UserSession;
import bogda.core.webapp.controller.Controller;
import bogda.core.webapp.controller.Response;
import bogda.core.webapp.controller.ResponseHandler;
import bogda.core.webapp.controller.ViewType;
import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Controller(viewPath="/bogda")
public class IndexController {
    public static final String URL_ROOT = "/";
    public static final String URL_INDEX = "/index";
    public static final String URL_LOGOUT = "/logout";
    public static HashSet<String> indexActions = new HashSet();

    @Controller(action="/", response=Response.VIEW, viewType=ViewType.FREE_MARKER)
    public String root(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return "index.html";
    }

    @Controller(action="/index", response=Response.VIEW, viewType=ViewType.FREE_MARKER)
    public String index(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return "index.html";
    }

    @Controller(action="/logout")
    public void logout(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        boolean bl = false;
        UserSession userSession = SessionManager.get(httpServletRequest, httpServletResponse);
        if (userSession != null) {
            bl = userSession.isSso();
            AuthManager.onLogout(userSession, httpServletRequest, httpServletResponse);
            SessionManager.remove(httpServletRequest, httpServletResponse, userSession.getSessionId());
        }
        new ResponseHandler(httpServletRequest, httpServletResponse).redirect(bl ? "/quit" : URL_ROOT);
    }

    static {
        indexActions.add(URL_ROOT);
        indexActions.add(URL_INDEX);
        indexActions.add(URL_LOGOUT);
    }
}

