/*
 * Decompiled with CFR 0.152.
 */
package bogda.core.webapp.auth;

import bogda.common.StrKit;
import bogda.core.cache.CacheManager;
import bogda.core.cache.CacheStrategy;
import bogda.core.cache.redis.RedisCache;
import bogda.core.webapp.auth.AuthConfig;
import bogda.core.webapp.auth.RedisSession;
import bogda.core.webapp.auth.SessionIdBuilder;
import bogda.core.webapp.auth.UserSession;
import bogda.core.webapp.controller.CookieUtil;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class SessionManager {
    private static final String a = "_bogda_user_session";
    private static final String b = "_bogda_session_id";
    private static final String c = "user_session";
    private static CacheStrategy d;
    private static boolean e;
    protected static int timeoutSeconds;

    public static void init(AuthConfig authConfig) {
        timeoutSeconds = authConfig.sessionTimeout * 60;
        if (CacheManager.isClusterMode()) {
            CacheManager.addCoreCache(c, timeoutSeconds);
            d = CacheManager.get(c);
            e = d instanceof RedisCache;
        }
    }

    public static UserSession get(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        UserSession userSession = null;
        if (d == null) {
            userSession = (UserSession)httpServletRequest.getSession().getAttribute(a);
        } else {
            String string = CookieUtil.getCookie(httpServletRequest, b);
            if (StrKit.notBlank(string) && (userSession = e ? RedisSession.get(string, (RedisCache)d) : (UserSession)d.get(string)) == null) {
                CookieUtil.removeCookie(httpServletResponse, b);
            }
        }
        return userSession;
    }

    public static UserSession save(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, UserSession userSession) {
        if (d == null) {
            HttpSession httpSession = SessionManager.a(httpServletRequest);
            httpSession.setMaxInactiveInterval(timeoutSeconds);
            httpSession.setAttribute(a, (Object)userSession);
        } else {
            String string = SessionIdBuilder.getSessionId(httpServletRequest);
            if (e) {
                RedisSession redisSession = new RedisSession(string, (RedisCache)d);
                redisSession.setAttributes(userSession.getAttributes());
                userSession = redisSession;
            } else {
                userSession.setSessionId(string);
                d.put(string, userSession);
            }
            CookieUtil.setCookie(httpServletResponse, b, string, -1);
        }
        return userSession;
    }

    private static HttpSession a(HttpServletRequest httpServletRequest) {
        HttpSession httpSession = httpServletRequest.getSession();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Enumeration enumeration = httpSession.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            hashMap.put(string, httpSession.getAttribute(string));
        }
        httpSession.invalidate();
        httpSession = httpServletRequest.getSession();
        for (Map.Entry entry : hashMap.entrySet()) {
            httpSession.setAttribute((String)entry.getKey(), entry.getValue());
        }
        return httpSession;
    }

    public static void remove(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) {
        if (d == null) {
            httpServletRequest.getSession().removeAttribute(a);
        } else {
            d.remove(string);
            CookieUtil.removeCookie(httpServletResponse, b);
        }
    }

    static {
        e = false;
    }
}

