/*
 * Decompiled with CFR 0.152.
 */
package bogda.core.webapp.controller;

import bogda.common.JsonKit;
import bogda.core.log.BogdaLog;
import bogda.core.webapp.BogdaSettings;
import bogda.core.webapp.controller.ControllerManager;
import bogda.core.webapp.controller.FreeMarker;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ResponseHandler {
    public static final String CONTENT_TYPE_TEXT = "text/plain";
    public static final String CONTENT_TYPE_HTML = "text/html";
    public static final String CONTENT_TYPE_JSON = "application/json";
    private HttpServletRequest a;
    private HttpServletResponse b;

    public ResponseHandler(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        this.a = httpServletRequest;
        this.b = httpServletResponse;
        httpServletRequest.setAttribute("contextPath", (Object)httpServletRequest.getServletContext().getContextPath());
    }

    public void setAttribute(String string, Object object) {
        this.a.setAttribute(string, object);
    }

    public void handleText(String string) {
        this.a(string, CONTENT_TYPE_TEXT, BogdaSettings.encoding);
    }

    public void handleHtml(String string) {
        this.a(string, CONTENT_TYPE_HTML, BogdaSettings.encoding);
    }

    private void a(String string, String string2, String string3) {
        PrintWriter printWriter = null;
        try {
            this.b.setHeader("Pragma", "no-cache");
            this.b.setHeader("Cache-Control", "no-cache");
            this.b.setDateHeader("Expires", 0L);
            this.b.setContentType(string2);
            this.b.setCharacterEncoding(string3);
            printWriter = this.b.getWriter();
            printWriter.write(string);
            printWriter.flush();
            printWriter.close();
        }
        catch (IOException iOException) {
            this.a(iOException, null);
        }
    }

    public void handleJson(Object object) {
        String string = object == null ? "" : (object instanceof String ? (String)object : JsonKit.valToJson(object));
        PrintWriter printWriter = null;
        try {
            this.b.setHeader("Pragma", "no-cache");
            this.b.setHeader("Cache-Control", "no-cache");
            this.b.setDateHeader("Expires", 0L);
            this.b.setContentType("application/json; charset=" + BogdaSettings.encoding);
            printWriter = this.b.getWriter();
            printWriter.write(string);
            printWriter.flush();
            printWriter.close();
        }
        catch (IOException iOException) {
            this.a(iOException, null);
        }
    }

    public void handleView(String string) {
        switch (ControllerManager.defaultViewType) {
            case JSP: {
                this.handleJsp(string);
                break;
            }
            case FREE_MARKER: {
                this.handleFreeMarkerView(string);
                break;
            }
        }
    }

    public void handleJsp(String string) {
        try {
            this.a.getRequestDispatcher(string).forward((ServletRequest)this.a, (ServletResponse)this.b);
        }
        catch (IOException iOException) {
            this.a(iOException, null);
        }
        catch (Exception exception) {
            this.a(exception, null, null);
        }
    }

    public void handleFreeMarkerView(String string) {
        this.b.setContentType("text/html; charset=" + BogdaSettings.encoding);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Object object = this.a.getAttributeNames();
        while (object.hasMoreElements()) {
            String string2 = (String)object.nextElement();
            hashMap.put(string2, this.a.getAttribute(string2));
        }
        object = null;
        try {
            object = this.b.getWriter();
            FreeMarker.process(string, hashMap, (PrintWriter)object);
            ((PrintWriter)object).close();
        }
        catch (IOException iOException) {
            this.a(iOException, null);
        }
        catch (Exception exception) {
            this.a(exception, (PrintWriter)object, null);
        }
    }

    public void handleBytes(byte[] byArray) {
        ServletOutputStream servletOutputStream = null;
        try {
            servletOutputStream = this.b.getOutputStream();
            servletOutputStream.write(byArray);
            servletOutputStream.close();
        }
        catch (IOException iOException) {
            this.a(iOException, (OutputStream)servletOutputStream);
        }
    }

    public void redirect(String string) {
        try {
            this.b.sendRedirect(this.a.getContextPath() + string);
        }
        catch (IOException iOException) {
            this.a(iOException, null);
        }
    }

    private void a(IOException iOException, OutputStream outputStream) {
        BogdaLog.sys().error(iOException.getMessage(), iOException);
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
        }
    }

    private void a(Exception exception, PrintWriter printWriter, OutputStream outputStream) {
        BogdaLog.sys().error(exception.getMessage(), exception);
        if (outputStream != null) {
            printWriter = new PrintWriter(outputStream);
        }
        if (printWriter != null) {
            this.b.setContentType("text/plain; charset=" + BogdaSettings.encoding);
            if (BogdaSettings.developMode) {
                exception.printStackTrace(printWriter);
            } else {
                printWriter.write("Response Error");
            }
            printWriter.close();
        }
    }

    public void handleException(Exception exception) {
        PrintWriter printWriter = null;
        try {
            this.b.setContentType("text/plain; charset=" + BogdaSettings.encoding);
            printWriter = this.b.getWriter();
            if (BogdaSettings.developMode) {
                exception.printStackTrace(printWriter);
            } else {
                printWriter.write(exception.getMessage());
            }
            printWriter.flush();
            printWriter.close();
        }
        catch (IOException iOException) {
            this.a(iOException, null);
        }
    }
}

