/*
 * Decompiled with CFR 0.152.
 */
package bogda.common;

public class BytesTrans {
    public static short bytesToShort(byte[] byArray) {
        return (short)((byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF);
    }

    public static int bytesToInt(byte[] byArray) {
        return (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
    }

    public static long bytesToLong(byte[] byArray) {
        return ((long)byArray[0] & 0xFFL) << 56 | ((long)byArray[1] & 0xFFL) << 48 | ((long)byArray[2] & 0xFFL) << 40 | ((long)byArray[3] & 0xFFL) << 32 | ((long)byArray[4] & 0xFFL) << 24 | ((long)byArray[5] & 0xFFL) << 16 | ((long)byArray[6] & 0xFFL) << 8 | (long)byArray[7] & 0xFFL;
    }

    public static float bytesToFloat(byte[] byArray) {
        int n2 = BytesTrans.bytesToInt(byArray);
        return Float.intBitsToFloat(n2);
    }

    public static double bytesToDouble(byte[] byArray) {
        long l2 = BytesTrans.bytesToLong(byArray);
        return Double.longBitsToDouble(l2);
    }

    public static byte[] shortToBytes(short s2) {
        byte[] byArray = new byte[]{(byte)(s2 >> 8 & 0xFF), (byte)(s2 & 0xFF)};
        return byArray;
    }

    public static byte[] intToBytes(int n2) {
        byte[] byArray = new byte[]{(byte)(n2 >> 24 & 0xFF), (byte)(n2 >> 16 & 0xFF), (byte)(n2 >> 8 & 0xFF), (byte)(n2 & 0xFF)};
        return byArray;
    }

    public static byte[] longToBytes(long l2) {
        byte[] byArray = new byte[]{(byte)(l2 >> 56 & 0xFFL), (byte)(l2 >> 48 & 0xFFL), (byte)(l2 >> 40 & 0xFFL), (byte)(l2 >> 32 & 0xFFL), (byte)(l2 >> 24 & 0xFFL), (byte)(l2 >> 16 & 0xFFL), (byte)(l2 >> 8 & 0xFFL), (byte)(l2 & 0xFFL)};
        return byArray;
    }

    public static byte[] floatToBytes(float f2) {
        int n2 = Float.floatToRawIntBits(f2);
        return BytesTrans.intToBytes(n2);
    }

    public static byte[] doubleToBytes(double d2) {
        long l2 = Double.doubleToRawLongBits(d2);
        return BytesTrans.longToBytes(l2);
    }
}

