/*
 * Decompiled with CFR 0.152.
 */
package bogda.common.grid;

import bogda.common.grid.ICell;
import bogda.common.grid.IGrid;

public class ExcelId {
    public static boolean isExcelId(String string) {
        if (string.length() < 2) {
            return false;
        }
        boolean bl = false;
        boolean bl2 = false;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z') {
                if (bl2) {
                    return false;
                }
                bl = true;
                continue;
            }
            if (c2 >= '0' && c2 <= '9') {
                if (!bl) {
                    return false;
                }
                if (c2 == '0' && !bl2) {
                    return false;
                }
                bl2 = true;
                continue;
            }
            return false;
        }
        return bl && bl2;
    }

    public static boolean isValidExcelId(String string, IGrid iGrid, boolean bl) {
        try {
            int[] nArray = ExcelId.toPoint(string);
            if (nArray[0] < iGrid.getRowCount() && nArray[1] < iGrid.getColCount()) {
                if (!bl) {
                    return true;
                }
                return iGrid.getCell(nArray[0], nArray[1]) != null;
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return false;
    }

    public static int[] toPoint(String string) {
        int n2;
        int n3 = -1;
        int n4 = 0;
        for (n2 = 0; n2 < string.length(); ++n2) {
            char c2 = string.charAt(n2);
            if (c2 == '0') {
                throw new RuntimeException("Excel id not valid: " + string);
            }
            if (c2 > '0' && c2 <= '9') {
                n3 = n2;
                break;
            }
            int n5 = c2 >= 'a' ? c2 - 97 : c2 - 65;
            if (n5 < 0 || n5 > 25) {
                throw new RuntimeException("Excel id not valid: " + string);
            }
            n4 = n4 * 26 + (n5 + 1);
        }
        try {
            n2 = Integer.parseInt(string.substring(n3)) - 1;
        }
        catch (Exception exception) {
            throw new RuntimeException("Excel id not valid: " + string);
        }
        return new int[]{n2, n4 - 1};
    }

    public static String toExcelId(int n2, int n3) {
        StringBuilder stringBuilder = new StringBuilder();
        ExcelId.a(n3, stringBuilder);
        stringBuilder.append(n2 + 1);
        return stringBuilder.toString();
    }

    public static String toExcelId(ICell iCell) {
        return ExcelId.toExcelId(iCell.getRowIndex(), iCell.getColIndex());
    }

    public static String toColId(int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        ExcelId.a(n2, stringBuilder);
        return stringBuilder.toString();
    }

    private static void a(int n2, StringBuilder stringBuilder) {
        ++n2;
        while (true) {
            int n3;
            int n4 = (n3 = n2 % 26) == 0 ? n2 / 26 - 1 : n2 / 26;
            stringBuilder.insert(0, n3 == 0 ? (char)'Z' : (char)(65 + n3 - 1));
            if (n4 == 0) break;
            n2 = n4;
        }
    }

    public static void main(String[] stringArray) {
        String string = ExcelId.toExcelId(0, 702);
        System.out.println(string);
        int[] nArray = ExcelId.toPoint(string);
        System.out.println(nArray[0] + "," + nArray[1]);
    }
}

