/*
 * Decompiled with CFR 0.152.
 */
package bogda.core.cache.redis;

import bogda.core.cache.redis.ISerializer;
import bogda.core.log.BogdaLog;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import redis.clients.jedis.util.SafeEncoder;

public class JdkSerializer
implements ISerializer {
    public static final ISerializer me = new JdkSerializer();

    @Override
    public byte[] keyToBytes(String string) {
        return SafeEncoder.encode((String)string);
    }

    @Override
    public String keyFromBytes(byte[] byArray) {
        return SafeEncoder.encode((byte[])byArray);
    }

    @Override
    public byte[] fieldToBytes(Object object) {
        return this.valueToBytes(object);
    }

    @Override
    public Object fieldFromBytes(byte[] byArray) {
        return this.valueFromBytes(byArray);
    }

    @Override
    public byte[] valueToBytes(Object object) {
        ObjectOutputStream objectOutputStream = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        finally {
            if (objectOutputStream != null) {
                try {
                    objectOutputStream.close();
                }
                catch (Exception exception) {
                    BogdaLog.sys().error(exception.getMessage(), exception);
                }
            }
        }
    }

    @Override
    public Object valueFromBytes(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        ObjectInputStream objectInputStream = null;
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            objectInputStream = new ObjectInputStream(byteArrayInputStream);
            Object object = objectInputStream.readObject();
            return object;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        finally {
            if (objectInputStream != null) {
                try {
                    objectInputStream.close();
                }
                catch (Exception exception) {
                    BogdaLog.sys().error(exception.getMessage(), exception);
                }
            }
        }
    }
}

