/*
 * Decompiled with CFR 0.152.
 */
package bogda.core.cache.redis;

import bogda.core.cache.CacheConfig;
import bogda.core.cache.redis.FstSerializer;
import bogda.core.cache.redis.MyJedis;
import bogda.core.cache.redis.MyJedisCluster;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Client;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class RedisManager {
    public static final String REDIS_POOL_MAX_IDLE = "max_idle";
    public static final String REDIS_POOL_MAX_ACTIVE = "max_active";
    public static final String REDIS_POOL_MAX_WAIT = "max_wait";
    public static final String REDIS_POOL_TEST_ON_BORROW = "test_on_borrow";
    public static final int DEFAULT_DB_INDEX = -1;
    public static final FstSerializer fstSerializer = new FstSerializer();
    public static JedisPoolConfig poolConfig;
    public static Map<String, JedisPool> dataPoolMap;
    public static MyJedisCluster myJedisCluster;

    public static void addCache(CacheConfig cacheConfig) {
        String string = cacheConfig.getName();
        if (dataPoolMap.get(string) == null) {
            RedisManager.addJedisPool(cacheConfig);
        }
    }

    public static void addJedisPool(CacheConfig cacheConfig) {
        String string = cacheConfig.getHost();
        int n2 = cacheConfig.getPort();
        int n3 = cacheConfig.getDatabaseIndex();
        for (String string2 : dataPoolMap.keySet()) {
            JedisPool jedisPool = dataPoolMap.get(string2);
            Client client = jedisPool.getResource().getClient();
            if (!string.equals(client.getHost()) || n2 != client.getPort() || n3 != client.getDB()) continue;
            dataPoolMap.put(cacheConfig.getName(), jedisPool);
            return;
        }
        if (poolConfig == null) {
            RedisManager.buildJedisPoolConfig(cacheConfig);
        }
        JedisPool jedisPool = new JedisPool((GenericObjectPoolConfig)poolConfig, cacheConfig.getHost(), cacheConfig.getPort(), cacheConfig.getConnectionTimeout(), cacheConfig.getSoTimeout(), cacheConfig.getPassword(), cacheConfig.getDatabaseIndex(), "");
        dataPoolMap.put(cacheConfig.getName(), jedisPool);
    }

    public static void buildJedisPoolConfig(CacheConfig cacheConfig) {
        if (poolConfig != null) {
            return;
        }
        if (!cacheConfig.hasPoolProp(REDIS_POOL_MAX_IDLE)) {
            cacheConfig.setPoolProp(REDIS_POOL_MAX_IDLE, 10);
        }
        if (!cacheConfig.hasPoolProp(REDIS_POOL_MAX_ACTIVE)) {
            cacheConfig.setPoolProp(REDIS_POOL_MAX_ACTIVE, 1000);
        }
        if (!cacheConfig.hasPoolProp(REDIS_POOL_MAX_WAIT)) {
            cacheConfig.setPoolProp(REDIS_POOL_MAX_WAIT, 30);
        }
        if (!cacheConfig.hasPoolProp(REDIS_POOL_TEST_ON_BORROW)) {
            cacheConfig.setPoolProp(REDIS_POOL_TEST_ON_BORROW, "true");
        }
        poolConfig = new JedisPoolConfig();
        poolConfig.setMaxIdle(cacheConfig.getPoolPropInt(REDIS_POOL_MAX_IDLE));
        poolConfig.setMaxTotal(cacheConfig.getPoolPropInt(REDIS_POOL_MAX_ACTIVE));
        poolConfig.setMaxWaitMillis(Long.valueOf(cacheConfig.getPoolPropInt(REDIS_POOL_MAX_WAIT) * 1000).longValue());
        poolConfig.setTestOnBorrow(cacheConfig.getPoolPropBol(REDIS_POOL_TEST_ON_BORROW).booleanValue());
    }

    public static MyJedis getMyJedis(CacheConfig cacheConfig) {
        RedisManager.addCache(cacheConfig);
        String string = cacheConfig.getName();
        return new MyJedis(string, RedisManager.getJedisPool(string), fstSerializer);
    }

    public static JedisPool getJedisPool(String string) {
        if (dataPoolMap.get(string) != null) {
            return dataPoolMap.get(string);
        }
        return dataPoolMap.get("__DEFAULT__");
    }

    public static MyJedisCluster getMyJedisCluster(CacheConfig cacheConfig) {
        if (myJedisCluster == null) {
            RedisManager.buildJedisCluster(cacheConfig);
        }
        return myJedisCluster;
    }

    public static void buildJedisCluster(CacheConfig cacheConfig) {
        HashSet<HostAndPort> hashSet;
        JedisCluster jedisCluster;
        if (poolConfig == null) {
            RedisManager.buildJedisPoolConfig(cacheConfig);
        }
        if ((jedisCluster = cacheConfig.getCluster()) != null && ((String[])jedisCluster).length > 0) {
            hashSet = new HashSet<HostAndPort>();
            for (String string : jedisCluster) {
                int n2;
                String string2;
                int n3 = (string = string.trim()).indexOf(":");
                if (n3 > 0) {
                    string2 = string.substring(0, n3);
                    n2 = Integer.parseInt(string.substring(n3 + 1));
                } else {
                    string2 = string;
                    n2 = cacheConfig.getPort();
                }
                hashSet.add(new HostAndPort(string2, n2));
            }
        } else {
            throw new RuntimeException("\u521d\u59cb\u5316redis\u51fa\u9519\uff1a\u96c6\u7fa4\u5730\u5740\u6709\u8bef\uff01");
        }
        JedisCluster jedisCluster2 = new JedisCluster(hashSet, cacheConfig.getConnectionTimeout(), cacheConfig.getSoTimeout(), cacheConfig.getMaxAttempts(), cacheConfig.getPassword(), (GenericObjectPoolConfig)poolConfig);
        myJedisCluster = new MyJedisCluster(jedisCluster2, fstSerializer);
    }

    static {
        dataPoolMap = new HashMap<String, JedisPool>();
    }
}

