/*
 * Decompiled with CFR 0.152.
 */
package bogda.core.db;

import bogda.core.db.DbImpl;
import bogda.core.db.QueryRecord;
import bogda.core.db.Record;
import bogda.core.db.RecordMetaData;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.List;

public class RecordBuilder {
    public static final List<? extends Record> buildList(DbImpl dbImpl, ResultSet resultSet, boolean bl) {
        ArrayList<QueryRecord> arrayList = new ArrayList<QueryRecord>();
        RecordMetaData recordMetaData = RecordBuilder.a(dbImpl, resultSet);
        String[] stringArray = bl ? null : recordMetaData.getColNames();
        int[] nArray = recordMetaData.getColTypes();
        while (resultSet.next()) {
            Record record = bl ? new QueryRecord(recordMetaData) : dbImpl.newRecord();
            RecordBuilder.a(record, resultSet, recordMetaData.getColCount(), stringArray, nArray);
            arrayList.add((QueryRecord)record);
        }
        return arrayList;
    }

    public static final <T extends Record> T build(DbImpl dbImpl, ResultSet resultSet, boolean bl) {
        RecordMetaData recordMetaData = RecordBuilder.a(dbImpl, resultSet);
        if (resultSet.next()) {
            Record record = bl ? new QueryRecord(recordMetaData) : dbImpl.newRecord();
            RecordBuilder.a(record, resultSet, recordMetaData.getColCount(), bl ? null : recordMetaData.getColNames(), recordMetaData.getColTypes());
            return (T)record;
        }
        return null;
    }

    private static void a(Record record, ResultSet resultSet, int n2, String[] stringArray, int[] nArray) {
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = nArray[i2] < 2004 ? resultSet.getObject(i2 + 1) : (nArray[i2] == 2005 ? RecordBuilder.a(resultSet.getClob(i2 + 1)) : (nArray[i2] == 2011 ? RecordBuilder.a(resultSet.getNClob(i2 + 1)) : (nArray[i2] == 2004 ? (Object)RecordBuilder.a(resultSet.getBlob(i2 + 1)) : resultSet.getObject(i2 + 1))));
            if (stringArray == null) {
                ((QueryRecord)record).datas()[i2] = object;
                continue;
            }
            record.setData(stringArray[i2], object);
        }
    }

    private static RecordMetaData a(DbImpl dbImpl, ResultSet resultSet) {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n2 = resultSetMetaData.getColumnCount();
        String[] stringArray = new String[n2];
        int[] nArray = new int[n2];
        boolean bl = dbImpl.getDataSource().getConfig().isCaseInsensitive();
        for (int i2 = 0; i2 < n2; ++i2) {
            stringArray[i2] = resultSetMetaData.getColumnLabel(i2 + 1);
            if (bl) {
                stringArray[i2] = stringArray[i2].toLowerCase();
            }
            nArray[i2] = resultSetMetaData.getColumnType(i2 + 1);
        }
        RecordMetaData recordMetaData = dbImpl.newRecordMetaData();
        recordMetaData.setColNames(stringArray);
        recordMetaData.setColTypes(nArray);
        return recordMetaData;
    }

    private static byte[] a(Blob blob) {
        if (blob == null) {
            return null;
        }
        InputStream inputStream = null;
        try {
            inputStream = blob.getBinaryStream();
            if (inputStream == null) {
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = new byte[(int)blob.length()];
            if (byArray.length == 0) {
                byte[] byArray2 = null;
                return byArray2;
            }
            inputStream.read(byArray);
            byte[] byArray3 = byArray;
            return byArray3;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
        }
    }

    private static String a(Clob clob) {
        if (clob == null) {
            return null;
        }
        Reader reader = null;
        try {
            reader = clob.getCharacterStream();
            if (reader == null) {
                String string = null;
                return string;
            }
            char[] cArray = new char[(int)clob.length()];
            if (cArray.length == 0) {
                String string = null;
                return string;
            }
            reader.read(cArray);
            String string = new String(cArray);
            return string;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
        }
    }
}

