/*
 * Decompiled with CFR 0.152.
 */
package bogda.core.db.dialect;

import bogda.core.db.Dialect;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Timestamp;

public class OracleDialect
extends Dialect {
    @Override
    public String forTableColumns(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("select t.column_name, t.data_type, t.nullable as is_nullable, c.comments as column_comment from user_tab_cols t,user_col_comments c  where t.TABLE_NAME = c.table_name and t.column_name=c.column_name ");
        stringBuilder.append("and t.table_name='").append(string.toUpperCase()).append("'");
        return stringBuilder.toString();
    }

    @Override
    public String forSqlColumns(String string) {
        return "select * from (" + string + ") where rownum<1";
    }

    @Override
    public String forPaginate(int n2, int n3, String string) {
        int n4 = (n2 - 1) * n3 + 1;
        int n5 = n2 * n3;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("select * from ( select row_.*, rownum rownum_ from (  ");
        stringBuilder.append(string);
        stringBuilder.append(" ) row_ where rownum <= ").append(n5).append(") table_alias");
        stringBuilder.append(" where table_alias.rownum_ >= ").append(n4);
        return stringBuilder.toString();
    }

    @Override
    public String forTotalCount(String string) {
        return "select count(1) from (" + string + ")";
    }

    @Override
    public void fillStatement(PreparedStatement preparedStatement, Object ... objectArray) {
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            this.a(preparedStatement, i2 + 1, objectArray[i2]);
        }
    }

    private void a(PreparedStatement preparedStatement, int n2, Object object) {
        if (object instanceof Date) {
            preparedStatement.setDate(n2, (Date)object);
        } else if (object instanceof Timestamp) {
            preparedStatement.setTimestamp(n2, (Timestamp)object);
        } else {
            preparedStatement.setObject(n2, object);
        }
    }

    @Override
    public String forTables(String string) {
        return "select t.table_name as table_name, c.comments as table_comment  from user_tables t, user_tab_comments c where t.TABLE_NAME = c.table_name";
    }

    @Override
    public String forSchemas() {
        return "select user as schema_name from dual";
    }

    @Override
    public String forDefaultSchema() {
        return "select user as schema_name from dual";
    }
}

