/*
 * Decompiled with CFR 0.152.
 */
package bogda.core.log;

import bogda.core.log.ILogFactory;
import bogda.core.log.JdkLogFactory;
import bogda.core.log.Log;
import bogda.core.log.Log4jLogFactory;
import bogda.core.log.LogConfig;

public class BogdaLog {
    public static final String LEVEL_DEBUG = "debug";
    public static final String LEVEL_INFO = "info";
    public static final String LEVEL_WARN = "warn";
    public static final String LEVEL_ERROR = "error";
    public static final String LEVEL_FATAL = "fatal";
    public static final String LEVEL_OFF = "off";
    static final String a = "bogda_default_log";
    static final String b = "bogda_sys_log";
    static final String c = "bogda_sql_log";
    static String d = "UTF-8";
    private static ILogFactory e;
    private static Log f;
    private static Log g;
    private static Log h;

    public static void init() {
        BogdaLog.init(new LogConfig());
    }

    public static void init(LogConfig logConfig) {
        if (e == null) {
            if (logConfig == null) {
                logConfig = new LogConfig();
            }
            try {
                Class.forName("org.apache.log4j.Logger");
                e = new Log4jLogFactory(logConfig);
            }
            catch (Exception exception) {
                e = new JdkLogFactory(logConfig);
            }
            f = e.getLog(a);
            g = e.getLog(b);
            h = e.getLog(c);
        }
    }

    public static Log getLog(Class<?> clazz) {
        return e.getLog(clazz);
    }

    public static Log getLog(String string) {
        return e.getLog(string);
    }

    public static Log sys() {
        return g;
    }

    public static Log sql() {
        return h;
    }

    public static void debug(String string) {
        f.debug(string);
    }

    public static void debug(String string, Throwable throwable) {
        f.debug(string, throwable);
    }

    public static void info(String string) {
        f.info(string);
    }

    public static void info(String string, Throwable throwable) {
        f.info(string, throwable);
    }

    public static void warn(String string) {
        f.warn(string);
    }

    public static void warn(String string, Throwable throwable) {
        f.warn(string, throwable);
    }

    public static void error(String string) {
        f.error(string);
    }

    public static void error(String string, Throwable throwable) {
        f.error(string, throwable);
    }

    public static void fatal(String string) {
        f.fatal(string);
    }

    public static void fatal(String string, Throwable throwable) {
        f.fatal(string, throwable);
    }

    public static void setLevel(String string) {
        g.setLevel(string);
        f.setLevel(string);
        e.setLevel(string);
    }
}

