/*
 * Decompiled with CFR 0.152.
 */
package bogda.core.webapp.auth;

import bogda.core.webapp.Bogda;
import bogda.core.webapp.auth.AuthConfig;
import bogda.core.webapp.auth.AuthManager;
import bogda.core.webapp.auth.GateController;
import bogda.core.webapp.auth.IndexController;
import bogda.core.webapp.auth.Module;
import bogda.core.webapp.auth.SessionManager;
import bogda.core.webapp.auth.UserSession;
import bogda.core.webapp.plugin.IFilter;
import bogda.core.webapp.plugin.Plugin;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AuthPlugin
extends Plugin
implements IFilter {
    public static final String id = "bogda_auth";
    private AuthConfig a;
    private List<Module> b = new ArrayList<Module>();

    public AuthPlugin(AuthConfig authConfig) {
        this.a = authConfig;
    }

    @Override
    public void start() {
        SessionManager.init(this.a);
        AuthManager.init(this.a, this);
        this.a();
        this.addController(GateController.class);
        this.addController(IndexController.class);
    }

    private void a() {
        for (Plugin plugin : Bogda.getPlugins()) {
            if (!(plugin instanceof Module)) continue;
            this.b.add((Module)plugin);
        }
    }

    public List<Module> getModuleList() {
        return this.b;
    }

    @Override
    public void stop() {
    }

    @Override
    public boolean doFilter(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) {
        UserSession userSession = null;
        boolean bl = false;
        if (AuthManager.isFreeResource(string)) {
            bl = true;
        } else if (!this.a.accessControl) {
            AuthManager.loadUserSession(httpServletRequest, httpServletResponse);
            bl = true;
        } else {
            userSession = AuthManager.loadUserSession(httpServletRequest, httpServletResponse);
            if (userSession == null) {
                httpServletResponse.sendRedirect(httpServletRequest.getContextPath() + "/login");
                return false;
            }
        }
        if (bl || AuthManager.hasRight(string, userSession, httpServletRequest)) {
            return true;
        }
        httpServletResponse.getWriter().write("Access Error");
        return false;
    }
}

