/*
 * Decompiled with CFR 0.152.
 */
package bogda.core.webapp.auth;

import bogda.core.webapp.Bogda;
import bogda.core.webapp.auth.AuthManager;
import bogda.core.webapp.auth.Captcha;
import bogda.core.webapp.auth.SessionManager;
import bogda.core.webapp.controller.Controller;
import bogda.core.webapp.controller.RequestMethod;
import bogda.core.webapp.controller.Response;
import bogda.core.webapp.controller.ResponseHandler;
import bogda.core.webapp.controller.ReturnData;
import bogda.core.webapp.controller.ViewType;
import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Controller(viewPath="/bogda")
public class GateController {
    public static final String URL_LOGIN = "/login";
    public static final String URL_VALIDATECODE = "/validatecode";
    public static final String URL_DOLOGIN = "/dologin";
    public static final String URL_QUIT = "/quit";
    public static HashSet<String> gateActions = new HashSet();

    @Controller(action="/login", response=Response.VIEW, viewType=ViewType.FREE_MARKER)
    public Object login(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (SessionManager.get(httpServletRequest, httpServletResponse) == null) {
            return "login.html";
        }
        new ResponseHandler(httpServletRequest, httpServletResponse).redirect("/");
        return null;
    }

    @Controller(action="/validatecode", response=Response.JSON)
    public Object validateCode(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String string = httpServletRequest.getParameter("code");
        if (string == null) {
            if (Bogda.getConfig().auth.validateCode) {
                Captcha.render(httpServletResponse);
            }
            return null;
        }
        if (!Bogda.getConfig().auth.validateCode || Captcha.validate(httpServletRequest, httpServletResponse, string, false)) {
            return new ReturnData();
        }
        return new ReturnData(-1, "\u9a8c\u8bc1\u7801\u9519\u8bef");
    }

    @Controller(action="/dologin", response=Response.VIEW, viewType=ViewType.FREE_MARKER, requestMethod=RequestMethod.POST)
    public String doLogin(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (SessionManager.get(httpServletRequest, httpServletResponse) == null) {
            try {
                AuthManager.login(httpServletRequest, httpServletResponse);
                new ResponseHandler(httpServletRequest, httpServletResponse).redirect("/");
            }
            catch (Exception exception) {
                httpServletRequest.setAttribute("error", (Object)exception.getMessage());
                return "login.html";
            }
        } else {
            new ResponseHandler(httpServletRequest, httpServletResponse).redirect("/");
        }
        return null;
    }

    @Controller(action="/quit", response=Response.VIEW, viewType=ViewType.FREE_MARKER)
    public String quit() {
        return "quit.html";
    }

    static {
        gateActions.add(URL_LOGIN);
        gateActions.add(URL_VALIDATECODE);
        gateActions.add(URL_DOLOGIN);
        gateActions.add(URL_QUIT);
    }
}

