/*
 * Decompiled with CFR 0.152.
 */
package com.sybotan.android.graphy;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.RectF;
import android.util.Log;
import com.sybotan.android.graphy.SGraphyScene;
import com.sybotan.android.graphy.SMotionEvent;
import com.sybotan.android.graphy.enums.SGraphyItemFlag;
import com.sybotan.android.graphy.listeners.SGraphyItemPosListener;
import com.sybotan.android.graphy.utils.MatrixTools;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.anko.AnkoAsyncContext;
import org.jetbrains.anko.AsyncKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 m2\u00020\u0001:\u0001mB\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0002\u0010\u0003J\b\u0010B\u001a\u00020CH\u0016J\u000e\u0010D\u001a\u00020\u00162\u0006\u0010E\u001a\u00020'J\u0018\u0010D\u001a\u00020\u00162\u0006\u0010F\u001a\u00020\u00052\u0006\u0010G\u001a\u00020\u0005H\u0016J\u0010\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020\u0000H\u0002J\u0006\u0010K\u001a\u00020IJ\u0010\u0010L\u001a\u00020I2\b\b\u0002\u0010M\u001a\u00020CJ\f\u0010N\u001a\b\u0012\u0004\u0012\u00020\u00000OJ\u000e\u0010P\u001a\u00020'2\u0006\u0010E\u001a\u00020'J\u0016\u0010P\u001a\u00020'2\u0006\u0010F\u001a\u00020\u00052\u0006\u0010G\u001a\u00020\u0005J\u000e\u0010Q\u001a\u00020'2\u0006\u0010E\u001a\u00020'J\u0016\u0010Q\u001a\u00020'2\u0006\u0010F\u001a\u00020\u00052\u0006\u0010G\u001a\u00020\u0005J\u000e\u0010R\u001a\u00020I2\u0006\u0010(\u001a\u00020'J\u0016\u0010R\u001a\u00020I2\u0006\u0010F\u001a\u00020\u00052\u0006\u0010G\u001a\u00020\u0005J\u0010\u0010S\u001a\u00020\u00162\u0006\u0010T\u001a\u00020UH\u0016J\u0018\u0010V\u001a\u00020I2\u0006\u0010W\u001a\u00020X2\u0006\u0010M\u001a\u00020CH\u0016J(\u0010Y\u001a\u00020\u00162\u0006\u0010Z\u001a\u00020U2\u0006\u0010[\u001a\u00020U2\u0006\u0010\\\u001a\u00020\u00052\u0006\u0010]\u001a\u00020\u0005H\u0016J\b\u0010^\u001a\u00020IH\u0016J\u0010\u0010_\u001a\u00020\u00162\u0006\u0010T\u001a\u00020UH\u0016J\b\u0010`\u001a\u00020IH\u0016J(\u0010a\u001a\u00020\u00162\u0006\u0010Z\u001a\u00020U2\u0006\u0010[\u001a\u00020U2\u0006\u0010b\u001a\u00020\u00052\u0006\u0010c\u001a\u00020\u0005H\u0016J\u0010\u0010d\u001a\u00020\u00162\u0006\u0010T\u001a\u00020UH\u0016J\u0010\u0010e\u001a\u00020\u00162\u0006\u0010T\u001a\u00020UH\u0016J\u000e\u0010f\u001a\u00020I2\u0006\u0010g\u001a\u00020hJ\b\u0010i\u001a\u00020IH\u0002J\u0006\u0010j\u001a\u00020kJ\u0006\u0010l\u001a\u00020IR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00000\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR \u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R$\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0016@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0013\u0010\u001c\u001a\u0004\u0018\u00010\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR$\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0016@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0019\"\u0004\b \u0010\u001bR\u001a\u0010!\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0019\"\u0004\b\"\u0010\u001bR$\u0010#\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0016@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0019\"\u0004\b$\u0010\u001bR(\u0010\u0002\u001a\u0004\u0018\u00010\u00002\b\u0010\u0015\u001a\u0004\u0018\u00010\u0000@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u001e\"\u0004\b&\u0010\u0003R$\u0010(\u001a\u00020'2\u0006\u0010\u0015\u001a\u00020'@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001c\u0010-\u001a\u0004\u0018\u00010.X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u001a\u00103\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u0010\u0007\"\u0004\b5\u0010\tR\u001a\u00106\u001a\u00020'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u0010*\"\u0004\b8\u0010,R\u001e\u00109\u001a\u0004\u0018\u00010:8FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>R$\u0010?\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010\u0007\"\u0004\bA\u0010\t\u00a8\u0006n"}, d2={"Lcom/sybotan/android/graphy/SGraphyItem;", "", "parent", "(Lcom/sybotan/android/graphy/SGraphyItem;)V", "_inverseScale", "", "get_inverseScale", "()F", "set_inverseScale", "(F)V", "children", "Ljava/util/ArrayList;", "getChildren", "()Ljava/util/ArrayList;", "flags", "Ljava/util/EnumSet;", "Lcom/sybotan/android/graphy/enums/SGraphyItemFlag;", "getFlags", "()Ljava/util/EnumSet;", "setFlags", "(Ljava/util/EnumSet;)V", "value", "", "focus", "getFocus", "()Z", "setFocus", "(Z)V", "focusItem", "getFocusItem", "()Lcom/sybotan/android/graphy/SGraphyItem;", "isSelected", "setSelected", "isTransform", "setTransform", "isVisible", "setVisible", "getParent", "setParent", "Landroid/graphics/PointF;", "pos", "getPos", "()Landroid/graphics/PointF;", "setPos", "(Landroid/graphics/PointF;)V", "posListener", "Lcom/sybotan/android/graphy/listeners/SGraphyItemPosListener;", "getPosListener", "()Lcom/sybotan/android/graphy/listeners/SGraphyItemPosListener;", "setPosListener", "(Lcom/sybotan/android/graphy/listeners/SGraphyItemPosListener;)V", "rotate", "getRotate", "setRotate", "scale", "getScale", "setScale", "scene", "Lcom/sybotan/android/graphy/SGraphyScene;", "getScene", "()Lcom/sybotan/android/graphy/SGraphyScene;", "setScene", "(Lcom/sybotan/android/graphy/SGraphyScene;)V", "zOrder", "getZOrder", "setZOrder", "boundingRect", "Landroid/graphics/RectF;", "contains", "point", "x", "y", "grabItem", "", "item", "hide", "invalidate", "rect", "itemPath", "", "mapFromScene", "mapToScene", "moveTo", "onDown", "e", "Lcom/sybotan/android/graphy/SMotionEvent;", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onFling", "e1", "e2", "velocityX", "velocityY", "onGetFocus", "onLongPress", "onLostFocus", "onScroll", "distanceX", "distanceY", "onShowPress", "onSingleTapUp", "postInvalidateDelayed", "delayed", "", "releaseItem", "scene2itemMattrix", "Landroid/graphics/Matrix;", "show", "Companion", "sybotan-android-graphy_release"})
public class SGraphyItem {
    @Nullable
    private SGraphyItem parent;
    @NotNull
    private final ArrayList<SGraphyItem> children;
    @Nullable
    private SGraphyScene scene;
    @NotNull
    private PointF pos;
    @Nullable
    private SGraphyItemPosListener posListener;
    private float zOrder;
    @NotNull
    private PointF scale;
    private float rotate;
    private boolean isTransform;
    private float _inverseScale;
    @NotNull
    private EnumSet<SGraphyItemFlag> flags;
    private boolean isVisible;
    private boolean focus;
    private boolean isSelected;
    private static final String TAG;
    private static SGraphyItem currentMoveItem;
    private static SGraphyItem currentFocusItem;
    public static final Companion Companion;

    @Nullable
    public final SGraphyItem getParent() {
        return this.parent;
    }

    public final void setParent(@Nullable SGraphyItem value) {
        if (Intrinsics.areEqual((Object)this.parent, (Object)value)) {
            return;
        }
        if (this.parent != null) {
            SGraphyItem sGraphyItem = this.parent;
            if (sGraphyItem == null) {
                Intrinsics.throwNpe();
            }
            sGraphyItem.children.remove(this);
        }
        this.parent = value;
        if (this.parent != null) {
            SGraphyItem sGraphyItem = this.parent;
            if (sGraphyItem == null) {
                Intrinsics.throwNpe();
            }
            sGraphyItem.children.add(this);
            SGraphyItem sGraphyItem2 = this.parent;
            if (sGraphyItem2 == null) {
                Intrinsics.throwNpe();
            }
            List $this$sortByDescending$iv = sGraphyItem2.children;
            boolean $i$f$sortByDescending = false;
            if ($this$sortByDescending$iv.size() > 1) {
                List list = $this$sortByDescending$iv;
                boolean bl = false;
                Comparator comparator = new Comparator<T>(){

                    public final int compare(T a, T b) {
                        boolean bl = false;
                        SGraphyItem it = (SGraphyItem)b;
                        boolean bl2 = false;
                        Comparable comparable = Float.valueOf(it.getZOrder());
                        it = (SGraphyItem)a;
                        Comparable comparable2 = comparable;
                        bl2 = false;
                        Float f = Float.valueOf(it.getZOrder());
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)f);
                    }
                };
                CollectionsKt.sortWith((List)list, (Comparator)comparator);
            }
        }
        SGraphyItem.invalidate$default(this, null, 1, null);
    }

    @NotNull
    public final ArrayList<SGraphyItem> getChildren() {
        return this.children;
    }

    @Nullable
    public final SGraphyScene getScene() {
        SGraphyScene sGraphyScene;
        if (this.parent != null) {
            SGraphyItem sGraphyItem = this.parent;
            if (sGraphyItem == null) {
                Intrinsics.throwNpe();
            }
            sGraphyScene = sGraphyItem.getScene();
        } else {
            sGraphyScene = this.scene;
        }
        return sGraphyScene;
    }

    public final void setScene(@Nullable SGraphyScene sGraphyScene) {
        this.scene = sGraphyScene;
    }

    @NotNull
    public final PointF getPos() {
        return this.pos;
    }

    public final void setPos(@NotNull PointF value) {
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            if (Intrinsics.areEqual((Object)this.pos, (Object)value)) {
                return;
            }
            this.pos = value;
            SGraphyItem.invalidate$default(this, null, 1, null);
            SGraphyItemPosListener sGraphyItemPosListener = this.posListener;
            if (sGraphyItemPosListener == null) break block1;
            sGraphyItemPosListener.onMoveTo(this.pos.x, this.pos.y);
        }
    }

    @Nullable
    public final SGraphyItemPosListener getPosListener() {
        return this.posListener;
    }

    public final void setPosListener(@Nullable SGraphyItemPosListener sGraphyItemPosListener) {
        this.posListener = sGraphyItemPosListener;
    }

    public final float getZOrder() {
        return this.zOrder;
    }

    public final void setZOrder(float value) {
        if (this.zOrder == value) {
            return;
        }
        this.zOrder = value;
        if (this.parent != null) {
            SGraphyItem sGraphyItem = this.parent;
            if (sGraphyItem == null) {
                Intrinsics.throwNpe();
            }
            List $this$sortByDescending$iv = sGraphyItem.children;
            boolean $i$f$sortByDescending = false;
            if ($this$sortByDescending$iv.size() > 1) {
                List list = $this$sortByDescending$iv;
                boolean bl = false;
                Comparator comparator = new Comparator<T>(){

                    public final int compare(T a, T b) {
                        boolean bl = false;
                        SGraphyItem it = (SGraphyItem)b;
                        boolean bl2 = false;
                        Comparable comparable = Float.valueOf(it.getZOrder());
                        it = (SGraphyItem)a;
                        Comparable comparable2 = comparable;
                        bl2 = false;
                        Float f = Float.valueOf(it.getZOrder());
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)f);
                    }
                };
                CollectionsKt.sortWith((List)list, (Comparator)comparator);
            }
        }
        SGraphyItem.invalidate$default(this, null, 1, null);
    }

    @NotNull
    public final PointF getScale() {
        return this.scale;
    }

    public final void setScale(@NotNull PointF pointF) {
        Intrinsics.checkParameterIsNotNull((Object)pointF, (String)"<set-?>");
        this.scale = pointF;
    }

    public final float getRotate() {
        return this.rotate;
    }

    public final void setRotate(float f) {
        this.rotate = f;
    }

    public final boolean isTransform() {
        return this.isTransform;
    }

    public final void setTransform(boolean bl) {
        this.isTransform = bl;
    }

    public final float get_inverseScale() {
        return this._inverseScale;
    }

    public final void set_inverseScale(float f) {
        this._inverseScale = f;
    }

    @NotNull
    public final EnumSet<SGraphyItemFlag> getFlags() {
        return this.flags;
    }

    public final void setFlags(@NotNull EnumSet<SGraphyItemFlag> enumSet) {
        Intrinsics.checkParameterIsNotNull(enumSet, (String)"<set-?>");
        this.flags = enumSet;
    }

    public final boolean isVisible() {
        return this.isVisible;
    }

    public final void setVisible(boolean value) {
        if (this.isVisible == value) {
            return;
        }
        this.isVisible = value;
        SGraphyItem.invalidate$default(this, null, 1, null);
    }

    public final boolean getFocus() {
        return this.focus;
    }

    public final void setFocus(boolean value) {
        if (!this.flags.contains((Object)SGraphyItemFlag.ItemIsFocusable)) {
            return;
        }
        if (this.focus == value) {
            return;
        }
        this.focus = value;
        if (value) {
            SGraphyItem sGraphyItem = currentFocusItem;
            if (sGraphyItem != null) {
                sGraphyItem.setFocus(false);
            }
            this.onGetFocus();
            currentFocusItem = this;
        } else {
            this.onLostFocus();
            if (currentFocusItem == this) {
                currentFocusItem = null;
            }
        }
    }

    @Nullable
    public final SGraphyItem getFocusItem() {
        return currentFocusItem;
    }

    public final boolean isSelected() {
        return this.isSelected;
    }

    public final void setSelected(boolean value) {
        if (this.isSelected == value) {
            return;
        }
        this.isSelected = value;
        SGraphyItem.invalidate$default(this, null, 1, null);
    }

    @NotNull
    public RectF boundingRect() {
        return new RectF();
    }

    public final void invalidate(@NotNull RectF rect) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)rect, (String)"rect");
            SGraphyScene sGraphyScene = this.getScene();
            if (sGraphyScene == null) break block0;
            sGraphyScene.update();
        }
    }

    public static /* synthetic */ void invalidate$default(SGraphyItem sGraphyItem, RectF rectF, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: invalidate");
        }
        if ((n & 1) != 0) {
            rectF = new RectF();
        }
        sGraphyItem.invalidate(rectF);
    }

    public final void postInvalidateDelayed(long delayed) {
        AsyncKt.doAsync$default((Object)this, null, (Function1)((Function1)new Function1<AnkoAsyncContext<SGraphyItem>, Unit>(this, delayed){
            final /* synthetic */ SGraphyItem this$0;
            final /* synthetic */ long $delayed;

            public final void invoke(@NotNull AnkoAsyncContext<SGraphyItem> $this$doAsync) {
                Intrinsics.checkParameterIsNotNull($this$doAsync, (String)"$receiver");
                Thread.sleep(this.$delayed);
                SGraphyItem.invalidate$default(this.this$0, null, 1, null);
            }
            {
                this.this$0 = sGraphyItem;
                this.$delayed = l;
                super(1);
            }
        }), (int)1, null);
    }

    public final void hide() {
        this.setVisible(false);
    }

    public final void show() {
        this.setVisible(true);
    }

    public final void moveTo(@NotNull PointF pos) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        this.setPos(pos);
    }

    public final void moveTo(float x, float y) {
        this.setPos(new PointF(x, y));
    }

    @NotNull
    public final PointF mapFromScene(float x, float y) {
        Matrix m = this.scene2itemMattrix();
        m.invert(m);
        return MatrixTools.INSTANCE.matrixTransform(m, x, y);
    }

    @NotNull
    public final PointF mapFromScene(@NotNull PointF point) {
        Intrinsics.checkParameterIsNotNull((Object)point, (String)"point");
        return new PointF(point.x, point.y);
    }

    @NotNull
    public final PointF mapToScene(float x, float y) {
        if (this.parent == null) {
            return new PointF(x, y);
        }
        Matrix m = this.scene2itemMattrix();
        return MatrixTools.INSTANCE.matrixTransform(m, x, y);
    }

    @NotNull
    public final PointF mapToScene(@NotNull PointF point) {
        Intrinsics.checkParameterIsNotNull((Object)point, (String)"point");
        return new PointF(point.x, point.y);
    }

    @NotNull
    public final List<SGraphyItem> itemPath() {
        if (this.parent != null) {
            SGraphyItem sGraphyItem = this.parent;
            if (sGraphyItem == null) {
                Intrinsics.throwNpe();
            }
            List<SGraphyItem> list = sGraphyItem.itemPath();
            list.add(this);
            return list;
        }
        return CollectionsKt.mutableListOf((Object[])new SGraphyItem[]{this});
    }

    public boolean contains(float x, float y) {
        return this.boundingRect().contains(x, y);
    }

    public final boolean contains(@NotNull PointF point) {
        Intrinsics.checkParameterIsNotNull((Object)point, (String)"point");
        return this.contains(point.x, point.y);
    }

    /*
     * WARNING - void declaration
     */
    public void onDraw(@NotNull Canvas canvas, @NotNull RectF rect) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Intrinsics.checkParameterIsNotNull((Object)rect, (String)"rect");
        float[] src = new float[]{0.0f, 1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f};
        int n = 1;
        int n2 = this.children.size();
        if (n <= n2) {
            while (true) {
                SGraphyItem item;
                void i;
                Intrinsics.checkExpressionValueIsNotNull((Object)this.children.get(this.children.size() - i), (String)"children[children.size - i]");
                if (item.isVisible) {
                    try {
                        canvas.save();
                        canvas.translate(item.pos.x, item.pos.y);
                        canvas.scale(item.scale.x, item.scale.y);
                        canvas.rotate(item.rotate);
                        if (item.isTransform) {
                            Matrix matrix = canvas.getMatrix();
                            matrix.getValues(src);
                            item._inverseScale = 1.0f / src[0];
                            canvas.scale(item._inverseScale, item._inverseScale);
                        }
                        item.onDraw(canvas, rect);
                        canvas.restore();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (i == n2) break;
                ++i;
            }
        }
    }

    public void onGetFocus() {
    }

    public void onLostFocus() {
    }

    public boolean onDown(@NotNull SMotionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        for (SGraphyItem item : this.children) {
            if (!item.isVisible) continue;
            SGraphyItem sGraphyItem = item;
            Intrinsics.checkExpressionValueIsNotNull((Object)sGraphyItem, (String)"item");
            SMotionEvent ce = Companion.toChildMotionEvent(sGraphyItem, e);
            if (!item.contains(ce.getX(), ce.getY()) || !item.onDown(ce)) continue;
            return true;
        }
        if (this.flags.contains((Object)SGraphyItemFlag.ItemIsFocusable)) {
            this.setFocus(true);
            return true;
        }
        return false;
    }

    public boolean onSingleTapUp(@NotNull SMotionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Log.d((String)TAG, (String)"onSingleTapUp\uff1a releaseItem");
        this.releaseItem();
        for (SGraphyItem item : this.children) {
            if (!item.isVisible) continue;
            SGraphyItem sGraphyItem = item;
            Intrinsics.checkExpressionValueIsNotNull((Object)sGraphyItem, (String)"item");
            SMotionEvent ce = Companion.toChildMotionEvent(sGraphyItem, e);
            if (!item.contains(ce.getX(), ce.getY()) || !item.onSingleTapUp(ce)) continue;
            return true;
        }
        return false;
    }

    public boolean onShowPress(@NotNull SMotionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Log.d((String)TAG, (String)"onShowPress\uff1a releaseItem");
        for (SGraphyItem item : this.children) {
            if (!item.isVisible) continue;
            SGraphyItem sGraphyItem = item;
            Intrinsics.checkExpressionValueIsNotNull((Object)sGraphyItem, (String)"item");
            SMotionEvent ce = Companion.toChildMotionEvent(sGraphyItem, e);
            if (!item.contains(ce.getX(), ce.getY()) || !item.onShowPress(ce)) continue;
            return true;
        }
        return false;
    }

    public boolean onLongPress(@NotNull SMotionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Log.d((String)TAG, (String)"onLongPress\uff1a releaseItem");
        this.releaseItem();
        for (SGraphyItem item : this.children) {
            if (!item.isVisible) continue;
            SGraphyItem sGraphyItem = item;
            Intrinsics.checkExpressionValueIsNotNull((Object)sGraphyItem, (String)"item");
            SMotionEvent ce = Companion.toChildMotionEvent(sGraphyItem, e);
            if (!item.contains(ce.getX(), ce.getY()) || !item.onLongPress(ce)) continue;
            return true;
        }
        return false;
    }

    public boolean onScroll(@NotNull SMotionEvent e1, @NotNull SMotionEvent e2, float distanceX, float distanceY) {
        Intrinsics.checkParameterIsNotNull((Object)e1, (String)"e1");
        Intrinsics.checkParameterIsNotNull((Object)e2, (String)"e2");
        if (this.flags.contains((Object)SGraphyItemFlag.ItemIsMovable) && currentMoveItem == this) {
            this.moveTo(this.pos.x - distanceX * this.scale.x, this.pos.y - distanceY * this.scale.y);
            return true;
        }
        for (SGraphyItem item : this.children) {
            if (!item.isVisible) continue;
            SGraphyItem sGraphyItem = item;
            Intrinsics.checkExpressionValueIsNotNull((Object)sGraphyItem, (String)"item");
            SMotionEvent ce1 = Companion.toChildMotionEvent(sGraphyItem, e1);
            SMotionEvent ce2 = Companion.toChildMotionEvent(item, e2);
            if (!item.contains(ce2.getX(), ce2.getY()) || !item.onScroll(ce1, ce2, distanceX / item.scale.x, distanceY / item.scale.y)) continue;
            return true;
        }
        if (this.flags.contains((Object)SGraphyItemFlag.ItemIsMovable) && currentMoveItem == null) {
            this.grabItem(this);
            currentMoveItem = this;
            return true;
        }
        return false;
    }

    public boolean onFling(@NotNull SMotionEvent e1, @NotNull SMotionEvent e2, float velocityX, float velocityY) {
        Intrinsics.checkParameterIsNotNull((Object)e1, (String)"e1");
        Intrinsics.checkParameterIsNotNull((Object)e2, (String)"e2");
        Log.d((String)TAG, (String)"onFling\uff1a releaseItem");
        this.releaseItem();
        for (SGraphyItem item : this.children) {
            if (!item.isVisible) continue;
            SGraphyItem sGraphyItem = item;
            Intrinsics.checkExpressionValueIsNotNull((Object)sGraphyItem, (String)"item");
            SMotionEvent ce1 = Companion.toChildMotionEvent(sGraphyItem, e1);
            SMotionEvent ce2 = Companion.toChildMotionEvent(item, e2);
            if (!item.contains(ce2.getX(), ce2.getY()) || !item.onFling(ce1, ce2, velocityX / item.scale.x, velocityY / item.scale.y)) continue;
            return true;
        }
        return false;
    }

    private final void grabItem(SGraphyItem item) {
        Log.d((String)TAG, (String)"grabItem");
        this.setSelected(true);
        SGraphyScene sGraphyScene = this.getScene();
        if (sGraphyScene == null) {
            Intrinsics.throwNpe();
        }
        sGraphyScene.setGrabItem(item);
    }

    private final void releaseItem() {
        this.setSelected(false);
        SGraphyScene sGraphyScene = this.getScene();
        if (sGraphyScene == null) {
            Intrinsics.throwNpe();
        }
        sGraphyScene.setGrabItem(null);
    }

    @NotNull
    public final Matrix scene2itemMattrix() {
        Matrix m = new Matrix();
        List<SGraphyItem> list = this.itemPath();
        for (SGraphyItem item : list) {
            m.postTranslate(item.pos.x, item.pos.y);
            m.postScale(item.scale.x, item.scale.y);
            m.postRotate(item.rotate);
            if (item.isTransform) continue;
            m.postScale(item._inverseScale, item._inverseScale);
        }
        return m;
    }

    public SGraphyItem(@Nullable SGraphyItem parent) {
        this.parent = parent;
        this.children = new ArrayList();
        this.pos = new PointF(0.0f, 0.0f);
        this.scale = new PointF(1.0f, 1.0f);
        this.isTransform = true;
        this._inverseScale = 1.0f;
        EnumSet<SGraphyItemFlag> enumSet = EnumSet.noneOf(SGraphyItemFlag.class);
        Intrinsics.checkExpressionValueIsNotNull(enumSet, (String)"EnumSet.noneOf(SGraphyItemFlag::class.java)");
        this.flags = enumSet;
        this.isVisible = true;
    }

    public /* synthetic */ SGraphyItem(SGraphyItem sGraphyItem, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            sGraphyItem = null;
        }
        this(sGraphyItem);
    }

    public SGraphyItem() {
        this(null, 1, null);
    }

    static {
        Companion = new Companion(null);
        TAG = SGraphyItem.class.getName();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\nR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/sybotan/android/graphy/SGraphyItem$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "currentFocusItem", "Lcom/sybotan/android/graphy/SGraphyItem;", "currentMoveItem", "toChildMotionEvent", "Lcom/sybotan/android/graphy/SMotionEvent;", "child", "e", "sybotan-android-graphy_release"})
    public static final class Companion {
        @NotNull
        public final SMotionEvent toChildMotionEvent(@NotNull SGraphyItem child, @NotNull SMotionEvent e) {
            Intrinsics.checkParameterIsNotNull((Object)child, (String)"child");
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            SMotionEvent ce = new SMotionEvent(e);
            ce.getMatrix().postTranslate(child.getPos().x, child.getPos().y);
            ce.getMatrix().postScale(child.getScale().x, child.getScale().y);
            ce.getMatrix().postRotate(child.getRotate(), 0.0f, 0.0f);
            if (!child.isTransform()) {
                ce.getMatrix().postScale(child.get_inverseScale(), child.get_inverseScale());
            }
            PointF matrixTransform = MatrixTools.INSTANCE.matrixTransform(ce.getMatrix(), e.getX(), e.getY());
            ce.setX(matrixTransform.x);
            ce.setY(matrixTransform.y);
            return ce;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

