/*
 * Decompiled with CFR 0.152.
 */
package com.sybotan.android.graphy;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.PointF;
import android.graphics.RectF;
import android.util.Log;
import android.view.MotionEvent;
import com.sybotan.android.base.extensions.SRectFExtensionKt;
import com.sybotan.android.graphy.SGraphyItem;
import com.sybotan.android.graphy.SGraphyView;
import com.sybotan.android.graphy.data.SLineF;
import com.sybotan.android.graphy.enums.SGraphyItemFlag;
import com.sybotan.android.graphy.items.SGraphyImageItem;
import com.sybotan.android.graphy.items.SGraphyLineItem;
import com.sybotan.android.graphy.items.SGraphyRectItem;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 E2\u00020\u0001:\u0001EB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0004J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ&\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u001fJ\u000e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&J&\u0010#\u001a\u00020$2\u0006\u0010'\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020\u001f2\u0006\u0010)\u001a\u00020\u001f2\u0006\u0010*\u001a\u00020\u001fJ\u0018\u0010+\u001a\u00020\u00182\u0006\u0010,\u001a\u00020-2\u0006\u0010%\u001a\u00020&H\u0016J\u0018\u0010.\u001a\u00020\u00182\u0006\u0010,\u001a\u00020-2\u0006\u0010%\u001a\u00020&H\u0016J\u0018\u0010/\u001a\u00020\u00182\u0006\u0010,\u001a\u00020-2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0016J(\u00104\u001a\u0002012\u0006\u00105\u001a\u0002032\u0006\u00106\u001a\u0002032\u0006\u00107\u001a\u00020\u001f2\u0006\u00108\u001a\u00020\u001fH\u0016J\u0010\u00109\u001a\u0002012\u0006\u00102\u001a\u000203H\u0016J(\u0010:\u001a\u0002012\u0006\u00105\u001a\u0002032\u0006\u00106\u001a\u0002032\u0006\u0010;\u001a\u00020\u001f2\u0006\u0010<\u001a\u00020\u001fH\u0016J\u000e\u0010=\u001a\u0002012\u0006\u00102\u001a\u000203J\u0010\u0010>\u001a\u0002012\u0006\u00102\u001a\u000203H\u0016J\u000e\u0010?\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0004J \u0010@\u001a\u00020A2\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010;\u001a\u00020\u001f2\u0006\u0010<\u001a\u00020\u001fH\u0002J\u0018\u0010B\u001a\u0002032\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u00102\u001a\u000203H\u0002J\u0006\u0010C\u001a\u00020\u0018J\u0006\u0010D\u001a\u00020&R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001b\u0010\t\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\n\u0010\u0006R\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006F"}, d2={"Lcom/sybotan/android/graphy/SGraphyScene;", "", "()V", "grabItem", "Lcom/sybotan/android/graphy/SGraphyItem;", "getGrabItem", "()Lcom/sybotan/android/graphy/SGraphyItem;", "setGrabItem", "(Lcom/sybotan/android/graphy/SGraphyItem;)V", "rootNode", "getRootNode", "rootNode$delegate", "Lkotlin/Lazy;", "view", "Lcom/sybotan/android/graphy/SGraphyView;", "getView", "()Lcom/sybotan/android/graphy/SGraphyView;", "setView", "(Lcom/sybotan/android/graphy/SGraphyView;)V", "addImageItem", "Lcom/sybotan/android/graphy/items/SGraphyImageItem;", "image", "Landroid/graphics/Bitmap;", "addItem", "", "item", "addLineItem", "Lcom/sybotan/android/graphy/items/SGraphyLineItem;", "line", "Lcom/sybotan/android/graphy/data/SLineF;", "x1", "", "y1", "x2", "y2", "addRectItem", "Lcom/sybotan/android/graphy/items/SGraphyRectItem;", "rect", "Landroid/graphics/RectF;", "left", "top", "right", "bottom", "drawBackground", "canvas", "Landroid/graphics/Canvas;", "drawForeground", "drawScene", "onDown", "", "e", "Landroid/view/MotionEvent;", "onFling", "e1", "e2", "velocityX", "velocityY", "onLongPress", "onScroll", "distanceX", "distanceY", "onShowPress", "onSingleTapUp", "removeItem", "toGrabItemDistance", "Landroid/graphics/PointF;", "toGrabItemMotionEvent", "update", "worldRect", "Companion", "sybotan-android-graphy_release"})
public class SGraphyScene {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final Lazy rootNode$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SGraphyItem>(this){
        final /* synthetic */ SGraphyScene this$0;

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final SGraphyItem invoke() {
            void var1_1;
            SGraphyItem item = new SGraphyItem(null, 1, null);
            item.setScene(this.this$0);
            item.getFlags().add(SGraphyItemFlag.ItemIsFocusable);
            return var1_1;
        }
        {
            this.this$0 = sGraphyScene;
            super(0);
        }
    }));
    @Nullable
    private SGraphyItem grabItem;
    @Nullable
    private SGraphyView view;
    private static final String TAG;
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(SGraphyScene.class), "rootNode", "getRootNode()Lcom/sybotan/android/graphy/SGraphyItem;"))};
        Companion = new Companion(null);
        TAG = SGraphyScene.class.getName();
    }

    private final SGraphyItem getRootNode() {
        Lazy lazy = this.rootNode$delegate;
        SGraphyScene sGraphyScene = this;
        KProperty kProperty = $$delegatedProperties[0];
        boolean bl = false;
        return (SGraphyItem)lazy.getValue();
    }

    @Nullable
    public final SGraphyItem getGrabItem() {
        return this.grabItem;
    }

    public final void setGrabItem(@Nullable SGraphyItem sGraphyItem) {
        this.grabItem = sGraphyItem;
    }

    @Nullable
    public final SGraphyView getView() {
        return this.view;
    }

    public final void setView(@Nullable SGraphyView sGraphyView) {
        this.view = sGraphyView;
    }

    public void drawScene(@NotNull Canvas canvas, @NotNull RectF rect) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Intrinsics.checkParameterIsNotNull((Object)rect, (String)"rect");
        this.getRootNode().onDraw(canvas, rect);
    }

    public void drawBackground(@NotNull Canvas canvas, @NotNull RectF rect) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Intrinsics.checkParameterIsNotNull((Object)rect, (String)"rect");
        canvas.drawColor(-1);
    }

    public void drawForeground(@NotNull Canvas canvas, @NotNull RectF rect) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Intrinsics.checkParameterIsNotNull((Object)rect, (String)"rect");
    }

    public final void addItem(@NotNull SGraphyItem item) {
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        item.setParent(this.getRootNode());
    }

    @NotNull
    public final SGraphyImageItem addImageItem(@NotNull Bitmap image) {
        Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
        SGraphyImageItem item = new SGraphyImageItem(image, null, 2, null);
        this.addItem(item);
        return item;
    }

    @NotNull
    public final SGraphyLineItem addLineItem(@NotNull SLineF line) {
        Intrinsics.checkParameterIsNotNull((Object)line, (String)"line");
        SGraphyLineItem item = new SGraphyLineItem(line, null, 2, null);
        this.addItem(item);
        return item;
    }

    @NotNull
    public final SGraphyLineItem addLineItem(float x1, float y1, float x2, float y2) {
        SGraphyLineItem item = new SGraphyLineItem(x1, y1, x2, y2, null, 16, null);
        this.addItem(item);
        return item;
    }

    @NotNull
    public final SGraphyRectItem addRectItem(@NotNull RectF rect) {
        Intrinsics.checkParameterIsNotNull((Object)rect, (String)"rect");
        SGraphyRectItem item = new SGraphyRectItem(rect, null, 2, null);
        this.addItem(item);
        return item;
    }

    @NotNull
    public final SGraphyRectItem addRectItem(float left, float top, float right, float bottom) {
        SGraphyRectItem item = new SGraphyRectItem(left, top, right, bottom, null, 16, null);
        this.addItem(item);
        return item;
    }

    public final void removeItem(@NotNull SGraphyItem item) {
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        item.setParent(null);
    }

    @NotNull
    public final RectF worldRect() {
        RectF rect = new RectF();
        for (SGraphyItem item : this.getRootNode().getChildren()) {
            rect.union(SRectFExtensionKt.adjusted((RectF)item.boundingRect(), (PointF)item.getPos()));
        }
        return rect;
    }

    public final void update() {
        Log.d((String)TAG, (String)"update");
    }

    public boolean onDown(@NotNull MotionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        if (this.grabItem != null) {
            return true;
        }
        return this.getRootNode().onDown(e);
    }

    public boolean onSingleTapUp(@NotNull MotionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        if (this.grabItem != null) {
            SGraphyItem sGraphyItem = this.grabItem;
            if (sGraphyItem == null) {
                Intrinsics.throwNpe();
            }
            MotionEvent ie = this.toGrabItemMotionEvent(sGraphyItem, e);
            SGraphyItem sGraphyItem2 = this.grabItem;
            if (sGraphyItem2 == null) {
                Intrinsics.throwNpe();
            }
            return sGraphyItem2.onSingleTapUp(ie);
        }
        return this.getRootNode().onSingleTapUp(e);
    }

    public final boolean onShowPress(@NotNull MotionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        if (this.grabItem != null) {
            SGraphyItem sGraphyItem = this.grabItem;
            if (sGraphyItem == null) {
                Intrinsics.throwNpe();
            }
            MotionEvent ie = this.toGrabItemMotionEvent(sGraphyItem, e);
            SGraphyItem sGraphyItem2 = this.grabItem;
            if (sGraphyItem2 == null) {
                Intrinsics.throwNpe();
            }
            sGraphyItem2.onShowPress(ie);
            return true;
        }
        return this.getRootNode().onShowPress(e);
    }

    public boolean onLongPress(@NotNull MotionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        if (this.grabItem != null) {
            SGraphyItem sGraphyItem = this.grabItem;
            if (sGraphyItem == null) {
                Intrinsics.throwNpe();
            }
            MotionEvent ie = this.toGrabItemMotionEvent(sGraphyItem, e);
            SGraphyItem sGraphyItem2 = this.grabItem;
            if (sGraphyItem2 == null) {
                Intrinsics.throwNpe();
            }
            return sGraphyItem2.onLongPress(ie);
        }
        return this.getRootNode().onLongPress(e);
    }

    public boolean onScroll(@NotNull MotionEvent e1, @NotNull MotionEvent e2, float distanceX, float distanceY) {
        Intrinsics.checkParameterIsNotNull((Object)e1, (String)"e1");
        Intrinsics.checkParameterIsNotNull((Object)e2, (String)"e2");
        if (this.grabItem != null) {
            SGraphyItem sGraphyItem = this.grabItem;
            if (sGraphyItem == null) {
                Intrinsics.throwNpe();
            }
            MotionEvent ie1 = this.toGrabItemMotionEvent(sGraphyItem, e1);
            SGraphyItem sGraphyItem2 = this.grabItem;
            if (sGraphyItem2 == null) {
                Intrinsics.throwNpe();
            }
            MotionEvent ie2 = this.toGrabItemMotionEvent(sGraphyItem2, e2);
            SGraphyItem sGraphyItem3 = this.grabItem;
            if (sGraphyItem3 == null) {
                Intrinsics.throwNpe();
            }
            PointF distance = this.toGrabItemDistance(sGraphyItem3, distanceX, distanceY);
            SGraphyItem sGraphyItem4 = this.grabItem;
            if (sGraphyItem4 == null) {
                Intrinsics.throwNpe();
            }
            return sGraphyItem4.onScroll(ie1, ie2, distance.x, distance.y);
        }
        return this.getRootNode().onScroll(e1, e2, distanceX, distanceY);
    }

    public boolean onFling(@NotNull MotionEvent e1, @NotNull MotionEvent e2, float velocityX, float velocityY) {
        Intrinsics.checkParameterIsNotNull((Object)e1, (String)"e1");
        Intrinsics.checkParameterIsNotNull((Object)e2, (String)"e2");
        if (this.grabItem != null) {
            SGraphyItem sGraphyItem = this.grabItem;
            if (sGraphyItem == null) {
                Intrinsics.throwNpe();
            }
            MotionEvent ie1 = this.toGrabItemMotionEvent(sGraphyItem, e1);
            SGraphyItem sGraphyItem2 = this.grabItem;
            if (sGraphyItem2 == null) {
                Intrinsics.throwNpe();
            }
            MotionEvent ie2 = this.toGrabItemMotionEvent(sGraphyItem2, e2);
            SGraphyItem sGraphyItem3 = this.grabItem;
            if (sGraphyItem3 == null) {
                Intrinsics.throwNpe();
            }
            PointF velocity = this.toGrabItemDistance(sGraphyItem3, velocityX, velocityY);
            SGraphyItem sGraphyItem4 = this.grabItem;
            if (sGraphyItem4 == null) {
                Intrinsics.throwNpe();
            }
            return sGraphyItem4.onFling(ie1, ie2, velocity.x, velocity.y);
        }
        return this.getRootNode().onFling(e1, e2, velocityX, velocityY);
    }

    private final MotionEvent toGrabItemMotionEvent(SGraphyItem item, MotionEvent e) {
        MotionEvent se = MotionEvent.obtain((MotionEvent)e);
        PointF p = item.mapFromScene(e.getX(), e.getY());
        se.setLocation(p.x, p.y);
        MotionEvent motionEvent = se;
        Intrinsics.checkExpressionValueIsNotNull((Object)motionEvent, (String)"se");
        return motionEvent;
    }

    private final PointF toGrabItemDistance(SGraphyItem item, float distanceX, float distanceY) {
        PointF p = new PointF(distanceX, distanceY);
        List<SGraphyItem> list = item.itemPath();
        for (SGraphyItem child : list) {
            p.x /= child.getScale().x;
            p.y /= child.getScale().y;
        }
        return p;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/sybotan/android/graphy/SGraphyScene$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "sybotan-android-graphy_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

