/*
 * Decompiled with CFR 0.152.
 */
package com.sybotan.android.database;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import com.sybotan.android.base.SApplication;
import com.sybotan.android.database.extensions.SSQLiteDatabaseExtensionKt;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.anko.db.ManagedSQLiteOpenHelper;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/sybotan/android/database/SDatabase;", "Lorg/jetbrains/anko/db/ManagedSQLiteOpenHelper;", "()V", "onCreate", "", "db", "Landroid/database/sqlite/SQLiteDatabase;", "onUpgrade", "oldVersion", "", "newVersion", "sybotan-android-database_debug"})
public final class SDatabase
extends ManagedSQLiteOpenHelper {
    public static final SDatabase INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCreate(@NotNull SQLiteDatabase db) {
        Intrinsics.checkParameterIsNotNull((Object)db, (String)"db");
        InputStream input = null;
        try {
            Context context = SApplication.Companion.getApp().getApplicationContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"SApplication.app.applicationContext");
            InputStream inputStream = input = context.getAssets().open("sql/database.sql");
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"input");
            SSQLiteDatabaseExtensionKt.execSQL(db, inputStream);
            input.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            InputStream inputStream = input;
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUpgrade(@NotNull SQLiteDatabase db, int oldVersion, int newVersion) {
        Intrinsics.checkParameterIsNotNull((Object)db, (String)"db");
        InputStream input = null;
        try {
            Context context = SApplication.Companion.getApp().getApplicationContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"SApplication.app.applicationContext");
            InputStream inputStream = input = context.getAssets().open("sql/database_" + oldVersion + '-' + newVersion + ".sql");
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"input");
            SSQLiteDatabaseExtensionKt.execSQL(db, inputStream);
            input.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            InputStream inputStream = input;
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    private SDatabase() {
        Context context = SApplication.Companion.getApp().getApplicationContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"SApplication.app.applicationContext");
        super(context, "SDatabase.db", null, SApplication.Companion.getApp().getDatabaseVersion());
    }

    static {
        SDatabase sDatabase;
        INSTANCE = sDatabase = new SDatabase();
    }
}

