/*
 * Decompiled with CFR 0.152.
 */
package com.sybotan.android.graphy;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.PointF;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.util.Log;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import com.sybotan.android.graphy.SGraphyScene;
import com.sybotan.android.graphy.enums.SGraphyViewTouchState;
import com.sybotan.android.graphy.events.SGraphyViewMoveEvent;
import com.sybotan.android.graphy.events.SGraphyViewZoomEvent;
import java.util.HashMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.greenrobot.eventbus.EventBus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u0016\u0018\u0000 p2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u0005:\u0001pB\u0019\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020CH\u0016J\u0006\u0010D\u001a\u00020AJ\u0010\u0010E\u001a\u00020\f2\u0006\u0010F\u001a\u00020GH\u0002J\u0010\u0010H\u001a\u00020\u001f2\u0006\u0010F\u001a\u00020GH\u0002J\b\u0010I\u001a\u00020AH\u0002J\u000e\u0010J\u001a\u00020\u001f2\u0006\u0010K\u001a\u00020\u001fJ\u0016\u0010J\u001a\u00020\u001f2\u0006\u0010L\u001a\u00020\f2\u0006\u0010M\u001a\u00020\fJ\u000e\u0010N\u001a\u00020\u001f2\u0006\u0010K\u001a\u00020\u001fJ\u0016\u0010N\u001a\u00020\u001f2\u0006\u0010L\u001a\u00020\f2\u0006\u0010M\u001a\u00020\fJ\u0010\u0010O\u001a\u00020\u000f2\u0006\u0010P\u001a\u00020GH\u0016J(\u0010Q\u001a\u00020\u000f2\u0006\u0010R\u001a\u00020G2\u0006\u0010S\u001a\u00020G2\u0006\u0010T\u001a\u00020\f2\u0006\u0010U\u001a\u00020\fH\u0016J\u0010\u0010V\u001a\u00020A2\u0006\u0010P\u001a\u00020GH\u0016J(\u0010W\u001a\u00020\u000f2\u0006\u0010R\u001a\u00020G2\u0006\u0010S\u001a\u00020G2\u0006\u0010X\u001a\u00020\f2\u0006\u0010Y\u001a\u00020\fH\u0016J\u0010\u0010Z\u001a\u00020A2\u0006\u0010P\u001a\u00020GH\u0016J\u0010\u0010[\u001a\u00020\u000f2\u0006\u0010P\u001a\u00020GH\u0016J\u0018\u0010\\\u001a\u00020\u000f2\u0006\u0010]\u001a\u00020^2\u0006\u0010F\u001a\u00020GH\u0016J\b\u0010_\u001a\u00020AH\u0016J\u0016\u0010`\u001a\u00020A2\u0006\u0010a\u001a\u00020\f2\u0006\u0010b\u001a\u00020\u001fJ\u001f\u0010c\u001a\u00020A2\u0006\u00102\u001a\u00020\u001f2\n\b\u0002\u00105\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010dJ*\u0010e\u001a\u00020A2\b\u0010f\u001a\u0004\u0018\u00010g2\u0006\u0010h\u001a\u00020i2\u0006\u0010j\u001a\u00020i2\u0006\u0010k\u001a\u00020iH\u0016J\u0012\u0010l\u001a\u00020A2\b\u0010f\u001a\u0004\u0018\u00010gH\u0016J\u0012\u0010m\u001a\u00020A2\b\u0010f\u001a\u0004\u0018\u00010gH\u0016J\u0010\u0010n\u001a\u00020G2\u0006\u0010P\u001a\u00020GH\u0002J\u0010\u0010o\u001a\u00020\u000f2\u0006\u0010F\u001a\u00020GH\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0011\"\u0004\b\u0016\u0010\u0013R\u001b\u0010\u0017\u001a\u00020\u00188BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001d\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R$\u0010%\u001a\u00020\f2\u0006\u0010$\u001a\u00020\f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001a\u0010*\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010!\"\u0004\b,\u0010#R$\u0010-\u001a\u00020\f2\u0006\u0010$\u001a\u00020\f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010'\"\u0004\b/\u0010)R\u0010\u00100\u001a\u0004\u0018\u000101X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u00102\u001a\u00020\u001f8FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010!\"\u0004\b4\u0010#R\u001c\u00105\u001a\u00020\f8FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010'\"\u0004\b7\u0010)R(\u00109\u001a\u0004\u0018\u0001082\b\u0010$\u001a\u0004\u0018\u000108@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R\u000e\u0010>\u001a\u00020?X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006q"}, d2={"Lcom/sybotan/android/graphy/SGraphyView;", "Landroid/view/SurfaceView;", "Landroid/view/SurfaceHolder$Callback;", "Landroid/view/View$OnTouchListener;", "Landroid/view/GestureDetector$OnGestureListener;", "Ljava/lang/Runnable;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "afterLength", "", "beforeLength", "canMove", "", "getCanMove", "()Z", "setCanMove", "(Z)V", "canZoom", "getCanZoom", "setCanZoom", "gesture", "Landroid/view/GestureDetector;", "getGesture", "()Landroid/view/GestureDetector;", "gesture$delegate", "Lkotlin/Lazy;", "isDrawing", "maxPos", "Landroid/graphics/PointF;", "getMaxPos", "()Landroid/graphics/PointF;", "setMaxPos", "(Landroid/graphics/PointF;)V", "value", "maxScale", "getMaxScale", "()F", "setMaxScale", "(F)V", "minPos", "getMinPos", "setMinPos", "minScale", "getMinScale", "setMinScale", "paintThread", "Ljava/lang/Thread;", "pos", "getPos", "setPos", "scale", "getScale", "setScale", "Lcom/sybotan/android/graphy/SGraphyScene;", "scene", "getScene", "()Lcom/sybotan/android/graphy/SGraphyScene;", "setScene", "(Lcom/sybotan/android/graphy/SGraphyScene;)V", "touchState", "Lcom/sybotan/android/graphy/enums/SGraphyViewTouchState;", "drawScene", "", "canvas", "Landroid/graphics/Canvas;", "fitSceneToView", "getDistance", "event", "Landroid/view/MotionEvent;", "getMiddlePoint", "initView", "mapFromScene", "point", "x", "y", "mapToScene", "onDown", "e", "onFling", "e1", "e2", "velocityX", "velocityY", "onLongPress", "onScroll", "distanceX", "distanceY", "onShowPress", "onSingleTapUp", "onTouch", "v", "Landroid/view/View;", "run", "scaleByPoint", "zoom", "midPoint", "setCenterPoint", "(Landroid/graphics/PointF;Ljava/lang/Float;)V", "surfaceChanged", "holder", "Landroid/view/SurfaceHolder;", "format", "", "width", "height", "surfaceCreated", "surfaceDestroyed", "toSceneMotionEvent", "viewZoom", "Companion", "sybotan-android-graphy_release"})
public class SGraphyView
extends SurfaceView
implements SurfaceHolder.Callback,
View.OnTouchListener,
GestureDetector.OnGestureListener,
Runnable {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @Nullable
    private SGraphyScene scene;
    private boolean canZoom;
    private float scale;
    private float minScale;
    private float maxScale;
    private boolean canMove;
    @NotNull
    private PointF pos;
    @NotNull
    private PointF minPos;
    @NotNull
    private PointF maxPos;
    private SGraphyViewTouchState touchState;
    private boolean isDrawing;
    private final Lazy gesture$delegate;
    private float beforeLength;
    private float afterLength;
    private Thread paintThread;
    private static final String TAG;
    public static final Companion Companion;
    private HashMap _$_findViewCache;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(SGraphyView.class), "gesture", "getGesture()Landroid/view/GestureDetector;"))};
        Companion = new Companion(null);
        TAG = SGraphyView.class.getName();
    }

    @Nullable
    public final SGraphyScene getScene() {
        return this.scene;
    }

    public final void setScene(@Nullable SGraphyScene value) {
        if (Intrinsics.areEqual((Object)this.scene, (Object)value)) {
            return;
        }
        SGraphyScene sGraphyScene = this.scene;
        if (sGraphyScene != null) {
            sGraphyScene.setView(null);
        }
        SGraphyScene sGraphyScene2 = value;
        if (sGraphyScene2 != null) {
            sGraphyScene2.setView(this);
        }
        this.scene = value;
    }

    public final boolean getCanZoom() {
        return this.canZoom;
    }

    public final void setCanZoom(boolean bl) {
        this.canZoom = bl;
    }

    public final float getScale() {
        float f = this.scale;
        float f2 = this.maxScale;
        boolean bl = false;
        f = Math.min(f, f2);
        f2 = this.minScale;
        bl = false;
        return Math.max(f, f2);
    }

    public final void setScale(float f) {
        this.scale = f;
    }

    public final float getMinScale() {
        return this.minScale;
    }

    public final void setMinScale(float value) {
        float f;
        float f2 = this.maxScale;
        SGraphyView sGraphyView = this;
        boolean bl = false;
        sGraphyView.minScale = f = Math.min(value, f2);
    }

    public final float getMaxScale() {
        return this.maxScale;
    }

    public final void setMaxScale(float value) {
        float f;
        float f2 = this.minScale;
        SGraphyView sGraphyView = this;
        boolean bl = false;
        sGraphyView.maxScale = f = Math.max(value, f2);
    }

    public final boolean getCanMove() {
        return this.canMove;
    }

    public final void setCanMove(boolean bl) {
        this.canMove = bl;
    }

    @NotNull
    public final PointF getPos() {
        float f;
        float f2 = this.pos.x;
        float f3 = this.minPos.x;
        PointF pointF = this.pos;
        boolean bl = false;
        f2 = f = Math.max(f2, f3);
        f3 = this.maxPos.x;
        bl = false;
        pointF.x = f = Math.min(f2, f3);
        f2 = this.pos.y;
        f3 = this.minPos.y;
        pointF = this.pos;
        bl = false;
        f2 = f = Math.max(f2, f3);
        f3 = this.maxPos.y;
        bl = false;
        pointF.y = f = Math.min(f2, f3);
        return this.pos;
    }

    public final void setPos(@NotNull PointF pointF) {
        Intrinsics.checkParameterIsNotNull((Object)pointF, (String)"<set-?>");
        this.pos = pointF;
    }

    @NotNull
    public final PointF getMinPos() {
        return this.minPos;
    }

    public final void setMinPos(@NotNull PointF pointF) {
        Intrinsics.checkParameterIsNotNull((Object)pointF, (String)"<set-?>");
        this.minPos = pointF;
    }

    @NotNull
    public final PointF getMaxPos() {
        return this.maxPos;
    }

    public final void setMaxPos(@NotNull PointF pointF) {
        Intrinsics.checkParameterIsNotNull((Object)pointF, (String)"<set-?>");
        this.maxPos = pointF;
    }

    private final GestureDetector getGesture() {
        Lazy lazy = this.gesture$delegate;
        SGraphyView sGraphyView = this;
        KProperty kProperty = $$delegatedProperties[0];
        boolean bl = false;
        return (GestureDetector)lazy.getValue();
    }

    public final void fitSceneToView() {
        if (this.scene == null) {
            return;
        }
        float width = this.getWidth();
        float height = this.getHeight();
        SGraphyScene sGraphyScene = this.scene;
        if (sGraphyScene == null) {
            Intrinsics.throwNpe();
        }
        RectF rect = sGraphyScene.worldRect();
        this.setCenterPoint(new PointF((rect.left + rect.right) / 2.0f, (rect.top + rect.bottom) / 2.0f), Float.valueOf(Math.min(width / rect.width() * 0.8f, height / rect.height() * 0.8f)));
    }

    public final void setCenterPoint(@NotNull PointF pos, @Nullable Float scale) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        if (scale != null) {
            this.scale = scale.floatValue();
        }
        this.pos = new PointF(-pos.x * this.getScale() + (float)this.getWidth() / 2.0f, -pos.y * this.getScale() + (float)this.getHeight() / 2.0f);
    }

    public static /* synthetic */ void setCenterPoint$default(SGraphyView sGraphyView, PointF pointF, Float f, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setCenterPoint");
        }
        if ((n & 2) != 0) {
            f = null;
        }
        sGraphyView.setCenterPoint(pointF, f);
    }

    public void surfaceCreated(@Nullable SurfaceHolder holder) {
        Log.d((String)TAG, (String)"surfaceCreated");
        this.isDrawing = true;
        Thread thread = this.paintThread = new Thread(this);
        if (thread == null) {
            Intrinsics.throwNpe();
        }
        thread.start();
    }

    public void surfaceChanged(@Nullable SurfaceHolder holder, int format, int width, int height) {
        Log.d((String)TAG, (String)("surfaceChanged\uff1awidth=" + width + ", height=" + height));
    }

    public void surfaceDestroyed(@Nullable SurfaceHolder holder) {
        Log.d((String)TAG, (String)"surfaceDestroyed");
        Thread thread = this.paintThread;
        if (thread == null) {
            Intrinsics.throwNpe();
        }
        thread.interrupt();
        this.paintThread = null;
    }

    @NotNull
    public final PointF mapFromScene(float x, float y) {
        return new PointF(x * this.getScale() + this.getPos().x, y * this.getScale() + this.getPos().y);
    }

    @NotNull
    public final PointF mapFromScene(@NotNull PointF point) {
        Intrinsics.checkParameterIsNotNull((Object)point, (String)"point");
        return this.mapFromScene(point.x, point.y);
    }

    @NotNull
    public final PointF mapToScene(float x, float y) {
        return new PointF((x - this.getPos().x) / this.getScale(), (y - this.getPos().y) / this.getScale());
    }

    @NotNull
    public final PointF mapToScene(@NotNull PointF point) {
        Intrinsics.checkParameterIsNotNull((Object)point, (String)"point");
        return this.mapToScene(point.x, point.y);
    }

    public boolean onTouch(@NotNull View v, @NotNull MotionEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)v, (String)"v");
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        try {
            boolean bl;
            switch (event.getAction() & 0xFF) {
                case 5: {
                    if (this.canZoom) {
                        this.touchState = SGraphyViewTouchState.ZoomState;
                        this.beforeLength = this.getDistance(event);
                    }
                    bl = true;
                    break;
                }
                case 6: {
                    this.touchState = SGraphyViewTouchState.NoneState;
                    bl = true;
                    break;
                }
                case 2: {
                    if (SGraphyViewTouchState.ZoomState == this.touchState && this.canZoom) {
                        this.viewZoom(event);
                        bl = true;
                        break;
                    }
                    bl = this.getGesture().onTouchEvent(event);
                    break;
                }
                default: {
                    bl = this.getGesture().onTouchEvent(event);
                }
            }
            return bl;
        }
        catch (Exception e) {
            return true;
        }
    }

    public void onShowPress(@NotNull MotionEvent e) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            SGraphyScene sGraphyScene = this.scene;
            if (sGraphyScene == null) break block0;
            sGraphyScene.onShowPress(this.toSceneMotionEvent(e));
        }
    }

    public boolean onDown(@NotNull MotionEvent e) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            SGraphyScene sGraphyScene = this.scene;
            if (sGraphyScene == null) break block0;
            sGraphyScene.onDown(this.toSceneMotionEvent(e));
        }
        return true;
    }

    public boolean onSingleTapUp(@NotNull MotionEvent e) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            SGraphyScene sGraphyScene = this.scene;
            if (sGraphyScene == null) break block0;
            sGraphyScene.onSingleTapUp(this.toSceneMotionEvent(e));
        }
        return true;
    }

    public void onLongPress(@NotNull MotionEvent e) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            SGraphyScene sGraphyScene = this.scene;
            if (sGraphyScene == null) break block0;
            sGraphyScene.onLongPress(this.toSceneMotionEvent(e));
        }
    }

    public boolean onScroll(@NotNull MotionEvent e1, @NotNull MotionEvent e2, float distanceX, float distanceY) {
        Intrinsics.checkParameterIsNotNull((Object)e1, (String)"e1");
        Intrinsics.checkParameterIsNotNull((Object)e2, (String)"e2");
        if (this.scene == null) {
            return true;
        }
        SGraphyScene sGraphyScene = this.scene;
        if (sGraphyScene == null) {
            Intrinsics.throwNpe();
        }
        if (sGraphyScene.onScroll(this.toSceneMotionEvent(e1), this.toSceneMotionEvent(e2), distanceX / this.getScale(), distanceY / this.getScale())) {
            return true;
        }
        if (this.canMove) {
            this.getPos().x -= distanceX;
            this.getPos().y -= distanceY;
            EventBus.getDefault().post((Object)new SGraphyViewMoveEvent(this, this.getPos().x, this.getPos().y));
        }
        return true;
    }

    public boolean onFling(@NotNull MotionEvent e1, @NotNull MotionEvent e2, float velocityX, float velocityY) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)e1, (String)"e1");
            Intrinsics.checkParameterIsNotNull((Object)e2, (String)"e2");
            SGraphyScene sGraphyScene = this.scene;
            if (sGraphyScene == null) break block0;
            sGraphyScene.onFling(this.toSceneMotionEvent(e1), this.toSceneMotionEvent(e2), velocityX / this.getScale(), velocityY / this.getScale());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.paintThread != null) {
            Thread thread = this.paintThread;
            if (thread == null) {
                Intrinsics.throwNpe();
            }
            if (thread.isInterrupted()) break;
            Canvas canvas = null;
            try {
                SurfaceHolder surfaceHolder;
                Thread.sleep(100L);
                canvas = this.getHolder().lockCanvas();
                if (canvas == null) continue;
                Intrinsics.checkExpressionValueIsNotNull((Object)this.getHolder(), (String)"holder");
                boolean bl = false;
                boolean bl2 = false;
                synchronized (surfaceHolder) {
                    boolean bl3 = false;
                    this.drawScene(canvas);
                    Unit unit = Unit.INSTANCE;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (canvas == null) continue;
                this.getHolder().unlockCanvasAndPost(canvas);
            }
        }
    }

    public void drawScene(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        canvas.save();
        SGraphyScene sGraphyScene = this.scene;
        if (sGraphyScene != null) {
            sGraphyScene.drawBackground(canvas, new RectF());
        }
        canvas.restore();
        canvas.save();
        canvas.translate(this.getPos().x, this.getPos().y);
        canvas.scale(this.getScale(), this.getScale());
        SGraphyScene sGraphyScene2 = this.scene;
        if (sGraphyScene2 != null) {
            sGraphyScene2.drawScene(canvas, new RectF());
        }
        canvas.restore();
        canvas.save();
        SGraphyScene sGraphyScene3 = this.scene;
        if (sGraphyScene3 != null) {
            sGraphyScene3.drawForeground(canvas, new RectF());
        }
        canvas.restore();
    }

    public final void scaleByPoint(float zoom, @NotNull PointF midPoint) {
        Intrinsics.checkParameterIsNotNull((Object)midPoint, (String)"midPoint");
        float z = zoom;
        if (this.getScale() * zoom >= this.maxScale) {
            z = this.maxScale / this.getScale();
            this.scale = this.maxScale;
        } else if (this.getScale() * zoom <= this.minScale) {
            z = this.minScale / this.getScale();
            this.scale = this.minScale;
        } else {
            this.scale = this.getScale() * zoom;
        }
        this.getPos().x = midPoint.x - (midPoint.x - this.getPos().x) * z;
        this.getPos().y = midPoint.y - (midPoint.y - this.getPos().y) * z;
        EventBus.getDefault().post((Object)new SGraphyViewZoomEvent(this, this.getScale()));
        EventBus.getDefault().post((Object)new SGraphyViewMoveEvent(this, this.getPos().x, this.getPos().y));
    }

    private final void initView() {
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
        this.getHolder().setFormat(-2);
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        this.setOnTouchListener(this);
    }

    private final boolean viewZoom(MotionEvent event) {
        if (this.touchState == SGraphyViewTouchState.ZoomState) {
            this.afterLength = this.getDistance(event);
            float gapLenght = this.afterLength - this.beforeLength;
            if (Math.abs(gapLenght) > 5.0f && this.beforeLength != 0.0f) {
                float tempScale = this.afterLength / this.beforeLength;
                PointF p = this.getMiddlePoint(event);
                this.scaleByPoint(tempScale, p);
                this.beforeLength = this.afterLength;
            }
        }
        return true;
    }

    private final float getDistance(MotionEvent event) {
        double x = event.getX(0) - event.getX(1);
        double y = event.getY(0) - event.getY(1);
        return (float)Math.sqrt(x * x + y * y);
    }

    private final PointF getMiddlePoint(MotionEvent event) {
        return new PointF((event.getX(1) + event.getX(0)) / 2.0f, (event.getY(1) + event.getY(0)) / 2.0f);
    }

    private final MotionEvent toSceneMotionEvent(MotionEvent e) {
        MotionEvent se = MotionEvent.obtain((MotionEvent)e);
        se.setLocation((e.getX() - this.getPos().x) / this.getScale(), (e.getY() - this.getPos().y) / this.getScale());
        MotionEvent motionEvent = se;
        Intrinsics.checkExpressionValueIsNotNull((Object)motionEvent, (String)"se");
        return motionEvent;
    }

    public SGraphyView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs);
        this.canZoom = true;
        this.scale = 1.0f;
        this.minScale = 0.1f;
        this.maxScale = 10.0f;
        this.canMove = true;
        this.pos = new PointF(0.0f, 0.0f);
        this.minPos = new PointF(FloatCompanionObject.INSTANCE.getMIN_VALUE(), FloatCompanionObject.INSTANCE.getMIN_VALUE());
        this.maxPos = new PointF(FloatCompanionObject.INSTANCE.getMAX_VALUE(), FloatCompanionObject.INSTANCE.getMAX_VALUE());
        this.touchState = SGraphyViewTouchState.NoneState;
        this.gesture$delegate = LazyKt.lazy((Function0)((Function0)new Function0<GestureDetector>(this){
            final /* synthetic */ SGraphyView this$0;

            @NotNull
            public final GestureDetector invoke() {
                return new GestureDetector((GestureDetector.OnGestureListener)this.this$0);
            }
            {
                this.this$0 = sGraphyView;
                super(0);
            }
        }));
        Log.d((String)TAG, (String)"init");
        this.initView();
    }

    public /* synthetic */ SGraphyView(Context context, AttributeSet attributeSet, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            attributeSet = null;
        }
        this(context, attributeSet);
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/sybotan/android/graphy/SGraphyView$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "sybotan-android-graphy_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

