/*
 * Decompiled with CFR 0.152.
 */
package com.sybotan.android.views;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.RectF;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.media.Image;
import android.media.ImageReader;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Size;
import android.util.SparseIntArray;
import android.view.OrientationEventListener;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import com.sybotan.android.base.comparators.SSizesByAreaComparator;
import com.sybotan.android.views.SAutoFitTextureView;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.anko.DimensionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000f\b\u0016\u0018\u0000 [2\u00020\u0001:\u0006XYZ[\\]B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006JC\u0010@\u001a\u0002032\f\u0010A\u001a\b\u0012\u0004\u0012\u0002030\u00182\u0006\u0010B\u001a\u00020\u001f2\u0006\u0010C\u001a\u00020\u001f2\u0006\u0010D\u001a\u00020\u001f2\u0006\u0010E\u001a\u00020\u001f2\u0006\u0010F\u001a\u000203H\u0002\u00a2\u0006\u0002\u0010GJ\u0006\u0010H\u001a\u00020IJ\u0018\u0010J\u001a\u00020I2\u0006\u0010K\u001a\u00020\u001f2\u0006\u0010L\u001a\u00020\u001fH\u0002J\b\u0010M\u001a\u00020IH\u0002J\u0006\u0010N\u001a\u00020OJ\b\u0010P\u001a\u00020IH\u0002J&\u0010Q\u001a\u00020O2\b\b\u0002\u0010R\u001a\u00020\u001f2\b\b\u0002\u0010S\u001a\u00020\u001f2\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0007J \u0010T\u001a\u00020I2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010R\u001a\u00020\u001f2\u0006\u0010S\u001a\u00020\u001fH\u0002J\b\u0010U\u001a\u00020IH\u0002J\b\u0010V\u001a\u00020IH\u0002J\b\u0010W\u001a\u00020IH\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001b\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0018\u00a2\u0006\n\n\u0002\u0010\u001b\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\"\u001a\u00060#R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010$\u001a\u00060%R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010&\u001a\u0004\u0018\u00010'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010(\u001a\u00020)\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0011\u0010,\u001a\u00020-\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0010\u00100\u001a\u0004\u0018\u000101X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00102\u001a\u000203X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107R$\u00109\u001a\u00020\u001f2\u0006\u00108\u001a\u00020\u001f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R\u0012\u0010>\u001a\u00060?R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006^"}, d2={"Lcom/sybotan/android/views/SCameraView;", "Lcom/sybotan/android/views/SAutoFitTextureView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "cameraCaptureSession", "Landroid/hardware/camera2/CameraCaptureSession;", "cameraDevice", "Landroid/hardware/camera2/CameraDevice;", "getCameraDevice", "()Landroid/hardware/camera2/CameraDevice;", "setCameraDevice", "(Landroid/hardware/camera2/CameraDevice;)V", "cameraHandler", "Landroid/os/Handler;", "cameraId", "", "getCameraId", "()Ljava/lang/String;", "setCameraId", "(Ljava/lang/String;)V", "cameraIdList", "", "getCameraIdList", "()[Ljava/lang/String;", "[Ljava/lang/String;", "cameraOpenCloseLock", "Ljava/util/concurrent/Semaphore;", "cameraSensorOrientation", "", "cameraThread", "Landroid/os/HandlerThread;", "captureCallback", "Lcom/sybotan/android/views/SCameraView$CaptureCallback;", "imageAvailableListener", "Lcom/sybotan/android/views/SCameraView$ImageAvailableListener;", "imageReader", "Landroid/media/ImageReader;", "manager", "Landroid/hardware/camera2/CameraManager;", "getManager", "()Landroid/hardware/camera2/CameraManager;", "orientationEventListener", "Landroid/view/OrientationEventListener;", "getOrientationEventListener", "()Landroid/view/OrientationEventListener;", "previewRequestBuilder", "Landroid/hardware/camera2/CaptureRequest$Builder;", "previewSize", "Landroid/util/Size;", "getPreviewSize", "()Landroid/util/Size;", "setPreviewSize", "(Landroid/util/Size;)V", "value", "rotation", "getRotation", "()I", "setRotation", "(I)V", "stateCallback", "Lcom/sybotan/android/views/SCameraView$CameraStateCallback;", "chooseOptimalSize", "choices", "textureViewWidth", "textureViewHeight", "maxWidth", "maxHeight", "aspectRatio", "([Landroid/util/Size;IIIILandroid/util/Size;)Landroid/util/Size;", "closeCamera", "", "configureTransform", "viewWidth", "viewHeight", "createCameraPreviewSession", "isOpen", "", "lockFocus", "openCamera", "width", "height", "setCameraOutputs", "startCameraThread", "stopCameraThread", "unlockFocus", "CameraStateCallback", "CaptureCallback", "CaptureSessionStateCallback", "Companion", "ImageAvailableListener", "TextureListener", "sybotan-android-views_debug"})
public class SCameraView
extends SAutoFitTextureView {
    @NotNull
    private final CameraManager manager;
    @NotNull
    private final String[] cameraIdList;
    @NotNull
    private String cameraId;
    @Nullable
    private CameraDevice cameraDevice;
    @NotNull
    private Size previewSize;
    private int cameraSensorOrientation;
    private CaptureRequest.Builder previewRequestBuilder;
    private CameraCaptureSession cameraCaptureSession;
    private HandlerThread cameraThread;
    private Handler cameraHandler;
    private final Semaphore cameraOpenCloseLock;
    private final CameraStateCallback stateCallback;
    private final CaptureCallback captureCallback;
    private ImageReader imageReader;
    private ImageAvailableListener imageAvailableListener;
    private int rotation;
    @NotNull
    private final OrientationEventListener orientationEventListener;
    private static final String TAG;
    private static final SparseIntArray ORIENTATIONS;
    private static final int MAX_PREVIEW_WIDTH = 1920;
    private static final int MAX_PREVIEW_HEIGHT = 1080;
    public static final Companion Companion;
    private HashMap _$_findViewCache;

    @NotNull
    public final CameraManager getManager() {
        return this.manager;
    }

    @NotNull
    public final String[] getCameraIdList() {
        return this.cameraIdList;
    }

    @NotNull
    public final String getCameraId() {
        return this.cameraId;
    }

    public final void setCameraId(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.cameraId = string;
    }

    @Nullable
    public final CameraDevice getCameraDevice() {
        return this.cameraDevice;
    }

    public final void setCameraDevice(@Nullable CameraDevice cameraDevice) {
        this.cameraDevice = cameraDevice;
    }

    @NotNull
    public final Size getPreviewSize() {
        return this.previewSize;
    }

    public final void setPreviewSize(@NotNull Size size) {
        Intrinsics.checkParameterIsNotNull((Object)size, (String)"<set-?>");
        this.previewSize = size;
    }

    public final int getRotation() {
        return this.rotation;
    }

    public final void setRotation(int value) {
        this.rotation = value;
        this.configureTransform(this.getWidth(), this.getHeight());
    }

    @NotNull
    public final OrientationEventListener getOrientationEventListener() {
        return this.orientationEventListener;
    }

    @SuppressLint(value={"MissingPermission"})
    public final boolean openCamera(int width, int height, @NotNull String cameraId) {
        Intrinsics.checkParameterIsNotNull((Object)cameraId, (String)"cameraId");
        if (!this.isAvailable()) {
            this.setSurfaceTextureListener(new TextureListener());
            return true;
        }
        this.setCameraOutputs(cameraId, width, height);
        this.configureTransform(width, height);
        try {
            if (!this.cameraOpenCloseLock.tryAcquire(2500L, TimeUnit.MILLISECONDS)) {
                throw (Throwable)new RuntimeException("Time out waiting to lock cameraDevice opening.");
            }
            Log.d((String)TAG, (String)("openCamera(cameraId=" + cameraId + ')'));
            this.manager.openCamera(cameraId, (CameraDevice.StateCallback)this.stateCallback, this.cameraHandler);
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
            return false;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @SuppressLint(value={"MissingPermission"})
    public static /* synthetic */ boolean openCamera$default(SCameraView sCameraView, int n, int n2, String string, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: openCamera");
        }
        if ((n3 & 1) != 0) {
            n = 1920;
        }
        if ((n3 & 2) != 0) {
            n2 = 1080;
        }
        if ((n3 & 4) != 0) {
            string = "0";
        }
        return sCameraView.openCamera(n, n2, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void closeCamera() {
        try {
            this.cameraOpenCloseLock.acquire();
            if (this.cameraCaptureSession != null) {
                CameraCaptureSession cameraCaptureSession = this.cameraCaptureSession;
                if (cameraCaptureSession == null) {
                    Intrinsics.throwNpe();
                }
                cameraCaptureSession.close();
                this.cameraCaptureSession = null;
            }
            if (this.cameraDevice != null) {
                CameraDevice cameraDevice = this.cameraDevice;
                if (cameraDevice == null) {
                    Intrinsics.throwNpe();
                }
                cameraDevice.close();
                this.cameraDevice = null;
            }
            if (this.imageReader != null) {
                ImageReader imageReader = this.imageReader;
                if (imageReader == null) {
                    Intrinsics.throwNpe();
                }
                imageReader.close();
                this.imageReader = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.cameraOpenCloseLock.release();
        }
    }

    public final synchronized boolean isOpen() {
        return this.cameraDevice != null;
    }

    private final void lockFocus() {
        try {
            CaptureRequest.Builder builder = this.previewRequestBuilder;
            if (builder == null) {
                Intrinsics.throwNpe();
            }
            builder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)1);
            CameraCaptureSession cameraCaptureSession = this.cameraCaptureSession;
            if (cameraCaptureSession == null) {
                Intrinsics.throwNpe();
            }
            CaptureRequest.Builder builder2 = this.previewRequestBuilder;
            if (builder2 == null) {
                Intrinsics.throwNpe();
            }
            cameraCaptureSession.capture(builder2.build(), (CameraCaptureSession.CaptureCallback)this.captureCallback, this.cameraHandler);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final void unlockFocus() {
        try {
            CaptureRequest.Builder builder = this.previewRequestBuilder;
            if (builder == null) {
                Intrinsics.throwNpe();
            }
            builder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)2);
            CameraCaptureSession cameraCaptureSession = this.cameraCaptureSession;
            if (cameraCaptureSession == null) {
                Intrinsics.throwNpe();
            }
            CaptureRequest.Builder builder2 = this.previewRequestBuilder;
            if (builder2 == null) {
                Intrinsics.throwNpe();
            }
            cameraCaptureSession.capture(builder2.build(), (CameraCaptureSession.CaptureCallback)this.captureCallback, this.cameraHandler);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final void startCameraThread() {
        if (this.cameraThread != null) {
            return;
        }
        HandlerThread handlerThread = this.cameraThread = new HandlerThread("CameraBackground");
        if (handlerThread == null) {
            Intrinsics.throwNpe();
        }
        handlerThread.start();
        HandlerThread handlerThread2 = this.cameraThread;
        if (handlerThread2 == null) {
            Intrinsics.throwNpe();
        }
        this.cameraHandler = new Handler(handlerThread2.getLooper());
    }

    private final void stopCameraThread() {
        HandlerThread handlerThread = this.cameraThread;
        if (handlerThread == null) {
            Intrinsics.throwNpe();
        }
        handlerThread.quitSafely();
        try {
            HandlerThread handlerThread2 = this.cameraThread;
            if (handlerThread2 == null) {
                Intrinsics.throwNpe();
            }
            handlerThread2.join();
            this.cameraThread = null;
            this.cameraHandler = null;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private final void setCameraOutputs(String cameraId, int width, int height) {
        Size largest;
        CameraCharacteristics characteristics = this.manager.getCameraCharacteristics(cameraId);
        StreamConfigurationMap map = (StreamConfigurationMap)characteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
        Size[] sizeArray = map.getOutputSizes(35);
        Size size = largest = (Size)Collections.max((Collection)Arrays.asList(Arrays.copyOf(sizeArray, sizeArray.length)), (Comparator)new SSizesByAreaComparator());
        Intrinsics.checkExpressionValueIsNotNull((Object)size, (String)"largest");
        ImageReader imageReader = this.imageReader = ImageReader.newInstance((int)size.getWidth(), (int)largest.getHeight(), (int)35, (int)2);
        if (imageReader == null) {
            Intrinsics.throwNpe();
        }
        imageReader.setOnImageAvailableListener((ImageReader.OnImageAvailableListener)this.imageAvailableListener, this.cameraHandler);
        boolean swappedDimensions = false;
        Integer n = (Integer)characteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
        this.cameraSensorOrientation = n != null ? n : 0;
        switch (this.rotation) {
            case 0: 
            case 2: {
                if (this.cameraSensorOrientation != 90 && this.cameraSensorOrientation != 270) break;
                swappedDimensions = true;
                break;
            }
            case 1: 
            case 3: {
                if (this.cameraSensorOrientation != 0 && this.cameraSensorOrientation != 180) break;
                swappedDimensions = true;
                break;
            }
            default: {
                Log.e((String)TAG, (String)("Display rotation is invalid: " + this.rotation));
            }
        }
        Point displaySize = new Point();
        int rotatedPreviewWidth = width;
        int rotatedPreviewHeight = height;
        int maxPreviewWidth = displaySize.x;
        int maxPreviewHeight = displaySize.y;
        if (swappedDimensions) {
            rotatedPreviewWidth = height;
            rotatedPreviewHeight = width;
            maxPreviewWidth = displaySize.y;
            maxPreviewHeight = displaySize.x;
        }
        if (maxPreviewWidth > 1920) {
            maxPreviewWidth = 1920;
        }
        if (maxPreviewHeight > 1080) {
            maxPreviewHeight = 1080;
        }
        Size[] sizeArray2 = map.getOutputSizes(SurfaceTexture.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)sizeArray2, (String)"map.getOutputSizes(SurfaceTexture::class.java)");
        this.previewSize = this.chooseOptimalSize(sizeArray2, rotatedPreviewWidth, rotatedPreviewHeight, maxPreviewWidth, maxPreviewHeight, largest);
        Resources resources = this.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"resources");
        int orientation = resources.getConfiguration().orientation;
        this.setAspectRatio(orientation == 2 ? new Size(width, height) : new Size(height, width));
    }

    private final Size chooseOptimalSize(Size[] choices, int textureViewWidth, int textureViewHeight, int maxWidth, int maxHeight, Size aspectRatio) {
        Size size;
        ArrayList<Size> bigEnough = new ArrayList<Size>();
        ArrayList<Size> notBigEnough = new ArrayList<Size>();
        int w = aspectRatio.getWidth();
        int h = aspectRatio.getHeight();
        for (Size option : choices) {
            if (option.getWidth() > maxWidth || option.getHeight() > maxHeight || option.getHeight() != option.getWidth() * h / w) continue;
            if (option.getWidth() >= textureViewWidth && option.getHeight() >= textureViewHeight) {
                bigEnough.add(option);
                continue;
            }
            notBigEnough.add(option);
        }
        if (bigEnough.size() > 0) {
            Object t = Collections.min((Collection)bigEnough, (Comparator)new SSizesByAreaComparator());
            Intrinsics.checkExpressionValueIsNotNull(t, (String)"Collections.min(bigEnoug\u2026SSizesByAreaComparator())");
            size = (Size)t;
        } else if (notBigEnough.size() > 0) {
            Object t = Collections.max((Collection)notBigEnough, (Comparator)new SSizesByAreaComparator());
            Intrinsics.checkExpressionValueIsNotNull(t, (String)"Collections.max(notBigEn\u2026SSizesByAreaComparator())");
            size = (Size)t;
        } else {
            size = choices[0];
        }
        return size;
    }

    private final void configureTransform(int viewWidth, int viewHeight) {
        Matrix matrix = new Matrix();
        RectF viewRect = new RectF(0.0f, 0.0f, (float)viewWidth, (float)viewHeight);
        RectF bufferRect = new RectF(0.0f, 0.0f, (float)this.previewSize.getHeight(), (float)this.previewSize.getWidth());
        float centerX = viewRect.centerX();
        float centerY = viewRect.centerY();
        if (1 == this.rotation || 3 == this.rotation) {
            bufferRect.offset(centerX - bufferRect.centerX(), centerY - bufferRect.centerY());
            matrix.setRectToRect(viewRect, bufferRect, Matrix.ScaleToFit.FILL);
            float scale = Math.max((float)viewHeight / (float)this.previewSize.getHeight(), (float)viewWidth / (float)this.previewSize.getWidth());
            matrix.postScale(scale, scale, centerX, centerY);
            matrix.postRotate((float)(90 * (this.rotation - 2)), centerX, centerY);
        } else if (2 == this.rotation) {
            matrix.postRotate(180.0f, centerX, centerY);
        }
        this.setTransform(matrix);
    }

    private final void createCameraPreviewSession() {
        Log.d((String)TAG, (String)"createCameraPreviewSession");
        try {
            Surface surface = new Surface(this.getSurfaceTexture());
            CameraDevice cameraDevice = this.cameraDevice;
            if (cameraDevice == null) {
                Intrinsics.throwNpe();
            }
            CaptureRequest.Builder builder = this.previewRequestBuilder = cameraDevice.createCaptureRequest(1);
            if (builder == null) {
                Intrinsics.throwNpe();
            }
            builder.addTarget(surface);
            CameraDevice cameraDevice2 = this.cameraDevice;
            if (cameraDevice2 == null) {
                Intrinsics.throwNpe();
            }
            Object[] objectArray = new Surface[2];
            objectArray[0] = surface;
            ImageReader imageReader = this.imageReader;
            if (imageReader == null) {
                Intrinsics.throwNpe();
            }
            objectArray[1] = imageReader.getSurface();
            cameraDevice2.createCaptureSession((List)CollectionsKt.arrayListOf((Object[])objectArray), (CameraCaptureSession.StateCallback)new CaptureSessionStateCallback(), null);
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
        }
    }

    public SCameraView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs);
        Object object = context.getSystemService("camera");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.hardware.camera2.CameraManager");
        }
        this.manager = (CameraManager)object;
        String[] stringArray = this.manager.getCameraIdList();
        Intrinsics.checkExpressionValueIsNotNull((Object)stringArray, (String)"manager.cameraIdList");
        this.cameraIdList = stringArray;
        this.cameraId = "0";
        this.previewSize = new Size(1920, 1080);
        this.cameraOpenCloseLock = new Semaphore(1);
        this.stateCallback = new CameraStateCallback();
        this.captureCallback = new CaptureCallback();
        this.imageAvailableListener = new ImageAvailableListener();
        this.orientationEventListener = new OrientationEventListener(this, context, context){
            final /* synthetic */ SCameraView this$0;
            final /* synthetic */ Context $context;

            public void onOrientationChanged(int orientation) {
                int n;
                int rot = (orientation + 360) % 360;
                Log.v((String)SCameraView.access$getTAG$cp(), (String)("orientation = " + rot));
                this.this$0.setRotation(rot <= 45 || rot > 315 ? 0 : (46 <= (n = rot) && 135 >= n ? 3 : (136 <= (n = rot) && 225 >= n ? 2 : 1)));
            }
            {
                this.this$0 = $outer;
                this.$context = $captured_local_variable$1;
                super($super_call_param$2);
            }
        };
        ORIENTATIONS.append(0, 90);
        ORIENTATIONS.append(1, 0);
        ORIENTATIONS.append(2, 270);
        ORIENTATIONS.append(3, 180);
        this.startCameraThread();
    }

    public /* synthetic */ SCameraView(Context context, AttributeSet attributeSet, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            attributeSet = null;
        }
        this(context, attributeSet);
    }

    static {
        Companion = new Companion(null);
        TAG = SCameraView.class.getName();
        ORIENTATIONS = new SparseIntArray();
    }

    public static final /* synthetic */ void access$setPreviewRequestBuilder$p(SCameraView $this, CaptureRequest.Builder builder) {
        $this.previewRequestBuilder = builder;
    }

    public static final /* synthetic */ void access$setCameraHandler$p(SCameraView $this, Handler handler) {
        $this.cameraHandler = handler;
    }

    @Override
    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    @Override
    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\"\u0010\f\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\u0012\u0010\r\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\u000e"}, d2={"Lcom/sybotan/android/views/SCameraView$TextureListener;", "Landroid/view/TextureView$SurfaceTextureListener;", "(Lcom/sybotan/android/views/SCameraView;)V", "onSurfaceTextureAvailable", "", "surface", "Landroid/graphics/SurfaceTexture;", "width", "", "height", "onSurfaceTextureDestroyed", "", "onSurfaceTextureSizeChanged", "onSurfaceTextureUpdated", "sybotan-android-views_debug"})
    public final class TextureListener
    implements TextureView.SurfaceTextureListener {
        public void onSurfaceTextureAvailable(@Nullable SurfaceTexture surface, int width, int height) {
            SCameraView $receiver$iv;
            Log.d((String)"SCAMERA", (String)("size ===== " + width + ", " + height));
            SCameraView sCameraView = SCameraView.this;
            SCameraView sCameraView2 = SCameraView.this;
            Context context = $receiver$iv.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
            int n = DimensionsKt.dip((Context)context, (int)width);
            $receiver$iv = SCameraView.this;
            Context context2 = $receiver$iv.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context");
            int n2 = DimensionsKt.dip((Context)context2, (int)height);
            sCameraView2.openCamera(n, n2, SCameraView.this.getCameraId());
        }

        public void onSurfaceTextureSizeChanged(@Nullable SurfaceTexture surface, int width, int height) {
            SCameraView.this.configureTransform(width, height);
        }

        public void onSurfaceTextureUpdated(@Nullable SurfaceTexture surface) {
        }

        public boolean onSurfaceTextureDestroyed(@Nullable SurfaceTexture surface) {
            return true;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/sybotan/android/views/SCameraView$CameraStateCallback;", "Landroid/hardware/camera2/CameraDevice$StateCallback;", "(Lcom/sybotan/android/views/SCameraView;)V", "onDisconnected", "", "camera", "Landroid/hardware/camera2/CameraDevice;", "onError", "error", "", "onOpened", "sybotan-android-views_debug"})
    public final class CameraStateCallback
    extends CameraDevice.StateCallback {
        public void onOpened(@NotNull CameraDevice camera) {
            Intrinsics.checkParameterIsNotNull((Object)camera, (String)"camera");
            SCameraView.this.cameraOpenCloseLock.release();
            SCameraView.this.setCameraDevice(camera);
            SCameraView.this.createCameraPreviewSession();
        }

        public void onDisconnected(@NotNull CameraDevice camera) {
            Intrinsics.checkParameterIsNotNull((Object)camera, (String)"camera");
            SCameraView.this.cameraOpenCloseLock.release();
            if (SCameraView.this.getCameraDevice() != null) {
                CameraDevice cameraDevice = SCameraView.this.getCameraDevice();
                if (cameraDevice == null) {
                    Intrinsics.throwNpe();
                }
                cameraDevice.close();
                SCameraView.this.setCameraDevice(null);
            }
        }

        public void onError(@NotNull CameraDevice camera, int error) {
            Intrinsics.checkParameterIsNotNull((Object)camera, (String)"camera");
            this.onDisconnected(camera);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\u0012\u0010\u0007\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/sybotan/android/views/SCameraView$CaptureSessionStateCallback;", "Landroid/hardware/camera2/CameraCaptureSession$StateCallback;", "(Lcom/sybotan/android/views/SCameraView;)V", "onConfigureFailed", "", "session", "Landroid/hardware/camera2/CameraCaptureSession;", "onConfigured", "sybotan-android-views_debug"})
    public final class CaptureSessionStateCallback
    extends CameraCaptureSession.StateCallback {
        public void onConfigured(@Nullable CameraCaptureSession session) {
            if (SCameraView.this.getCameraDevice() == null) {
                return;
            }
            SCameraView.this.cameraCaptureSession = session;
            try {
                CaptureRequest.Builder builder = SCameraView.this.previewRequestBuilder;
                if (builder == null) {
                    Intrinsics.throwNpe();
                }
                builder.set(CaptureRequest.CONTROL_AF_MODE, (Object)4);
                CaptureRequest.Builder builder2 = SCameraView.this.previewRequestBuilder;
                if (builder2 == null) {
                    Intrinsics.throwNpe();
                }
                CaptureRequest previewRequest = builder2.build();
                CameraCaptureSession cameraCaptureSession = SCameraView.this.cameraCaptureSession;
                if (cameraCaptureSession == null) {
                    Intrinsics.throwNpe();
                }
                cameraCaptureSession.setRepeatingRequest(previewRequest, (CameraCaptureSession.CaptureCallback)SCameraView.this.captureCallback, SCameraView.this.cameraHandler);
            }
            catch (CameraAccessException e) {
                e.printStackTrace();
            }
        }

        public void onConfigureFailed(@Nullable CameraCaptureSession session) {
            Log.e((String)TAG, (String)"onConfigureFailed");
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/sybotan/android/views/SCameraView$CaptureCallback;", "Landroid/hardware/camera2/CameraCaptureSession$CaptureCallback;", "(Lcom/sybotan/android/views/SCameraView;)V", "onCaptureCompleted", "", "session", "Landroid/hardware/camera2/CameraCaptureSession;", "request", "Landroid/hardware/camera2/CaptureRequest;", "result", "Landroid/hardware/camera2/TotalCaptureResult;", "onCaptureProgressed", "partialResult", "Landroid/hardware/camera2/CaptureResult;", "sybotan-android-views_debug"})
    public final class CaptureCallback
    extends CameraCaptureSession.CaptureCallback {
        public void onCaptureProgressed(@NotNull CameraCaptureSession session, @NotNull CaptureRequest request, @NotNull CaptureResult partialResult) {
            Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
            Intrinsics.checkParameterIsNotNull((Object)partialResult, (String)"partialResult");
        }

        public void onCaptureCompleted(@NotNull CameraCaptureSession session, @NotNull CaptureRequest request, @NotNull TotalCaptureResult result) {
            Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
            Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/sybotan/android/views/SCameraView$ImageAvailableListener;", "Landroid/media/ImageReader$OnImageAvailableListener;", "(Lcom/sybotan/android/views/SCameraView;)V", "onImageAvailable", "", "reader", "Landroid/media/ImageReader;", "sybotan-android-views_debug"})
    public final class ImageAvailableListener
    implements ImageReader.OnImageAvailableListener {
        public void onImageAvailable(@NotNull ImageReader reader) {
            Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
            Image image = reader.acquireNextImage();
            if (image != null) {
                Image.Plane plane = image.getPlanes()[0];
                Intrinsics.checkExpressionValueIsNotNull((Object)plane, (String)"image.planes[0]");
                ByteBuffer buffer = plane.getBuffer();
                byte[] bytes = new byte[buffer.remaining()];
                buffer.get(bytes);
                image.close();
            }
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/sybotan/android/views/SCameraView$Companion;", "", "()V", "MAX_PREVIEW_HEIGHT", "", "MAX_PREVIEW_WIDTH", "ORIENTATIONS", "Landroid/util/SparseIntArray;", "TAG", "", "kotlin.jvm.PlatformType", "sybotan-android-views_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

