/*
 * Decompiled with CFR 0.152.
 */
package com.sagacloud.util.compute_engine.core;

import com.alibaba.fastjson.JSONObject;
import com.sagacloud.extend.dao_data.ImplDao_fjd_statinst;
import com.sagacloud.parser.simulator.String2Grammar;
import com.sagacloud.util.compute_engine.core.CoreComputeUtilUtil;
import com.sagacloud.util.compute_engine.core.CoreComputeUtil_other;
import com.sagacloud.util.compute_engine.core.CoreInput;
import com.sagacloud.util.compute_engine.core.CoreInstance;
import com.sagacloud.util.compute_engine.core.CoreOutput;
import com.sagacloud.util.compute_engine.core.CustomFunctionManager;
import com.sagacloud.util.compute_engine.core.Dao_dataManager;
import com.sagacloud.util.compute_engine.core.Dao_data_maxManager;
import com.sagacloud.util.compute_engine.core.DataCache;
import com.sagacloud.util.compute_engine.core.GrammarCompare;
import com.sagacloud.util.compute_engine.core.GrammarTreeNode;
import com.sagacloud.util.compute_engine.core.IDao_log;
import com.sagacloud.util.compute_engine.util.Constant;
import com.sagacloud.util.compute_engine.util.ConstantCE;
import com.sagacloud.util.compute_engine.util.DateUtil;
import com.sagacloud.util.compute_engine.util.DoubleTimeObject;
import com.sagacloud.util.compute_engine.util.DoubleTimeObject_max;
import com.sagacloud.util.compute_engine.util.DoubleTimeObject_statinst;
import com.sagacloud.util.compute_engine.util.InsertUtil;
import com.sagacloud.util.compute_engine.util.Parser_time_period;
import com.sagacloud.util.compute_engine.util.StepSpan;
import com.sagacloud.util.compute_engine.util.TimeSpan;
import com.sagacloud.util.math.MathUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.zillion.util.log.LogUtil;

public class CoreComputeUtil {
    static List<Date> splitDateList = new ArrayList<Date>();

    public static Map<String, List<TimeSpan>> ComputeByPart(String object_sign, String instance_name, List<CoreInput> inputList, List<CoreOutput> outputList, long compute_round, Map<String, List<TimeSpan>> inputTimeSpanMap, Map<String, List<TimeSpan>> outputdetailListMap, IDao_log dao_log) throws Exception {
        SimpleDateFormat sdf_ = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (int index_split = 0; index_split < splitDateList.size() - 1; ++index_split) {
            Date date_from = splitDateList.get(index_split);
            Date date_to = splitDateList.get(index_split + 1);
            HashMap<String, List<TimeSpan>> inputTimeSpanMapInner = new HashMap<String, List<TimeSpan>>();
            for (CoreInput input : inputList) {
                if (!inputTimeSpanMap.containsKey(input.input_sign)) continue;
                List<TimeSpan> timeSpanList = DateUtil.Instance().Clone(inputTimeSpanMap.get(input.input_sign));
                DateUtil.Instance().Limit(timeSpanList, date_from, DateUtil.Instance().GetDate_offset(date_to, input.time_period, -1));
                if (timeSpanList.size() <= 0) continue;
                inputTimeSpanMapInner.put(input.input_sign, timeSpanList);
            }
            if (inputTimeSpanMapInner.size() <= 0) continue;
            Constant.info("**************************************************************** ComputeByPartOnce " + object_sign + " " + instance_name + "\t" + sdf_.format(date_from) + "\t" + sdf_.format(date_to) + "begin");
            CoreComputeUtil.ComputeOnce(object_sign, instance_name, inputList, outputList, compute_round, inputTimeSpanMapInner, outputdetailListMap, dao_log, false);
            Constant.info("**************************************************************** ComputeByPartOnce " + object_sign + " " + instance_name + "\t" + sdf_.format(date_from) + "\t" + sdf_.format(date_to) + "end");
        }
        Map<String, List<TimeSpan>> result = CoreComputeUtil.ComputeByPartAfter(object_sign, instance_name, inputList, outputList, compute_round, inputTimeSpanMap, outputdetailListMap, dao_log);
        return result;
    }

    public static Map<String, List<TimeSpan>> ComputeOnce(String object_sign, String instance_name, List<CoreInput> inputList, List<CoreOutput> outputList, long compute_round, Map<String, List<TimeSpan>> inputTimeSpanMap, Map<String, List<TimeSpan>> outputdetailListMap, IDao_log dao_log, boolean isAll) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        HashMap<String, CoreInput> inputMap = new HashMap<String, CoreInput>();
        for (CoreInput coreInput : inputList) {
            inputMap.put(coreInput.input_sign, coreInput);
        }
        HashMap<String, CoreOutput> outputMap = new HashMap<String, CoreOutput>();
        for (CoreOutput output : outputList) {
            outputMap.put(output.output_sign, output);
        }
        HashMap hashMap = new HashMap();
        HashMap<String, List<TimeSpan>> outputTimeSpanMap = new HashMap<String, List<TimeSpan>>();
        for (int i = 0; i < outputList.size(); ++i) {
            CoreOutput output = outputList.get(i);
            ArrayList<TimeSpan> timeSpanList = new ArrayList<TimeSpan>();
            if (output.dao_type.endsWith("_max") || output.dao_type.endsWith("_stat")) {
                List<TimeSpan> timeSpanList_input = inputTimeSpanMap.get(output.output_sign);
                DateUtil.Instance().ConvertAndMergeTo(timeSpanList_input, output.var_stepSpanMap.get(output.output_sign), output.time_period, output.data_class, timeSpanList);
            } else {
                for (String input_sign : output.all_input.keySet()) {
                    CoreInput coreInput = (CoreInput)inputMap.get(input_sign);
                    if (!inputTimeSpanMap.containsKey(input_sign)) continue;
                    List<TimeSpan> timeSpanList_input = inputTimeSpanMap.get(input_sign);
                    DateUtil.Instance().ConvertAndMergeTo(timeSpanList_input, output.var_stepSpanMap.get(input_sign), output.time_period, coreInput.data_class, timeSpanList);
                }
            }
            DateUtil.Instance().Limit(timeSpanList, output.time_begin, DateUtil.Instance().GetDate_offset(output.time_end, output.time_period, -1));
            List<TimeSpan> timeSpanList_finish = outputdetailListMap.get(output.output_sign);
            for (int ii = timeSpanList.size() - 1; ii >= 0; --ii) {
                TimeSpan timeSpan = (TimeSpan)timeSpanList.get(ii);
                boolean finish = false;
                if (timeSpanList_finish != null) {
                    for (TimeSpan timeSpan2 : timeSpanList_finish) {
                        if (timeSpan2.timefrom.getTime() != timeSpan.timefrom.getTime()) continue;
                        finish = true;
                        break;
                    }
                }
                if (!finish) continue;
                timeSpanList.remove(ii);
            }
            outputTimeSpanMap.put(output.output_sign + "_" + sdf.format(output.time_begin), timeSpanList);
            if (output.dao_type.endsWith("_max") || output.dao_type.endsWith("_stat")) continue;
            for (String string : output.all_input.keySet()) {
                Map IntervalTimeSpanMap;
                if (!hashMap.containsKey(string)) {
                    hashMap.put(string, new HashMap());
                }
                if (!(IntervalTimeSpanMap = (Map)hashMap.get(string)).containsKey(output.time_period)) {
                    IntervalTimeSpanMap.put(output.time_period, new ArrayList());
                }
                List timeSpanList_input = (List)IntervalTimeSpanMap.get(output.time_period);
                DateUtil.Instance().MergeTo(timeSpanList, output.time_period, output.var_stepSpanMap.get(string), timeSpanList_input);
            }
        }
        DataCache dataCache = new DataCache();
        for (String input_sign : hashMap.keySet()) {
            CoreInput input3 = (CoreInput)inputMap.get(input_sign);
            Map timeSpanListMap = (Map)hashMap.get(input_sign);
            for (String time_period : timeSpanListMap.keySet()) {
                List timeSpanList = (List)timeSpanListMap.get(time_period);
                Iterator iterator = timeSpanList.iterator();
                while (iterator.hasNext()) {
                    TimeSpan timeSpan = (TimeSpan)iterator.next();
                    dataCache.GetData(input_sign, input3.dao_type, input3.dao_key, time_period, timeSpan.timefrom, timeSpan.timeto);
                }
            }
        }
        for (int i = 0; i < outputList.size(); ++i) {
            CoreOutput output = outputList.get(i);
            String time_period = output.time_period;
            List timeSpanList = (List)outputTimeSpanMap.get(output.output_sign + "_" + sdf.format(output.time_begin));
            if (output.dao_type.endsWith("_max")) {
                CoreInput coreInput = (CoreInput)inputMap.get(output.output_sign);
                double ratio = 1.0;
                if (coreInput.data_class.equals("consumption")) {
                    ratio = 3600000.0 / (double)Parser_time_period.collect_cycle2Milliseconds(coreInput.time_period);
                }
                List<String> list = Parser_time_period.getBigger("1y", coreInput.time_period);
                for (String string : list) {
                    ArrayList<TimeSpan> timeSpanList_new = new ArrayList<TimeSpan>();
                    DateUtil.Instance().ConvertAndMergeTo(timeSpanList, string, "consumption", timeSpanList_new);
                    for (TimeSpan timeSpan : timeSpanList_new) {
                        List<DoubleTimeObject> dataList = Dao_dataManager.Instance().Get(coreInput.dao_type).GetDataListGteLte(coreInput.dao_key, coreInput.time_period, timeSpan.timefrom, DateUtil.Instance().GetDate_offset(timeSpan.timeto, string, 1), false);
                        ArrayList<DoubleTimeObject_max> outputDataList = new ArrayList<DoubleTimeObject_max>();
                        int tmp_data_index = 0;
                        Date tmpDate = timeSpan.timefrom;
                        while (tmpDate.getTime() <= timeSpan.timeto.getTime()) {
                            Date tmpDateNext = DateUtil.Instance().GetDate_offset(tmpDate, string, 1);
                            Double max_value = null;
                            Date max_time = null;
                            int data_count = 0;
                            for (int index_data = tmp_data_index; index_data < dataList.size(); ++index_data) {
                                tmp_data_index = index_data;
                                DoubleTimeObject data = dataList.get(index_data);
                                if (data.data_time.getTime() < tmpDate.getTime()) continue;
                                if (data.data_time.getTime() >= tmpDateNext.getTime()) break;
                                if (max_value == null || max_value < data.data_value * ratio) {
                                    max_value = data.data_value * ratio;
                                    max_time = data.data_time;
                                }
                                ++data_count;
                            }
                            if (data_count > 0) {
                                DoubleTimeObject_max outputData = new DoubleTimeObject_max();
                                outputData.data_time = tmpDate;
                                outputData.data_value = max_value;
                                outputData.max_time = max_time;
                                outputDataList.add(outputData);
                            }
                            tmpDate = tmpDateNext;
                        }
                        Dao_data_maxManager.Instance().Get(output.dao_type).DeleteDataListGteLte(output.dao_key, string, timeSpan.timefrom, timeSpan.timeto);
                        ConstantCE.SleepBetweenDeleteAndInsert();
                        Dao_data_maxManager.Instance().Get(output.dao_type).InsertDataListGteLte(output.dao_key, string, outputDataList);
                    }
                }
            } else if (output.dao_type.endsWith("_stat")) {
                CoreInput coreInput = (CoreInput)inputMap.get(output.output_sign);
                if (output.data_class.equals("inststat")) {
                    CoreComputeUtil.Stat_inststat(coreInput.dao_type, output.dao_key, timeSpanList, coreInput.time_period, "1y");
                } else if (output.data_class.equals("consumption")) {
                    CoreComputeUtil.Stat_consumption(coreInput.dao_type, output.dao_key, timeSpanList, coreInput.time_period, "1y");
                }
            } else {
                ArrayList<List<DoubleTimeObject>> arrayList = new ArrayList<List<DoubleTimeObject>>();
                ArrayList<DoubleTimeObject> outputDataList_all = new ArrayList<DoubleTimeObject>();
                for (TimeSpan timeSpan : timeSpanList) {
                    Constant.info(object_sign + "\t" + instance_name + "\t" + output.output_sign + "\t" + sdf.format(timeSpan.timefrom) + "\t" + sdf.format(timeSpan.timeto));
                    HashMap<String, Object> inputDataListMap = new HashMap<String, Object>();
                    for (String input_sign : output.var_signMap.keySet()) {
                        JSONObject dao_key;
                        String dao_type;
                        if (inputMap.containsKey(input_sign)) {
                            CoreInput input4 = (CoreInput)inputMap.get(input_sign);
                            dao_type = input4.dao_type;
                            dao_key = input4.dao_key;
                        } else {
                            CoreOutput input = (CoreOutput)outputMap.get(input_sign);
                            dao_type = input.dao_type;
                            dao_key = input.dao_key;
                        }
                        List<DoubleTimeObject> inputDataList = dataCache.GetData(input_sign, dao_type, dao_key, time_period, DateUtil.Instance().GetDate_offset(timeSpan.timefrom, time_period, output.var_stepSpanMap.get((Object)input_sign).backward), DateUtil.Instance().GetDate_offset(timeSpan.timeto, time_period, output.var_stepSpanMap.get((Object)input_sign).forward));
                        inputDataListMap.put(input_sign, inputDataList);
                    }
                    ArrayList<DoubleTimeObject> arrayList2 = new ArrayList<DoubleTimeObject>();
                    Date tmpDate = timeSpan.timefrom;
                    while (tmpDate.compareTo(timeSpan.timeto) <= 0) {
                        HashMap<String, Double> dataMap = new HashMap<String, Double>();
                        int valid_data_count = 0;
                        for (String var_original : output.var_originalMap.keySet()) {
                            int var_offset;
                            String var_sign;
                            int index = var_original.indexOf(39);
                            if (index != -1) {
                                var_sign = var_original.substring(0, index);
                                var_offset = Integer.parseInt(var_original.substring(index + 1));
                            } else {
                                var_sign = var_original;
                                var_offset = 0;
                            }
                            List inputDataList = (List)inputDataListMap.get(var_sign);
                            Date findDate = DateUtil.Instance().GetDate_offset(tmpDate, time_period, var_offset);
                            int findIndex = InsertUtil.Instance().FindIndex(inputDataList, findDate);
                            DoubleTimeObject input_data = null;
                            if (findIndex != -1) {
                                input_data = (DoubleTimeObject)inputDataList.get(findIndex);
                            }
                            if (input_data == null) {
                                dataMap.put(var_original, null);
                                continue;
                            }
                            dataMap.put(var_original, input_data.data_value);
                            ++valid_data_count;
                        }
                        for (String other_param : output.other_paramMap.keySet()) {
                            double opv = CoreComputeUtil_other.GetOtherValue(sdf.format(tmpDate), output.otherMap, other_param);
                            dataMap.put(other_param, opv);
                        }
                        if (output.need_all_var_data && valid_data_count == output.var_originalMap.size() || !output.need_all_var_data && valid_data_count > 0) {
                            DoubleTimeObject outputData = new DoubleTimeObject();
                            outputData.data_time = tmpDate;
                            if (output.mode.equals("expression")) {
                                outputData.data_value = CoreComputeUtilUtil.CantCompute(output.root, dataMap) ? null : Double.valueOf(CoreComputeUtil.ComputeNode(output.root, dataMap));
                            } else if (output.mode.equals("custom")) {
                                outputData.data_value = CustomFunctionManager.Instance().Compute(output.custom_function_name, output.custom_paramsMap, dataMap);
                            } else {
                                throw new Exception("output.mode error:" + output.mode);
                            }
                            if (outputData.data_value != null) {
                                if (Double.isInfinite(outputData.data_value) || Double.isNaN(outputData.data_value)) {
                                    outputData.data_value = 0.0;
                                }
                                if (ConstantCE.expression_negative_to_0 && outputData.data_value < 0.0) {
                                    outputData.data_value = 0.0;
                                }
                                arrayList2.add(outputData);
                            }
                        }
                        tmpDate = DateUtil.Instance().GetDate_offset(tmpDate, time_period, 1);
                    }
                    if (output.successorList.size() > 0) {
                        dataCache.PutData(output.output_sign, time_period, timeSpan.timefrom, timeSpan.timeto, arrayList2);
                    }
                    arrayList.add(arrayList2);
                    outputDataList_all.addAll(arrayList2);
                    Dao_dataManager.Instance().Get(output.dao_type).DeleteDataListGteLte(output.dao_key, time_period, timeSpan.timefrom, timeSpan.timeto);
                    ConstantCE.SleepBetweenDeleteAndInsert();
                    Dao_dataManager.Instance().Get(output.dao_type).InsertDataListGteLte(output.dao_key, time_period, arrayList2);
                }
                if (isAll) {
                    if (output.data_class.equals("consumption")) {
                        CoreComputeUtil.Stat_consumption(output.dao_type, output.dao_key, timeSpanList, time_period, "1d");
                    } else if (output.data_class.equals("near")) {
                        CoreComputeUtil.Stat_near(output.dao_type, output.dao_key, timeSpanList, time_period, outputDataList_all);
                    }
                    if (output.other_type != null && timeSpanList.size() > 0) {
                        CoreComputeUtil_other.Compute_other(output.other_type, object_sign, instance_name, compute_round, output, time_period, timeSpanList, arrayList, outputDataList_all, dao_log);
                    }
                }
            }
            if (!isAll) continue;
            for (TimeSpan timeSpan : timeSpanList) {
                JSONObject InsertObject = new JSONObject();
                InsertObject.put("object_sign", (Object)object_sign);
                InsertObject.put("instance_name", (Object)instance_name);
                InsertObject.put("compute_round", (Object)compute_round);
                InsertObject.put("output_sign", (Object)output.output_sign);
                InsertObject.put("valid_time_from", (Object)sdf.format(timeSpan.timefrom));
                InsertObject.put("valid_time_to", (Object)sdf.format(timeSpan.timeto));
                InsertObject.put("operate_time_to", (Object)sdf.format(new Date()));
                dao_log.InsertData(InsertObject);
            }
        }
        return outputTimeSpanMap;
    }

    private static Map<String, List<TimeSpan>> ComputeByPartAfter(String object_sign, String instance_name, List<CoreInput> inputList, List<CoreOutput> outputList, long compute_round, Map<String, List<TimeSpan>> inputTimeSpanMap, Map<String, List<TimeSpan>> outputdetailListMap, IDao_log dao_log) throws Exception {
        CoreOutput output;
        int i;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        HashMap<String, CoreInput> inputMap = new HashMap<String, CoreInput>();
        for (CoreInput input : inputList) {
            inputMap.put(input.input_sign, input);
        }
        HashMap<String, List<TimeSpan>> outputTimeSpanMap = new HashMap<String, List<TimeSpan>>();
        for (i = 0; i < outputList.size(); ++i) {
            output = outputList.get(i);
            ArrayList<TimeSpan> timeSpanList = new ArrayList<TimeSpan>();
            if (output.dao_type.endsWith("_max") || output.dao_type.endsWith("_stat")) {
                List<TimeSpan> timeSpanList_input = inputTimeSpanMap.get(output.output_sign);
                DateUtil.Instance().ConvertAndMergeTo(timeSpanList_input, output.var_stepSpanMap.get(output.output_sign), output.time_period, output.data_class, timeSpanList);
            } else {
                for (String input_sign : output.all_input.keySet()) {
                    CoreInput input = (CoreInput)inputMap.get(input_sign);
                    if (!inputTimeSpanMap.containsKey(input_sign)) continue;
                    List<TimeSpan> timeSpanList_input = inputTimeSpanMap.get(input_sign);
                    DateUtil.Instance().ConvertAndMergeTo(timeSpanList_input, output.var_stepSpanMap.get(input_sign), output.time_period, input.data_class, timeSpanList);
                }
            }
            DateUtil.Instance().Limit(timeSpanList, output.time_begin, DateUtil.Instance().GetDate_offset(output.time_end, output.time_period, -1));
            List<TimeSpan> timeSpanList_finish = outputdetailListMap.get(output.output_sign);
            for (int ii = timeSpanList.size() - 1; ii >= 0; --ii) {
                TimeSpan timeSpan = (TimeSpan)timeSpanList.get(ii);
                boolean finish = false;
                if (timeSpanList_finish != null) {
                    for (TimeSpan timeSpanInner : timeSpanList_finish) {
                        if (timeSpanInner.timefrom.getTime() != timeSpan.timefrom.getTime()) continue;
                        finish = true;
                        break;
                    }
                }
                if (!finish) continue;
                timeSpanList.remove(ii);
            }
            outputTimeSpanMap.put(output.output_sign + "_" + sdf.format(output.time_begin), timeSpanList);
        }
        for (i = 0; i < outputList.size(); ++i) {
            output = outputList.get(i);
            String time_period = output.time_period;
            List timeSpanList = (List)outputTimeSpanMap.get(output.output_sign + "_" + sdf.format(output.time_begin));
            if (output.data_class.equals("consumption")) {
                CoreComputeUtil.Stat_consumption(output.dao_type, output.dao_key, timeSpanList, time_period, "1d");
            }
            for (TimeSpan timeSpan : timeSpanList) {
                JSONObject InsertObject = new JSONObject();
                InsertObject.put("object_sign", (Object)object_sign);
                InsertObject.put("instance_name", (Object)instance_name);
                InsertObject.put("compute_round", (Object)compute_round);
                InsertObject.put("output_sign", (Object)output.output_sign);
                InsertObject.put("valid_time_from", (Object)sdf.format(timeSpan.timefrom));
                InsertObject.put("valid_time_to", (Object)sdf.format(timeSpan.timeto));
                InsertObject.put("operate_time_to", (Object)sdf.format(new Date()));
                dao_log.InsertData(InsertObject);
            }
        }
        return outputTimeSpanMap;
    }

    public static void Stat_inststat(String dao_type, JSONObject dao_key, List<TimeSpan> timeSpanList, String time_period, String max_time_period) throws Exception {
        if (timeSpanList.size() == 0) {
            return;
        }
        ImplDao_fjd_statinst dao_fjd_statinst = (ImplDao_fjd_statinst)Dao_dataManager.Instance().Get("fjd_statinst");
        List<String> biggerList = Parser_time_period.getBigger(max_time_period, time_period);
        ArrayList<String> allList = new ArrayList<String>();
        allList.add(time_period);
        allList.addAll(biggerList);
        for (int i = 1; i < allList.size(); ++i) {
            String time_period_base = (String)allList.get(i - 1);
            String time_period_bigger = (String)allList.get(i);
            ArrayList<TimeSpan> timeSpanList_new = new ArrayList<TimeSpan>();
            DateUtil.Instance().ConvertAndMergeTo(timeSpanList, time_period_bigger, "inststat", timeSpanList_new);
            for (TimeSpan timeSpan : timeSpanList_new) {
                List<DoubleTimeObject_statinst> dataList = dao_fjd_statinst.GetDataListGteLte_statinst(dao_key, time_period_base, timeSpan.timefrom, DateUtil.Instance().GetDate_offset(timeSpan.timeto, time_period_bigger, 1), false);
                ArrayList<DoubleTimeObject_statinst> outputDataList = new ArrayList<DoubleTimeObject_statinst>();
                int tmp_data_index = 0;
                Date tmpDate = timeSpan.timefrom;
                while (tmpDate.getTime() <= timeSpan.timeto.getTime()) {
                    Date tmpDateNext = DateUtil.Instance().GetDate_offset(tmpDate, time_period_bigger, 1);
                    DoubleTimeObject_statinst stat_data = new DoubleTimeObject_statinst();
                    double data_total = 0.0;
                    int data_count = 0;
                    for (int index_data = tmp_data_index; index_data < dataList.size(); ++index_data) {
                        tmp_data_index = index_data;
                        DoubleTimeObject_statinst data = dataList.get(index_data);
                        if (data.data_time.getTime() < tmpDate.getTime()) continue;
                        if (data.data_time.getTime() >= tmpDateNext.getTime()) break;
                        if (stat_data.data_max == null) {
                            stat_data.time_max = data.time_max;
                            stat_data.data_max = data.data_max;
                        } else if (data.data_max != null && (stat_data.data_max == null || stat_data.data_max < data.data_max)) {
                            stat_data.time_max = data.time_max;
                            stat_data.data_max = data.data_max;
                        }
                        if (stat_data.data_min == null) {
                            stat_data.time_min = data.time_min;
                            stat_data.data_min = data.data_min;
                        } else if (data.data_min != null && (stat_data.data_min == null || stat_data.data_min > data.data_min)) {
                            stat_data.time_min = data.time_min;
                            stat_data.data_min = data.data_min;
                        }
                        data_total += data.data_avg * (double)data.data_count.longValue();
                        data_count = (int)((long)data_count + data.data_count);
                    }
                    if (data_count > 0) {
                        stat_data.data_time = tmpDate;
                        stat_data.data_avg = data_total / (double)data_count;
                        stat_data.data_count = data_count;
                        outputDataList.add(stat_data);
                    }
                    tmpDate = tmpDateNext;
                }
                dao_fjd_statinst.DeleteDataListGteLte_statinst(dao_key, time_period_bigger, timeSpan.timefrom, timeSpan.timeto);
                ConstantCE.SleepBetweenDeleteAndInsert();
                dao_fjd_statinst.InsertDataListGteLte_statinst(dao_key, time_period_bigger, outputDataList);
            }
        }
    }

    public static void Stat_consumption(String dao_type, JSONObject dao_key, List<TimeSpan> timeSpanList, String time_period, String max_time_period) throws Exception {
        if (timeSpanList.size() == 0) {
            return;
        }
        List<String> biggerList = Parser_time_period.getBigger(max_time_period, time_period);
        ArrayList<ArrayList<TimeSpan>> biggerTimeSpanList = new ArrayList<ArrayList<TimeSpan>>();
        for (String bigger : biggerList) {
            ArrayList<TimeSpan> bts = new ArrayList<TimeSpan>();
            DateUtil.Instance().ConvertAndMergeTo(timeSpanList, bigger, "consumption", bts);
            biggerTimeSpanList.add(bts);
        }
        List biggestTimeSpanList = (List)biggerTimeSpanList.get(biggerTimeSpanList.size() - 1);
        String biggest = biggerList.get(biggerList.size() - 1);
        Date stat_from = ((TimeSpan)biggestTimeSpanList.get((int)0)).timefrom;
        Date stat_to = DateUtil.Instance().GetDate_offset(((TimeSpan)biggestTimeSpanList.get((int)(biggestTimeSpanList.size() - 1))).timeto, biggest, 1);
        List<DoubleTimeObject> dataList = Dao_dataManager.Instance().Get(dao_type).GetDataListGteLte(dao_key, time_period, stat_from, stat_to, false);
        for (int index = 0; index < biggerList.size(); ++index) {
            String bigger = biggerList.get(index);
            List bts = (List)biggerTimeSpanList.get(index);
            for (TimeSpan biggerTimeSpan : bts) {
                ArrayList<DoubleTimeObject> outputDataList = new ArrayList<DoubleTimeObject>();
                int tmp_data_index = 0;
                Date tmpDate = biggerTimeSpan.timefrom;
                while (tmpDate.getTime() <= biggerTimeSpan.timeto.getTime()) {
                    Date tmpDateNext = DateUtil.Instance().GetDate_offset(tmpDate, bigger, 1);
                    double data_value = 0.0;
                    int data_count = 0;
                    for (int index_data = tmp_data_index; index_data < dataList.size(); ++index_data) {
                        tmp_data_index = index_data;
                        DoubleTimeObject data = dataList.get(index_data);
                        if (data.data_time.getTime() < tmpDate.getTime()) continue;
                        if (data.data_time.getTime() >= tmpDateNext.getTime()) break;
                        data_value += data.data_value.doubleValue();
                        ++data_count;
                    }
                    if (data_count > 0) {
                        DoubleTimeObject outputData = new DoubleTimeObject();
                        outputData.data_time = tmpDate;
                        outputData.data_value = data_value;
                        outputDataList.add(outputData);
                    }
                    tmpDate = tmpDateNext;
                }
                Dao_dataManager.Instance().Get(dao_type).DeleteDataListGteLte(dao_key, bigger, biggerTimeSpan.timefrom, biggerTimeSpan.timeto);
                ConstantCE.SleepBetweenDeleteAndInsert();
                Dao_dataManager.Instance().Get(dao_type).InsertDataListGteLte(dao_key, bigger, outputDataList);
            }
        }
    }

    public static void Stat_near(String dao_type, JSONObject dao_key, List<TimeSpan> timeSpanList, String time_period, List<DoubleTimeObject> dataList) throws Exception {
        List<TimeSpan> bts;
        if (timeSpanList.size() == 0) {
            return;
        }
        if (dataList.size() == 0) {
            return;
        }
        List<String> biggerList = Parser_time_period.getBigger(ConstantCE.Stat_time_period_fjd_near, time_period);
        ArrayList<ArrayList<TimeSpan>> biggerTimeSpanList = new ArrayList<ArrayList<TimeSpan>>();
        for (String bigger : biggerList) {
            bts = new ArrayList<TimeSpan>();
            DateUtil.Instance().ConvertAndMergeTo(timeSpanList, bigger, "near", bts);
            biggerTimeSpanList.add((ArrayList<TimeSpan>)bts);
        }
        for (int index = 0; index < biggerList.size(); ++index) {
            String bigger;
            bigger = biggerList.get(index);
            bts = (List)biggerTimeSpanList.get(index);
            for (TimeSpan biggerTimeSpan : bts) {
                ArrayList<DoubleTimeObject> outputDataList = new ArrayList<DoubleTimeObject>();
                int tmp_data_index = 0;
                Date tmpDate = biggerTimeSpan.timefrom;
                while (tmpDate.getTime() <= biggerTimeSpan.timeto.getTime()) {
                    Date tmpDateNext = DateUtil.Instance().GetDate_offset(tmpDate, bigger, 1);
                    double data_value = 0.0;
                    int data_count = 0;
                    for (int index_data = tmp_data_index; index_data < dataList.size(); ++index_data) {
                        tmp_data_index = index_data;
                        DoubleTimeObject data = dataList.get(index_data);
                        if (data.data_time.getTime() < tmpDate.getTime()) continue;
                        if (data.data_time.getTime() != tmpDate.getTime()) break;
                        data_value = data.data_value;
                        ++data_count;
                        break;
                    }
                    if (data_count > 0) {
                        DoubleTimeObject outputData = new DoubleTimeObject();
                        outputData.data_time = tmpDate;
                        outputData.data_value = data_value;
                        outputDataList.add(outputData);
                    }
                    tmpDate = tmpDateNext;
                }
                Dao_dataManager.Instance().Get(dao_type).DeleteDataListGteLte(dao_key, bigger, biggerTimeSpan.timefrom, biggerTimeSpan.timeto);
                ConstantCE.SleepBetweenDeleteAndInsert();
                Dao_dataManager.Instance().Get(dao_type).InsertDataListGteLte(dao_key, bigger, outputDataList);
            }
        }
    }

    public static void Refresh(CoreInstance instance) throws Exception {
        int i;
        if (instance.instance_name.startsWith("fjd_0_") || instance.instance_name.equals("servicedata") || instance.instance_name.equals("servicedataoftenant") || instance.instance_name.endsWith("_max") || instance.instance_name.endsWith("_stat")) {
            for (CoreOutput output : instance.outputList) {
                output.var_originalMap.put(output.expression, true);
                output.var_signMap.put(output.expression, true);
                output.var_stepSpanMap.put(output.expression, new StepSpan(0, 0));
            }
            return;
        }
        List<CoreInput> inputList = instance.inputList;
        List<CoreOutput> outputList = instance.outputList;
        HashMap<String, CoreInput> inputMap = new HashMap<String, CoreInput>();
        for (CoreInput coreInput : inputList) {
            inputMap.put(coreInput.input_sign, coreInput);
        }
        HashMap<String, CoreOutput> outputMap = new HashMap<String, CoreOutput>();
        for (CoreOutput coreOutput : outputList) {
            outputMap.put(coreOutput.output_sign, coreOutput);
        }
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        for (CoreOutput output : outputList) {
            if (output.mode.equals("expression")) {
                if (output.expression != null) {
                    try {
                        output.root = String2Grammar.Generate(output.expression);
                    }
                    catch (Exception e) {
                        LogUtil.error((String)("Error expression:" + instance.object_sign + "_" + instance.instance_name + "\t" + output.output_sign + "\t" + output.expression));
                        throw e;
                    }
                }
                CoreComputeUtil.RefreshByNode(inputMap, outputMap, output, output.root);
            } else if (output.mode.equals("custom")) {
                for (String custom_param : output.custom_paramsMap.keySet()) {
                    String var_original = output.custom_paramsMap.get(custom_param);
                    try {
                        Double.parseDouble(var_original);
                    }
                    catch (NumberFormatException e) {
                        int var_offset;
                        String var_sign;
                        int index = var_original.indexOf(39);
                        if (index != -1) {
                            var_sign = var_original.substring(0, index);
                            var_offset = Integer.parseInt(var_original.substring(index + 1));
                        } else {
                            var_sign = var_original;
                            var_offset = 0;
                        }
                        if (!output.var_originalMap.containsKey(var_original)) {
                            output.var_originalMap.put(var_original, true);
                        }
                        if (!output.var_signMap.containsKey(var_sign)) {
                            output.var_signMap.put(var_sign, true);
                        }
                        if (!output.var_stepSpanMap.containsKey(var_sign)) {
                            output.var_stepSpanMap.put(var_sign, new StepSpan(var_offset, var_offset));
                        } else {
                            StepSpan stepSpan = output.var_stepSpanMap.get(var_sign);
                            if (stepSpan.backward > var_offset) {
                                stepSpan.backward = var_offset;
                            }
                            if (stepSpan.forward < var_offset) {
                                stepSpan.forward = var_offset;
                            }
                        }
                        if (!inputMap.containsKey(var_sign)) continue;
                        CoreInput input = (CoreInput)inputMap.get(var_sign);
                        if (output.time_period_intialized || DateUtil.Instance().compare(output.time_period, input.time_period) >= 0) continue;
                        output.time_period = input.time_period;
                    }
                }
            } else {
                throw new Exception("output.mode error:" + output.mode);
            }
            for (String input_sign : output.var_signMap.keySet()) {
                if (hashMap.containsKey(input_sign)) continue;
                hashMap.put(input_sign, true);
            }
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (i = 0; i < inputList.size(); ++i) {
            CoreInput input = inputList.get(i);
            if (hashMap.containsKey(input.input_sign)) continue;
            arrayList.add(i);
        }
        for (i = arrayList.size() - 1; i >= 0; --i) {
            inputList.remove(arrayList.get(i));
        }
    }

    private static void RefreshByNode(Map<String, CoreInput> inputMap, Map<String, CoreOutput> outputMap, CoreOutput output, GrammarTreeNode node) throws Exception {
        if (!node.type.equals("const")) {
            if (node.type.equals("var")) {
                if (!output.var_originalMap.containsKey(node.var_original)) {
                    output.var_originalMap.put(node.var_original, true);
                }
                if (!output.var_signMap.containsKey(node.var_sign)) {
                    output.var_signMap.put(node.var_sign, true);
                }
                if (!inputMap.containsKey(node.var_sign) && !outputMap.containsKey(node.var_sign)) {
                    throw new Exception("var not exist in input:" + node.var_sign);
                }
                if (!output.var_stepSpanMap.containsKey(node.var_sign)) {
                    output.var_stepSpanMap.put(node.var_sign, new StepSpan(node.var_offset, node.var_offset));
                } else {
                    StepSpan stepSpan = output.var_stepSpanMap.get(node.var_sign);
                    if (stepSpan.backward > node.var_offset) {
                        stepSpan.backward = node.var_offset;
                    }
                    if (stepSpan.forward < node.var_offset) {
                        stepSpan.forward = node.var_offset;
                    }
                }
                if (inputMap.containsKey(node.var_sign)) {
                    CoreInput input = inputMap.get(node.var_sign);
                    if (!output.time_period_intialized && DateUtil.Instance().compare(output.time_period, input.time_period) < 0) {
                        output.time_period = input.time_period;
                    }
                }
            } else if (node.type.equals("other")) {
                output.other_paramMap.put(node.other, true);
            } else if (node.type.equals("evaluate")) {
                for (GrammarTreeNode nodeInner : node.evaluateItemList) {
                    CoreComputeUtil.RefreshByNode(inputMap, outputMap, output, nodeInner);
                }
            } else if (node.type.equals("compare")) {
                CoreComputeUtil.RefreshByCompare(inputMap, outputMap, output, node.compare);
                CoreComputeUtil.RefreshByNode(inputMap, outputMap, output, node.compare_yes_node);
                CoreComputeUtil.RefreshByNode(inputMap, outputMap, output, node.compare_no_node);
            }
        }
    }

    private static void RefreshByCompare(Map<String, CoreInput> inputMap, Map<String, CoreOutput> outputMap, CoreOutput output, GrammarCompare compare) throws Exception {
        if (compare.type.equals("itom")) {
            CoreComputeUtil.RefreshByNode(inputMap, outputMap, output, compare.itom_left);
            CoreComputeUtil.RefreshByNode(inputMap, outputMap, output, compare.itom_right);
        } else if (compare.type.equals("group")) {
            for (GrammarCompare compareInner : compare.groupItemList) {
                CoreComputeUtil.RefreshByCompare(inputMap, outputMap, output, compareInner);
            }
        }
    }

    public static double ComputeNode(GrammarTreeNode node, Map<String, Double> dataMap) throws Exception {
        if (node.type.equals("const")) {
            return node.const_value;
        }
        if (node.type.equals("var")) {
            Double value = dataMap.get(node.var_original);
            if (value != null) {
                return value;
            }
            return 0.0;
        }
        if (node.type.equals("other")) {
            Double value = dataMap.get(node.other);
            if (value != null) {
                return value;
            }
            return 0.0;
        }
        if (node.type.equals("evaluate")) {
            ArrayList<Double> children = new ArrayList<Double>();
            for (GrammarTreeNode nodeInner : node.evaluateItemList) {
                double child = CoreComputeUtil.ComputeNode(nodeInner, dataMap);
                children.add(child);
            }
            Double result = null;
            if (node.evaluate.equals("+")) {
                result = 0.0;
                for (Double child : children) {
                    result = result + child;
                }
            } else if (node.evaluate.equals("-")) {
                result = (Double)children.get(0) - (Double)children.get(1);
            } else if (node.evaluate.equals("*")) {
                result = 1.0;
                for (Double child : children) {
                    result = result * child;
                }
            } else if (node.evaluate.equals("/")) {
                result = (Double)children.get(0) / (Double)children.get(1);
            } else if (node.evaluate.equals("max")) {
                for (Double child : children) {
                    if (result == null) {
                        result = child;
                        continue;
                    }
                    if (!(result < child)) continue;
                    result = child;
                }
            } else if (node.evaluate.equals("min")) {
                result = 1.0;
                for (Double child : children) {
                    if (result == null) {
                        result = child;
                        continue;
                    }
                    if (!(result > child)) continue;
                    result = child;
                }
            } else if (MathUtil.Instance().diy_funname(MathUtil.Instance().fun0p, node.evaluate)) {
                result = MathUtil.Instance().fun0p_value(node.evaluate);
            } else if (MathUtil.Instance().diy_funname(MathUtil.Instance().fun1p, node.evaluate)) {
                result = MathUtil.Instance().fun1p_value(node.evaluate, (Double)children.get(0));
            } else if (MathUtil.Instance().diy_funname(MathUtil.Instance().fun2p, node.evaluate)) {
                result = MathUtil.Instance().fun2p_value(node.evaluate, (Double)children.get(0), (Double)children.get(1));
            } else {
                throw new Exception("operator error:" + node.evaluate);
            }
            return result;
        }
        if (node.type.equals("compare")) {
            boolean com = CoreComputeUtil.Compute_compare(node.compare, dataMap);
            Double result = com ? Double.valueOf(CoreComputeUtil.ComputeNode(node.compare_yes_node, dataMap)) : Double.valueOf(CoreComputeUtil.ComputeNode(node.compare_no_node, dataMap));
            return result;
        }
        throw new Exception("type error:" + node.type);
    }

    private static boolean Compute_compare(GrammarCompare compare, Map<String, Double> dataMap) throws Exception {
        if (compare.type.equals("itom")) {
            double left = CoreComputeUtil.ComputeNode(compare.itom_left, dataMap);
            double right = CoreComputeUtil.ComputeNode(compare.itom_right, dataMap);
            return MathUtil.Instance().cmp_value(compare.itom_op, left, right);
        }
        if (compare.type.equals("group")) {
            if (compare.group_op.equals("&&")) {
                boolean all_yes = true;
                for (GrammarCompare compareInner : compare.groupItemList) {
                    if (CoreComputeUtil.Compute_compare(compareInner, dataMap)) continue;
                    all_yes = false;
                    break;
                }
                return all_yes;
            }
            if (compare.group_op.equals("||")) {
                boolean exist_yes = false;
                for (GrammarCompare compareInner : compare.groupItemList) {
                    if (!CoreComputeUtil.Compute_compare(compareInner, dataMap)) continue;
                    exist_yes = true;
                    break;
                }
                return exist_yes;
            }
            if (compare.group_op.equals("!")) {
                return !CoreComputeUtil.Compute_compare(compare.groupItemList.get(0), dataMap);
            }
            throw new Exception("compare group_op error:" + compare.group_op);
        }
        throw new Exception("compare type error:" + compare.type);
    }

    static {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        try {
            Date date_from = sdf.parse("20000101000000");
            Date date_to = sdf.parse("21000101000000");
            Date date_tmp = date_from;
            while (date_tmp.compareTo(date_to) < 0) {
                Date date_next = DateUtil.Instance().GetDate_offset(date_tmp, "1m", 1);
                splitDateList.add(date_tmp);
                date_tmp = date_next;
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }
}

