/*
 * Decompiled with CFR 0.152.
 */
package com.sagacloud.extend.dao_data;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.sagacloud.util.compute_engine.core.AnnotationDescription;
import com.sagacloud.util.compute_engine.core.IDao_data;
import com.sagacloud.util.compute_engine.util.ConstantCE;
import com.sagacloud.util.compute_engine.util.DoubleTimeObject;
import com.sagacloud.util.compute_engine.util.DoubleTimeObject_loss_rate;
import com.sagacloud.util.compute_engine.util.QueryUtil;
import com.zillion.database.agent.IZillionAgent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.zillion.util.json.FastJsonUtil;

@AnnotationDescription(value="dao_data")
public class ImplDao_fjd_0_loss_rate
implements IDao_data {
    IZillionAgent agent;
    String database_name;
    String table_name;
    String dao_type = "fjd_0_loss_rate";

    @Override
    public void Initialize(IZillionAgent agent, String database_name) {
        this.agent = agent;
        this.database_name = database_name;
        this.table_name = "fjd_0_loss_rate";
    }

    @Override
    public String GetName() {
        return this.dao_type;
    }

    @Override
    public List<DoubleTimeObject> GetDataListGteLte(JSONObject dao_key, String time_period, Date time_from, Date time_to, boolean GteLte) throws Exception {
        List<DoubleTimeObject> result = null;
        return result;
    }

    @Override
    public void InsertDataListGteLte(JSONObject dao_key, String time_period, List<DoubleTimeObject> outputDataList) throws Exception {
    }

    @Override
    public void DeleteDataListGteLte(JSONObject dao_key, String time_period, Date time_from, Date time_to) throws Exception {
        if (ConstantCE.time_period_seperate_save_two || !ConstantCE.time_period_seperate) {
            this.DeleteDataListGteLte(false, dao_key, time_period, time_from, time_to);
        }
        if (ConstantCE.time_period_seperate_save_two || ConstantCE.time_period_seperate) {
            this.DeleteDataListGteLte(true, dao_key, time_period, time_from, time_to);
        }
    }

    private void DeleteDataListGteLte(boolean time_period_seperate, JSONObject dao_key, String time_period, Date time_from, Date time_to) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String building = (String)dao_key.get((Object)"building");
        String meter = (String)dao_key.get((Object)"meter");
        long funcid = FastJsonUtil.getLong((JSONObject)dao_key, (String)"funcid");
        JSONObject Criteria = new JSONObject();
        Criteria.put("building", (Object)building);
        Criteria.put("meter", (Object)meter);
        Criteria.put("funcid", (Object)funcid);
        if (!time_period_seperate) {
            Criteria.put("time_period", (Object)time_period);
        }
        JSONObject range = new JSONObject();
        range.put("$gte", (Object)sdf.format(time_from));
        range.put("$lte", (Object)sdf.format(time_to));
        Criteria.put("operate_time", (Object)range);
        String table_name_query = time_period_seperate ? this.table_name + "_" + time_period : this.table_name;
        QueryUtil.delete(this.agent, this.database_name, table_name_query, Criteria);
    }

    public void InsertDataListGteLte_rate(boolean time_period_seperate, JSONObject dao_key, String time_period, List<DoubleTimeObject_loss_rate> outputDataList) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String building = (String)dao_key.get((Object)"building");
        String meter = (String)dao_key.get((Object)"meter");
        long funcid = FastJsonUtil.getLong((JSONObject)dao_key, (String)"funcid");
        JSONArray InsertObjects = new JSONArray();
        for (DoubleTimeObject_loss_rate data : outputDataList) {
            JSONObject InsertObject = new JSONObject();
            InsertObject.put("building", (Object)building);
            InsertObject.put("meter", (Object)meter);
            InsertObject.put("funcid", (Object)funcid);
            if (!time_period_seperate) {
                InsertObject.put("time_period", (Object)time_period);
            }
            InsertObject.put("operate_time", (Object)sdf.format(data.operate_time));
            InsertObject.put("valid_count", (Object)data.valid_count);
            InsertObject.put("valid_minutes", (Object)data.valid_minutes);
            InsertObject.put("valid_rate", (Object)data.valid_rate);
            InsertObjects.add((Object)InsertObject);
        }
        String table_name_query = time_period_seperate ? this.table_name + "_" + time_period : this.table_name;
        QueryUtil.batch_insert(this.agent, this.database_name, table_name_query, InsertObjects);
    }

    public List<DoubleTimeObject_loss_rate> GetDataListGteLte_rate(JSONObject dao_key, String time_period, Date time_from, Date time_to, boolean GteLte) throws Exception {
        ArrayList<DoubleTimeObject_loss_rate> result = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String building = (String)dao_key.get((Object)"building");
        String meter = (String)dao_key.get((Object)"meter");
        long funcid = FastJsonUtil.getLong((JSONObject)dao_key, (String)"funcid");
        JSONObject Criteria = new JSONObject();
        Criteria.put("building", (Object)building);
        Criteria.put("meter", (Object)meter);
        Criteria.put("funcid", (Object)funcid);
        if (!ConstantCE.time_period_seperate) {
            Criteria.put("time_period", (Object)time_period);
        }
        JSONObject range = new JSONObject();
        range.put("$gte", (Object)sdf.format(time_from));
        if (GteLte) {
            range.put("$lte", (Object)sdf.format(time_to));
        } else {
            range.put("$lt", (Object)sdf.format(time_to));
        }
        Criteria.put("operate_time", (Object)range);
        String table_name_query = ConstantCE.time_period_seperate ? this.table_name + "_" + time_period : this.table_name;
        JSONArray resultContent = QueryUtil.select(this.agent, this.database_name, table_name_query, Criteria);
        ArrayList<DoubleTimeObject_loss_rate> dataList = new ArrayList<DoubleTimeObject_loss_rate>();
        for (int ii = 0; ii < resultContent.size(); ++ii) {
            JSONObject computelog = (JSONObject)resultContent.get(ii);
            DoubleTimeObject_loss_rate data = new DoubleTimeObject_loss_rate();
            data.operate_time = sdf.parse((String)computelog.get((Object)"operate_time"));
            data.valid_count = (Long)computelog.get((Object)"valid_count");
            data.valid_minutes = (Long)computelog.get((Object)"valid_minutes");
            data.valid_rate = (Double)computelog.get((Object)"valid_rate");
            dataList.add(data);
        }
        result = dataList;
        return result;
    }
}

