/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagemem;

import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;

public class FullPageId {
    private final long pageId;
    private final long effectivePageId;
    private final int grpId;

    public static int hashCode(int grpId, long pageId) {
        long effectiveId = PageIdUtils.effectivePageId(pageId);
        return U.hash(FullPageId.hashCode0(grpId, effectiveId));
    }

    private static int hashCode0(int grpId, long effectivePageId) {
        return (int)(FullPageId.mix64(effectivePageId) ^ (long)FullPageId.mix32(grpId));
    }

    private static int mix32(int k) {
        k = (k ^ k >>> 16) * -2048144789;
        k = (k ^ k >>> 13) * -1028477387;
        return k ^ k >>> 16;
    }

    private static long mix64(long z) {
        z = (z ^ z >>> 32) * 5536775847593249645L;
        z = (z ^ z >>> 29) * -282946459933713943L;
        return z ^ z >>> 32;
    }

    public FullPageId(long pageId, int grpId) {
        this.pageId = pageId;
        this.grpId = grpId;
        this.effectivePageId = PageIdUtils.effectivePageId(pageId);
    }

    public long pageId() {
        return this.pageId;
    }

    public int groupId() {
        return this.grpId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FullPageId)) {
            return false;
        }
        FullPageId that = (FullPageId)o;
        return this.effectivePageId == that.effectivePageId && this.grpId == that.grpId;
    }

    public int hashCode() {
        return FullPageId.hashCode0(this.grpId, this.effectivePageId);
    }

    public String toString() {
        return new SB("FullPageId [pageId=").appendHex(this.pageId).a(", effectivePageId=").appendHex(this.effectivePageId).a(", grpId=").a(this.grpId).a(']').toString();
    }
}

