/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class GridChangeGlobalStateMessageResponse
extends GridCacheMessage {
    private static final long serialVersionUID = 0L;
    private UUID requestId;
    @GridDirectTransient
    private Throwable err;
    private byte[] errBytes;

    public GridChangeGlobalStateMessageResponse() {
    }

    public GridChangeGlobalStateMessageResponse(UUID requestId, Throwable err) {
        this.requestId = requestId;
        this.err = err;
    }

    @Override
    public boolean cacheGroupMessage() {
        return false;
    }

    @Override
    public int handlerId() {
        return 0;
    }

    public UUID getRequestId() {
        return this.requestId;
    }

    public Throwable getError() {
        return this.err;
    }

    @Override
    public void prepareMarshal(GridCacheSharedContext ctx) throws IgniteCheckedException {
        super.prepareMarshal(ctx);
        if (this.err != null && this.errBytes == null) {
            this.errBytes = CU.marshal(ctx, false, this.err);
        }
    }

    @Override
    public void finishUnmarshal(GridCacheSharedContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        super.finishUnmarshal(ctx, ldr);
        if (this.errBytes != null && this.err == null) {
            this.err = (Throwable)ctx.marshaller().unmarshal(this.errBytes, U.resolveClassLoader(ldr, ctx.gridConfig()));
        }
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 2: {
                if (!writer.writeByteArray("errBytes", this.errBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                if (!writer.writeUuid("requestId", this.requestId)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 2: {
                this.errBytes = reader.readByteArray("errBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 3: {
                this.requestId = reader.readUuid("requestId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridChangeGlobalStateMessageResponse.class);
    }

    @Override
    public short directType() {
        return -45;
    }

    @Override
    public byte fieldsCount() {
        return 4;
    }

    @Override
    public boolean addDeploymentInfo() {
        return false;
    }

    @Override
    public String toString() {
        return S.toString(GridChangeGlobalStateMessageResponse.class, this, super.toString());
    }
}

