/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.atomic;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridDirectCollection;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheDeployable;
import org.apache.ignite.internal.processors.cache.GridCacheIdMessage;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.UpdateErrors;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class GridDhtAtomicUpdateResponse
extends GridCacheIdMessage
implements GridCacheDeployable {
    private static final long serialVersionUID = 0L;
    public static final int CACHE_MSG_IDX = GridDhtAtomicUpdateResponse.nextIndexId();
    private long futId;
    private UpdateErrors errs;
    @GridToStringInclude
    @GridDirectCollection(value=KeyCacheObject.class)
    private List<KeyCacheObject> nearEvicted;
    private int partId;

    public GridDhtAtomicUpdateResponse() {
    }

    public GridDhtAtomicUpdateResponse(int cacheId, int partId, long futId, boolean addDepInfo) {
        this.cacheId = cacheId;
        this.partId = partId;
        this.futId = futId;
        this.addDepInfo = addDepInfo;
    }

    @Override
    public int lookupIndex() {
        return CACHE_MSG_IDX;
    }

    public long futureId() {
        return this.futId;
    }

    public void onError(IgniteCheckedException err) {
        if (this.errs == null) {
            this.errs = new UpdateErrors();
        }
        this.errs.onError(err);
    }

    @Override
    public IgniteCheckedException error() {
        return this.errs != null ? this.errs.error() : null;
    }

    Collection<KeyCacheObject> nearEvicted() {
        return this.nearEvicted;
    }

    public void nearEvicted(List<KeyCacheObject> nearEvicted) {
        this.nearEvicted = nearEvicted;
    }

    @Override
    public int partition() {
        return this.partId;
    }

    @Override
    public void prepareMarshal(GridCacheSharedContext ctx) throws IgniteCheckedException {
        super.prepareMarshal(ctx);
        GridCacheContext cctx = ctx.cacheContext(this.cacheId);
        if (cctx != null) {
            this.prepareMarshalCacheObjects(this.nearEvicted, cctx);
            if (this.errs != null) {
                this.errs.prepareMarshal(this, cctx);
            }
        }
    }

    @Override
    public void finishUnmarshal(GridCacheSharedContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        super.finishUnmarshal(ctx, ldr);
        GridCacheContext cctx = ctx.cacheContext(this.cacheId);
        this.finishUnmarshalCacheObjects(this.nearEvicted, cctx, ldr);
        if (this.errs != null) {
            this.errs.finishUnmarshal(this, cctx, ldr);
        }
    }

    @Override
    public boolean addDeploymentInfo() {
        return this.addDepInfo;
    }

    @Override
    public IgniteLogger messageLogger(GridCacheSharedContext ctx) {
        return ctx.atomicMessageLogger();
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 3: {
                if (!writer.writeMessage("errs", this.errs)) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                if (!writer.writeLong("futId", this.futId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                if (!writer.writeCollection("nearEvicted", this.nearEvicted, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                if (!writer.writeInt("partId", this.partId)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 3: {
                this.errs = (UpdateErrors)reader.readMessage("errs");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 4: {
                this.futId = reader.readLong("futId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 5: {
                this.nearEvicted = (List)reader.readCollection("nearEvicted", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 6: {
                this.partId = reader.readInt("partId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridDhtAtomicUpdateResponse.class);
    }

    @Override
    public short directType() {
        return 39;
    }

    @Override
    public byte fieldsCount() {
        return 7;
    }

    @Override
    public String toString() {
        return S.toString(GridDhtAtomicUpdateResponse.class, this);
    }
}

