/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.wal.reader;

import java.io.File;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.internal.pagemem.wal.WALIterator;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIOFactory;
import org.apache.ignite.internal.processors.cache.persistence.wal.reader.StandaloneGridKernalContext;
import org.apache.ignite.internal.processors.cache.persistence.wal.reader.StandaloneIgniteCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.wal.reader.StandaloneWalRecordsIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IgniteWalIteratorFactory {
    private final IgniteLogger log;
    private final int pageSize;
    @Nullable
    private File binaryMetadataFileStoreDir;
    @Nullable
    private File marshallerMappingFileStoreDir;
    private boolean keepBinary;
    private FileIOFactory ioFactory;
    private int bufSize = 0x200000;

    public IgniteWalIteratorFactory(@NotNull IgniteLogger log, int pageSize, @Nullable File binaryMetadataFileStoreDir, @Nullable File marshallerMappingFileStoreDir, boolean keepBinary) {
        this.log = log;
        this.pageSize = pageSize;
        this.binaryMetadataFileStoreDir = binaryMetadataFileStoreDir;
        this.marshallerMappingFileStoreDir = marshallerMappingFileStoreDir;
        this.keepBinary = keepBinary;
        this.ioFactory = new DataStorageConfiguration().getFileIOFactory();
        new DataStorageConfiguration().setPageSize(pageSize);
    }

    public IgniteWalIteratorFactory(@NotNull IgniteLogger log, int pageSize, @Nullable File binaryMetadataFileStoreDir, @Nullable File marshallerMappingFileStoreDir) {
        this(log, pageSize, binaryMetadataFileStoreDir, marshallerMappingFileStoreDir, false);
    }

    public IgniteWalIteratorFactory(@NotNull IgniteLogger log, @NotNull FileIOFactory ioFactory, int pageSize) {
        this.log = log;
        this.pageSize = pageSize;
        this.ioFactory = ioFactory;
        new DataStorageConfiguration().setPageSize(pageSize);
    }

    public IgniteWalIteratorFactory(@NotNull IgniteLogger log, int pageSize) {
        this(log, new DataStorageConfiguration().getFileIOFactory(), pageSize);
    }

    public WALIterator iteratorArchiveDirectory(@NotNull File walDirWithConsistentId) throws IgniteCheckedException {
        return new StandaloneWalRecordsIterator(walDirWithConsistentId, this.log, this.prepareSharedCtx(), this.ioFactory, this.keepBinary, this.bufSize);
    }

    public WALIterator iteratorArchiveFiles(File ... files) throws IgniteCheckedException {
        return new StandaloneWalRecordsIterator(this.log, this.prepareSharedCtx(), this.ioFactory, false, this.keepBinary, this.bufSize, files);
    }

    public WALIterator iteratorWorkFiles(File ... files) throws IgniteCheckedException {
        return new StandaloneWalRecordsIterator(this.log, this.prepareSharedCtx(), this.ioFactory, true, this.keepBinary, this.bufSize, files);
    }

    @NotNull
    private GridCacheSharedContext prepareSharedCtx() throws IgniteCheckedException {
        StandaloneGridKernalContext kernalCtx = new StandaloneGridKernalContext(this.log, this.binaryMetadataFileStoreDir, this.marshallerMappingFileStoreDir);
        StandaloneIgniteCacheDatabaseSharedManager dbMgr = new StandaloneIgniteCacheDatabaseSharedManager();
        dbMgr.setPageSize(this.pageSize);
        return new GridCacheSharedContext(kernalCtx, null, null, null, null, null, null, dbMgr, null, null, null, null, null, null, null, null);
    }

    public void ioFactory(FileIOFactory ioFactory) {
        this.ioFactory = ioFactory;
    }

    public void bufferSize(int bufSize) {
        this.bufSize = bufSize;
    }
}

