/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.jdbc;

import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.processors.odbc.SqlListenerUtils;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcRawBinarylizable;
import org.apache.ignite.internal.util.typedef.internal.S;

public class JdbcQuery
implements JdbcRawBinarylizable {
    private String sql;
    private Object[] args;

    public JdbcQuery() {
    }

    public JdbcQuery(String sql, Object[] args) {
        this.sql = sql;
        this.args = args;
    }

    public String sql() {
        return this.sql;
    }

    public Object[] args() {
        return this.args;
    }

    @Override
    public void writeBinary(BinaryWriterExImpl writer) {
        writer.writeString(this.sql);
        if (this.args == null || this.args.length == 0) {
            writer.writeInt(0);
        } else {
            writer.writeInt(this.args.length);
            for (Object arg : this.args) {
                SqlListenerUtils.writeObject(writer, arg, false);
            }
        }
    }

    @Override
    public void readBinary(BinaryReaderExImpl reader) {
        this.sql = reader.readString();
        int argsNum = reader.readInt();
        this.args = new Object[argsNum];
        for (int i = 0; i < argsNum; ++i) {
            this.args[i] = SqlListenerUtils.readObject(reader, false);
        }
    }

    public String toString() {
        return S.toString(JdbcQuery.class, this);
    }
}

