/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.worker;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.internal.util.worker.GridWorkerListener;

public class WorkersRegistry
implements GridWorkerListener {
    private final ConcurrentMap<String, GridWorker> registeredWorkers = new ConcurrentHashMap<String, GridWorker>();

    public void register(GridWorker w) {
        if (this.registeredWorkers.putIfAbsent(w.runner().getName(), w) != null) {
            throw new IllegalStateException("Worker is already registered [worker=" + w + ']');
        }
    }

    public void unregister(String name) {
        this.registeredWorkers.remove(name);
    }

    public Collection<String> names() {
        return this.registeredWorkers.keySet();
    }

    public GridWorker worker(String name) {
        return (GridWorker)this.registeredWorkers.get(name);
    }

    @Override
    public void onStarted(GridWorker w) {
        this.register(w);
    }

    @Override
    public void onStopped(GridWorker w) {
        this.unregister(w.runner().getName());
    }
}

