/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.internal.processors.query.h2.H2TableDescriptor;
import org.apache.ignite.internal.processors.query.h2.H2TypeKey;

public class H2Schema {
    private final String schemaName;
    private final ConcurrentMap<String, H2TableDescriptor> tbls = new ConcurrentHashMap<String, H2TableDescriptor>();
    private final ConcurrentMap<H2TypeKey, H2TableDescriptor> typeToTbl = new ConcurrentHashMap<H2TypeKey, H2TableDescriptor>();
    private int usageCnt;

    public H2Schema(String schemaName) {
        this.schemaName = schemaName;
    }

    public String schemaName() {
        return this.schemaName;
    }

    public int incrementUsageCount() {
        return ++this.usageCnt;
    }

    public int decrementUsageCount() {
        return --this.usageCnt;
    }

    public Collection<H2TableDescriptor> tables() {
        return this.tbls.values();
    }

    public H2TableDescriptor tableByName(String tblName) {
        return (H2TableDescriptor)this.tbls.get(tblName);
    }

    public H2TableDescriptor tableByTypeName(String cacheName, String typeName) {
        return (H2TableDescriptor)this.typeToTbl.get(new H2TypeKey(cacheName, typeName));
    }

    public void add(H2TableDescriptor tbl) {
        if (this.tbls.putIfAbsent(tbl.tableName(), tbl) != null) {
            throw new IllegalStateException("Table already registered: " + tbl.fullTableName());
        }
        if (this.typeToTbl.putIfAbsent(new H2TypeKey(tbl.cache().name(), tbl.typeName()), tbl) != null) {
            throw new IllegalStateException("Table already registered: " + tbl.fullTableName());
        }
    }

    public void remove(H2TableDescriptor tbl) {
        this.tbls.remove(tbl.tableName());
        this.typeToTbl.remove(new H2TypeKey(tbl.cache().name(), tbl.typeName()));
    }

    public void drop(H2TableDescriptor tbl) {
        tbl.onDrop();
        this.tbls.remove(tbl.tableName());
        this.typeToTbl.remove(new H2TypeKey(tbl.cache().name(), tbl.typeName()));
    }

    public void dropAll() {
        for (H2TableDescriptor tbl : this.tbls.values()) {
            tbl.onDrop();
        }
        this.tbls.clear();
        this.typeToTbl.clear();
    }
}

