/*
 * Decompiled with CFR 0.152.
 */
package com.sagacloud.util.compute_engine.fjd;

import com.sagacloud.util.compute_engine.core.Dao_dataManager;
import com.sagacloud.util.compute_engine.core.Dao_data_maxManager;
import com.sagacloud.util.compute_engine.fjd.ImplDao_log;
import com.sagacloud.util.compute_engine.fjd.TableUtil;
import com.sagacloud.util.compute_engine.fjd.ThreadCompute;
import com.sagacloud.util.compute_engine.fjd.ThreadComputeJob;
import com.sagacloud.util.compute_engine.fjd.ThreadDelay;
import com.sagacloud.util.compute_engine.util.Constant;
import com.sagacloud.util.compute_engine.util.ConstantCE;
import com.sagacloud.util.compute_engine.util.QueryUtil;
import com.zillion.database.agent.IZillionAgent;
import com.zillion.database.agent.ZillionAgent;
import com.zillion.util.common.ZillionConstant;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.tanukisoftware.wrapper.WrapperListener;
import org.tanukisoftware.wrapper.WrapperManager;
import org.zillion.util.log.LogUtil;

public class ComputeEngineMain
implements WrapperListener {
    ZillionAgent agent;
    List<ThreadCompute> threadList;
    List<ThreadComputeJob> threadJobList;
    ThreadDelay threadDelay;

    public static void main(String[] args) {
        WrapperManager.start((WrapperListener)new ComputeEngineMain(), (String[])args);
    }

    public Integer start(String[] args) {
        LogUtil.warn((String)"service starting");
        ZillionConstant.ObserverWait = 0L;
        try {
            Thread thread;
            int i;
            Configuration configuration = new Configuration();
            configuration.addResource((InputStream)new FileInputStream(Constant.GetPath() + "/hbase-site.xml"));
            this.agent = new ZillionAgent(configuration);
            this.agent.Start();
            if (!QueryUtil.database_exist((IZillionAgent)this.agent, ConstantCE.database_name)) {
                this.agent.NDL_AddDatabase(ConstantCE.database_name);
            }
            TableUtil.AddTables(this.agent, ConstantCE.database_name);
            TableUtil.AlterTables(this.agent, ConstantCE.database_name);
            Dao_dataManager.Instance().Initialize((IZillionAgent)this.agent, ConstantCE.database_name);
            Dao_data_maxManager.Instance().Initialize((IZillionAgent)this.agent, ConstantCE.database_name);
            ImplDao_log dao_log = new ImplDao_log((IZillionAgent)this.agent, ConstantCE.database_name);
            this.threadList = new ArrayList<ThreadCompute>();
            for (i = 0; i < ConstantCE.thread_count; ++i) {
                thread = new ThreadCompute(this.agent, ConstantCE.database_name, dao_log);
                thread.start();
                this.threadList.add((ThreadCompute)thread);
            }
            if (ConstantCE.job_split) {
                this.threadJobList = new ArrayList<ThreadComputeJob>();
                for (i = 0; i < ConstantCE.job_thread_count; ++i) {
                    thread = new ThreadComputeJob();
                    thread.start();
                    this.threadJobList.add((ThreadComputeJob)thread);
                }
            }
            if (ConstantCE.original_delay_enable) {
                TableUtil.AddTable(this.agent, ConstantCE.database_name, "original_delaylog");
                TableUtil.AddTable(this.agent, ConstantCE.database_name, "original_delaydetail");
                TableUtil.AddTable(this.agent, ConstantCE.database_name, "original_delaystat");
                this.threadDelay = new ThreadDelay(this.agent, ConstantCE.database_name);
                this.threadDelay.start();
            }
        }
        catch (Exception e) {
            LogUtil.warn((Exception)e);
        }
        LogUtil.warn((String)"service started");
        return null;
    }

    public int stop(int exitCode) {
        boolean all_finish;
        LogUtil.warn((String)"service stopping");
        if (ConstantCE.original_delay_enable) {
            this.threadDelay.requestStop();
            do {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            } while (this.threadDelay.isAlive());
        }
        for (int i = 0; i < this.threadList.size(); ++i) {
            ThreadCompute thread = this.threadList.get(i);
            thread.requestStop();
        }
        block6: do {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            all_finish = true;
            for (ThreadCompute thread : this.threadList) {
                if (!thread.isAlive()) continue;
                all_finish = false;
                continue block6;
            }
        } while (!all_finish);
        this.agent.Stop();
        LogUtil.warn((String)"service stopped");
        return exitCode;
    }

    public void controlEvent(int event) {
        LogUtil.warn((String)("service controlEvent(" + event + ")"));
    }
}

