/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.imps;

import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.curator.CuratorZookeeperClient;
import org.apache.curator.RetryLoop;
import org.apache.curator.framework.imps.CuratorFrameworkImpl;
import org.apache.curator.utils.EnsurePath;
import org.apache.curator.utils.InternalACLProvider;
import org.apache.curator.utils.PathUtils;
import org.apache.curator.utils.ZKPaths;
import org.apache.zookeeper.ZooKeeper;

class NamespaceImpl {
    private final CuratorFrameworkImpl client;
    private final String namespace;
    private final AtomicBoolean ensurePathNeeded;

    NamespaceImpl(CuratorFrameworkImpl client, String namespace) {
        if (namespace != null) {
            try {
                PathUtils.validatePath((String)("/" + namespace));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Invalid namespace: " + namespace);
            }
        }
        this.client = client;
        this.namespace = namespace;
        this.ensurePathNeeded = new AtomicBoolean(namespace != null);
    }

    String getNamespace() {
        return this.namespace;
    }

    String unfixForNamespace(String path) {
        String namespacePath;
        if (this.namespace != null && path != null && path.startsWith(namespacePath = ZKPaths.makePath((String)this.namespace, null))) {
            path = path.length() > namespacePath.length() ? path.substring(namespacePath.length()) : "/";
        }
        return path;
    }

    String fixForNamespace(String path, boolean isSequential) {
        if (this.ensurePathNeeded.get()) {
            try {
                final CuratorZookeeperClient zookeeperClient = this.client.getZookeeperClient();
                RetryLoop.callWithRetry((CuratorZookeeperClient)zookeeperClient, (Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        ZKPaths.mkdirs((ZooKeeper)zookeeperClient.getZooKeeper(), (String)ZKPaths.makePath((String)"/", (String)NamespaceImpl.this.namespace), (boolean)true, (InternalACLProvider)NamespaceImpl.this.client.getAclProvider(), (boolean)true);
                        return null;
                    }
                });
                this.ensurePathNeeded.set(false);
            }
            catch (Exception e) {
                this.client.logError("Ensure path threw exception", e);
            }
        }
        return ZKPaths.fixForNamespace((String)this.namespace, (String)path, (boolean)isSequential);
    }

    EnsurePath newNamespaceAwareEnsurePath(String path) {
        return new EnsurePath(this.fixForNamespace(path, false), (InternalACLProvider)this.client.getAclProvider());
    }
}

