/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ByteBufferOutputStream
extends OutputStream {
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    protected ByteBuffer buf;

    public ByteBufferOutputStream(int capacity) {
        this(capacity, false);
    }

    public ByteBufferOutputStream(int capacity, boolean useDirectByteBuffer) {
        this(ByteBufferOutputStream.allocate(capacity, useDirectByteBuffer));
    }

    public ByteBufferOutputStream(ByteBuffer bb) {
        this.buf = bb;
        this.buf.clear();
    }

    public int size() {
        return this.buf.position();
    }

    private static ByteBuffer allocate(int capacity, boolean useDirectByteBuffer) {
        if (capacity > 0x7FFFFFF7) {
            throw new BufferOverflowException();
        }
        return useDirectByteBuffer ? ByteBuffer.allocateDirect(capacity) : ByteBuffer.allocate(capacity);
    }

    public ByteBuffer getByteBuffer() {
        this.buf.flip();
        return this.buf;
    }

    private void checkSizeAndGrow(int extra) {
        long capacityNeeded = (long)this.buf.position() + (long)extra;
        if (capacityNeeded > (long)this.buf.limit()) {
            if (capacityNeeded > 0x7FFFFFF7L) {
                throw new BufferOverflowException();
            }
            long nextCapacity = Math.min((long)this.buf.capacity() * 2L, 0x7FFFFFF7L);
            nextCapacity = Math.max(nextCapacity, capacityNeeded);
            ByteBuffer newBuf = ByteBufferOutputStream.allocate((int)nextCapacity, this.buf.isDirect());
            this.buf.flip();
            newBuf.put(this.buf);
            this.buf = newBuf;
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.checkSizeAndGrow(1);
        this.buf.put((byte)b);
    }

    public synchronized void writeTo(OutputStream out) throws IOException {
        WritableByteChannel channel = Channels.newChannel(out);
        ByteBuffer bb = this.buf.duplicate();
        bb.flip();
        channel.write(bb);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.checkSizeAndGrow(b.length);
        this.buf.put(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.checkSizeAndGrow(len);
        this.buf.put(b, off, len);
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }

    public byte[] toByteArray(int offset, int length) {
        ByteBuffer bb = this.buf.duplicate();
        bb.flip();
        byte[] chunk = new byte[length];
        bb.position(offset);
        bb.get(chunk, 0, length);
        return chunk;
    }
}

