/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.QuotaProtos;
import org.apache.hadoop.hbase.quotas.AverageIntervalRateLimiter;
import org.apache.hadoop.hbase.quotas.FixedIntervalRateLimiter;
import org.apache.hadoop.hbase.quotas.NoopQuotaLimiter;
import org.apache.hadoop.hbase.quotas.QuotaLimiter;
import org.apache.hadoop.hbase.quotas.RateLimiter;
import org.apache.hadoop.hbase.quotas.ThrottlingException;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class TimeBasedLimiter
implements QuotaLimiter {
    private static final Configuration conf = HBaseConfiguration.create();
    private RateLimiter reqsLimiter = null;
    private RateLimiter reqSizeLimiter = null;
    private RateLimiter writeReqsLimiter = null;
    private RateLimiter writeSizeLimiter = null;
    private RateLimiter readReqsLimiter = null;
    private RateLimiter readSizeLimiter = null;

    private TimeBasedLimiter() {
        if (FixedIntervalRateLimiter.class.getName().equals(conf.getClass("hbase.quota.rate.limiter", AverageIntervalRateLimiter.class).getName())) {
            this.reqsLimiter = new FixedIntervalRateLimiter();
            this.reqSizeLimiter = new FixedIntervalRateLimiter();
            this.writeReqsLimiter = new FixedIntervalRateLimiter();
            this.writeSizeLimiter = new FixedIntervalRateLimiter();
            this.readReqsLimiter = new FixedIntervalRateLimiter();
            this.readSizeLimiter = new FixedIntervalRateLimiter();
        } else {
            this.reqsLimiter = new AverageIntervalRateLimiter();
            this.reqSizeLimiter = new AverageIntervalRateLimiter();
            this.writeReqsLimiter = new AverageIntervalRateLimiter();
            this.writeSizeLimiter = new AverageIntervalRateLimiter();
            this.readReqsLimiter = new AverageIntervalRateLimiter();
            this.readSizeLimiter = new AverageIntervalRateLimiter();
        }
    }

    static QuotaLimiter fromThrottle(QuotaProtos.Throttle throttle) {
        TimeBasedLimiter limiter = new TimeBasedLimiter();
        boolean isBypass = true;
        if (throttle.hasReqNum()) {
            TimeBasedLimiter.setFromTimedQuota(limiter.reqsLimiter, throttle.getReqNum());
            isBypass = false;
        }
        if (throttle.hasReqSize()) {
            TimeBasedLimiter.setFromTimedQuota(limiter.reqSizeLimiter, throttle.getReqSize());
            isBypass = false;
        }
        if (throttle.hasWriteNum()) {
            TimeBasedLimiter.setFromTimedQuota(limiter.writeReqsLimiter, throttle.getWriteNum());
            isBypass = false;
        }
        if (throttle.hasWriteSize()) {
            TimeBasedLimiter.setFromTimedQuota(limiter.writeSizeLimiter, throttle.getWriteSize());
            isBypass = false;
        }
        if (throttle.hasReadNum()) {
            TimeBasedLimiter.setFromTimedQuota(limiter.readReqsLimiter, throttle.getReadNum());
            isBypass = false;
        }
        if (throttle.hasReadSize()) {
            TimeBasedLimiter.setFromTimedQuota(limiter.readSizeLimiter, throttle.getReadSize());
            isBypass = false;
        }
        return isBypass ? NoopQuotaLimiter.get() : limiter;
    }

    public void update(TimeBasedLimiter other) {
        this.reqsLimiter.update(other.reqsLimiter);
        this.reqSizeLimiter.update(other.reqSizeLimiter);
        this.writeReqsLimiter.update(other.writeReqsLimiter);
        this.writeSizeLimiter.update(other.writeSizeLimiter);
        this.readReqsLimiter.update(other.readReqsLimiter);
        this.readSizeLimiter.update(other.readSizeLimiter);
    }

    private static void setFromTimedQuota(RateLimiter limiter, QuotaProtos.TimedQuota timedQuota) {
        limiter.set(timedQuota.getSoftLimit(), ProtobufUtil.toTimeUnit((HBaseProtos.TimeUnit)timedQuota.getTimeUnit()));
    }

    @Override
    public void checkQuota(long writeSize, long readSize) throws ThrottlingException {
        if (!this.reqsLimiter.canExecute()) {
            ThrottlingException.throwNumRequestsExceeded((long)this.reqsLimiter.waitInterval());
        }
        if (!this.reqSizeLimiter.canExecute(writeSize + readSize)) {
            ThrottlingException.throwRequestSizeExceeded((long)this.reqSizeLimiter.waitInterval(writeSize + readSize));
        }
        if (writeSize > 0L) {
            if (!this.writeReqsLimiter.canExecute()) {
                ThrottlingException.throwNumWriteRequestsExceeded((long)this.writeReqsLimiter.waitInterval());
            }
            if (!this.writeSizeLimiter.canExecute(writeSize)) {
                ThrottlingException.throwWriteSizeExceeded((long)this.writeSizeLimiter.waitInterval(writeSize));
            }
        }
        if (readSize > 0L) {
            if (!this.readReqsLimiter.canExecute()) {
                ThrottlingException.throwNumReadRequestsExceeded((long)this.readReqsLimiter.waitInterval());
            }
            if (!this.readSizeLimiter.canExecute(readSize)) {
                ThrottlingException.throwReadSizeExceeded((long)this.readSizeLimiter.waitInterval(readSize));
            }
        }
    }

    @Override
    public void grabQuota(long writeSize, long readSize) {
        assert (writeSize != 0L || readSize != 0L);
        this.reqsLimiter.consume(1L);
        this.reqSizeLimiter.consume(writeSize + readSize);
        if (writeSize > 0L) {
            this.writeReqsLimiter.consume(1L);
            this.writeSizeLimiter.consume(writeSize);
        }
        if (readSize > 0L) {
            this.readReqsLimiter.consume(1L);
            this.readSizeLimiter.consume(readSize);
        }
    }

    @Override
    public void consumeWrite(long size) {
        this.reqSizeLimiter.consume(size);
        this.writeSizeLimiter.consume(size);
    }

    @Override
    public void consumeRead(long size) {
        this.reqSizeLimiter.consume(size);
        this.readSizeLimiter.consume(size);
    }

    @Override
    public boolean isBypass() {
        return false;
    }

    @Override
    public long getWriteAvailable() {
        return this.writeSizeLimiter.getAvailable();
    }

    @Override
    public long getReadAvailable() {
        return this.readSizeLimiter.getAvailable();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TimeBasedLimiter(");
        if (!this.reqsLimiter.isBypass()) {
            builder.append("reqs=" + this.reqsLimiter);
        }
        if (!this.reqSizeLimiter.isBypass()) {
            builder.append(" resSize=" + this.reqSizeLimiter);
        }
        if (!this.writeReqsLimiter.isBypass()) {
            builder.append(" writeReqs=" + this.writeReqsLimiter);
        }
        if (!this.writeSizeLimiter.isBypass()) {
            builder.append(" writeSize=" + this.writeSizeLimiter);
        }
        if (!this.readReqsLimiter.isBypass()) {
            builder.append(" readReqs=" + this.readReqsLimiter);
        }
        if (!this.readSizeLimiter.isBypass()) {
            builder.append(" readSize=" + this.readSizeLimiter);
        }
        builder.append(')');
        return builder.toString();
    }
}

