/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.configuration;

import java.io.Serializable;
import org.apache.ignite.configuration.MemoryPolicyConfiguration;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.U;

@Deprecated
public class MemoryConfiguration
implements Serializable {
    private static final long serialVersionUID = 0L;
    public static final long DFLT_MEMORY_POLICY_INITIAL_SIZE = 0x10000000L;
    private static final double DFLT_MEMORY_POLICY_FRACTION = 0.2;
    public static final long DFLT_MEMORY_POLICY_MAX_SIZE = Math.max((long)(0.2 * (double)U.getTotalMemoryAvailable()), 0x10000000L);
    private static final long DFLT_SYS_CACHE_INIT_SIZE = 0x2800000L;
    private static final long DFLT_SYS_CACHE_MAX_SIZE = 0x6400000L;
    public static final int DFLT_PAGE_SIZE = 4096;
    public static final String DFLT_MEM_PLC_DEFAULT_NAME = "default";
    private long sysCacheInitSize = 0x2800000L;
    private long sysCacheMaxSize = 0x6400000L;
    private int pageSize;
    private int concLvl;
    private String dfltMemPlcName = "default";
    private long dfltMemPlcSize = DFLT_MEMORY_POLICY_MAX_SIZE;
    private MemoryPolicyConfiguration[] memPlcs;

    public long getSystemCacheInitialSize() {
        return this.sysCacheInitSize;
    }

    public MemoryConfiguration setSystemCacheInitialSize(long sysCacheInitSize) {
        A.ensure(this.sysCacheMaxSize > 0L, "System cache initial size can not be less zero.");
        this.sysCacheInitSize = sysCacheInitSize;
        return this;
    }

    public long getSystemCacheMaxSize() {
        return this.sysCacheMaxSize;
    }

    public MemoryConfiguration setSystemCacheMaxSize(long sysCacheMaxSize) {
        A.ensure(sysCacheMaxSize > 0L, "System cache max size can not be less zero.");
        this.sysCacheMaxSize = sysCacheMaxSize;
        return this;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public MemoryConfiguration setPageSize(int pageSize) {
        A.ensure(pageSize >= 1024 && pageSize <= 16384, "Page size must be between 1kB and 16kB.");
        A.ensure(U.isPow2(pageSize), "Page size must be a power of 2.");
        this.pageSize = pageSize;
        return this;
    }

    public MemoryPolicyConfiguration[] getMemoryPolicies() {
        return this.memPlcs;
    }

    public MemoryConfiguration setMemoryPolicies(MemoryPolicyConfiguration ... memPlcs) {
        this.memPlcs = memPlcs;
        return this;
    }

    public MemoryPolicyConfiguration createDefaultPolicyConfig() {
        MemoryPolicyConfiguration memPlc = new MemoryPolicyConfiguration();
        long maxSize = this.dfltMemPlcSize;
        if (maxSize < 0x10000000L) {
            memPlc.setInitialSize(maxSize);
        } else {
            memPlc.setInitialSize(0x10000000L);
        }
        memPlc.setMaxSize(maxSize);
        return memPlc;
    }

    public int getConcurrencyLevel() {
        return this.concLvl;
    }

    public MemoryConfiguration setConcurrencyLevel(int concLvl) {
        this.concLvl = concLvl;
        return this;
    }

    public long getDefaultMemoryPolicySize() {
        return this.dfltMemPlcSize;
    }

    public MemoryConfiguration setDefaultMemoryPolicySize(long dfltMemPlcSize) {
        this.dfltMemPlcSize = dfltMemPlcSize;
        return this;
    }

    public String getDefaultMemoryPolicyName() {
        return this.dfltMemPlcName;
    }

    public MemoryConfiguration setDefaultMemoryPolicyName(String dfltMemPlcName) {
        this.dfltMemPlcName = dfltMemPlcName;
        return this;
    }
}

