/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.binary;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.binary.BinaryBasicIdMapper;
import org.apache.ignite.binary.BinaryBasicNameMapper;
import org.apache.ignite.binary.BinaryIdMapper;
import org.apache.ignite.binary.BinaryInvalidTypeException;
import org.apache.ignite.binary.BinaryNameMapper;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryReflectiveSerializer;
import org.apache.ignite.binary.BinarySerializer;
import org.apache.ignite.binary.BinaryType;
import org.apache.ignite.binary.BinaryTypeConfiguration;
import org.apache.ignite.cache.CacheKeyConfiguration;
import org.apache.ignite.cache.affinity.AffinityKey;
import org.apache.ignite.cache.affinity.AffinityKeyMapped;
import org.apache.ignite.configuration.BinaryConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.igfs.IgfsPath;
import org.apache.ignite.internal.DuplicateTypeIdException;
import org.apache.ignite.internal.binary.BinaryArrayIdentityResolver;
import org.apache.ignite.internal.binary.BinaryClassDescriptor;
import org.apache.ignite.internal.binary.BinaryEnumObjectImpl;
import org.apache.ignite.internal.binary.BinaryFieldImpl;
import org.apache.ignite.internal.binary.BinaryFieldMetadata;
import org.apache.ignite.internal.binary.BinaryIdentityResolver;
import org.apache.ignite.internal.binary.BinaryInternalMapper;
import org.apache.ignite.internal.binary.BinaryMarshaller;
import org.apache.ignite.internal.binary.BinaryMetadata;
import org.apache.ignite.internal.binary.BinaryMetadataHandler;
import org.apache.ignite.internal.binary.BinaryObjectImpl;
import org.apache.ignite.internal.binary.BinaryObjectOffheapImpl;
import org.apache.ignite.internal.binary.BinarySchema;
import org.apache.ignite.internal.binary.BinarySchemaRegistry;
import org.apache.ignite.internal.binary.BinaryTreeMap;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.marshaller.optimized.OptimizedMarshaller;
import org.apache.ignite.internal.processors.cache.binary.BinaryMetadataKey;
import org.apache.ignite.internal.processors.closure.GridClosureProcessor;
import org.apache.ignite.internal.processors.datastructures.CollocatedQueueItemKey;
import org.apache.ignite.internal.processors.datastructures.CollocatedSetItemKey;
import org.apache.ignite.internal.processors.igfs.IgfsBlockKey;
import org.apache.ignite.internal.processors.igfs.IgfsDirectoryInfo;
import org.apache.ignite.internal.processors.igfs.IgfsFileAffinityRange;
import org.apache.ignite.internal.processors.igfs.IgfsFileInfo;
import org.apache.ignite.internal.processors.igfs.IgfsFileMap;
import org.apache.ignite.internal.processors.igfs.IgfsListingEntry;
import org.apache.ignite.internal.processors.igfs.client.IgfsClientAffinityCallable;
import org.apache.ignite.internal.processors.igfs.client.IgfsClientDeleteCallable;
import org.apache.ignite.internal.processors.igfs.client.IgfsClientExistsCallable;
import org.apache.ignite.internal.processors.igfs.client.IgfsClientInfoCallable;
import org.apache.ignite.internal.processors.igfs.client.IgfsClientListFilesCallable;
import org.apache.ignite.internal.processors.igfs.client.IgfsClientListPathsCallable;
import org.apache.ignite.internal.processors.igfs.client.IgfsClientMkdirsCallable;
import org.apache.ignite.internal.processors.igfs.client.IgfsClientRenameCallable;
import org.apache.ignite.internal.processors.igfs.client.IgfsClientSetTimesCallable;
import org.apache.ignite.internal.processors.igfs.client.IgfsClientSizeCallable;
import org.apache.ignite.internal.processors.igfs.client.IgfsClientSummaryCallable;
import org.apache.ignite.internal.processors.igfs.client.IgfsClientUpdateCallable;
import org.apache.ignite.internal.processors.igfs.client.meta.IgfsClientMetaIdsForPathCallable;
import org.apache.ignite.internal.processors.igfs.client.meta.IgfsClientMetaInfoForPathCallable;
import org.apache.ignite.internal.processors.igfs.client.meta.IgfsClientMetaUnlockCallable;
import org.apache.ignite.internal.processors.igfs.data.IgfsDataPutProcessor;
import org.apache.ignite.internal.processors.igfs.meta.IgfsMetaDirectoryCreateProcessor;
import org.apache.ignite.internal.processors.igfs.meta.IgfsMetaDirectoryListingAddProcessor;
import org.apache.ignite.internal.processors.igfs.meta.IgfsMetaDirectoryListingRemoveProcessor;
import org.apache.ignite.internal.processors.igfs.meta.IgfsMetaDirectoryListingRenameProcessor;
import org.apache.ignite.internal.processors.igfs.meta.IgfsMetaDirectoryListingReplaceProcessor;
import org.apache.ignite.internal.processors.igfs.meta.IgfsMetaFileCreateProcessor;
import org.apache.ignite.internal.processors.igfs.meta.IgfsMetaFileLockProcessor;
import org.apache.ignite.internal.processors.igfs.meta.IgfsMetaFileRangeDeleteProcessor;
import org.apache.ignite.internal.processors.igfs.meta.IgfsMetaFileRangeUpdateProcessor;
import org.apache.ignite.internal.processors.igfs.meta.IgfsMetaFileReserveSpaceProcessor;
import org.apache.ignite.internal.processors.igfs.meta.IgfsMetaFileUnlockProcessor;
import org.apache.ignite.internal.processors.igfs.meta.IgfsMetaUpdatePropertiesProcessor;
import org.apache.ignite.internal.processors.igfs.meta.IgfsMetaUpdateTimesProcessor;
import org.apache.ignite.internal.processors.platform.PlatformJavaObjectFactoryProxy;
import org.apache.ignite.internal.processors.platform.websession.PlatformDotNetSessionData;
import org.apache.ignite.internal.processors.platform.websession.PlatformDotNetSessionLockResult;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.lang.GridMapEntry;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.marshaller.MarshallerContext;
import org.apache.ignite.marshaller.MarshallerUtils;
import org.jetbrains.annotations.Nullable;

public class BinaryContext {
    private static final ClassLoader sysLdr = U.gridClassLoader();
    private static final BinaryInternalMapper DFLT_MAPPER = new BinaryInternalMapper(new BinaryBasicNameMapper(false), new BinaryBasicIdMapper(true), false);
    static final BinaryInternalMapper SIMPLE_NAME_LOWER_CASE_MAPPER = new BinaryInternalMapper(new BinaryBasicNameMapper(true), new BinaryBasicIdMapper(true), false);
    private static final Set<String> BINARYLIZABLE_SYS_CLSS;
    private final ConcurrentMap<Class<?>, BinaryClassDescriptor> descByCls = new ConcurrentHashMap();
    private final Map<Integer, BinaryClassDescriptor> predefinedTypes = new HashMap<Integer, BinaryClassDescriptor>();
    private final Map<String, Integer> predefinedTypeNames = new HashMap<String, Integer>();
    private final Map<Class<? extends Collection>, Byte> colTypes = new HashMap<Class<? extends Collection>, Byte>();
    private final Map<Class<? extends Map>, Byte> mapTypes = new HashMap<Class<? extends Map>, Byte>();
    private final ConcurrentMap<Integer, BinaryInternalMapper> typeId2Mapper = new ConcurrentHashMap<Integer, BinaryInternalMapper>(0);
    private final ConcurrentMap<Integer, String> affKeyFieldNames = new ConcurrentHashMap<Integer, String>(0);
    private final ConcurrentMap<String, BinaryInternalMapper> cls2Mappers = new ConcurrentHashMap<String, BinaryInternalMapper>(0);
    private final ConcurrentMap<Integer, BinaryIdentityResolver> identities = new ConcurrentHashMap<Integer, BinaryIdentityResolver>(0);
    private BinaryMetadataHandler metaHnd;
    private BinaryMarshaller marsh;
    private MarshallerContext marshCtx;
    private IgniteConfiguration igniteCfg;
    private IgniteLogger log;
    private final OptimizedMarshaller optmMarsh = new OptimizedMarshaller(false);
    private boolean compactFooter;
    private volatile Map<Integer, BinarySchemaRegistry> schemas;

    public BinaryContext(BinaryMetadataHandler metaHnd, IgniteConfiguration igniteCfg, IgniteLogger log) {
        assert (metaHnd != null);
        assert (igniteCfg != null);
        MarshallerUtils.setNodeName(this.optmMarsh, igniteCfg.getIgniteInstanceName());
        this.metaHnd = metaHnd;
        this.igniteCfg = igniteCfg;
        this.log = log;
        this.colTypes.put(ArrayList.class, (byte)1);
        this.colTypes.put(LinkedList.class, (byte)2);
        this.colTypes.put(BinaryUtils.SINGLETON_LIST_CLS, (byte)5);
        this.colTypes.put(HashSet.class, (byte)3);
        this.colTypes.put(LinkedHashSet.class, (byte)4);
        this.mapTypes.put(HashMap.class, (byte)1);
        this.mapTypes.put(LinkedHashMap.class, (byte)2);
        this.registerPredefinedType(Object.class, -1);
        this.registerPredefinedType(Byte.class, 1);
        this.registerPredefinedType(Boolean.class, 8);
        this.registerPredefinedType(Short.class, 2);
        this.registerPredefinedType(Character.class, 7);
        this.registerPredefinedType(Integer.class, 3);
        this.registerPredefinedType(Long.class, 4);
        this.registerPredefinedType(Float.class, 5);
        this.registerPredefinedType(Double.class, 6);
        this.registerPredefinedType(String.class, 9);
        this.registerPredefinedType(BigDecimal.class, 30);
        this.registerPredefinedType(Date.class, 11);
        this.registerPredefinedType(Timestamp.class, 33);
        this.registerPredefinedType(Time.class, 36);
        this.registerPredefinedType(UUID.class, 10);
        this.registerPredefinedType(byte[].class, 12);
        this.registerPredefinedType(short[].class, 13);
        this.registerPredefinedType(int[].class, 14);
        this.registerPredefinedType(long[].class, 15);
        this.registerPredefinedType(float[].class, 16);
        this.registerPredefinedType(double[].class, 17);
        this.registerPredefinedType(char[].class, 18);
        this.registerPredefinedType(boolean[].class, 19);
        this.registerPredefinedType(BigDecimal[].class, 31);
        this.registerPredefinedType(String[].class, 20);
        this.registerPredefinedType(UUID[].class, 21);
        this.registerPredefinedType(Date[].class, 22);
        this.registerPredefinedType(Timestamp[].class, 34);
        this.registerPredefinedType(Time[].class, 37);
        this.registerPredefinedType(Object[].class, 23);
        this.registerPredefinedType(ArrayList.class, 0);
        this.registerPredefinedType(LinkedList.class, 0);
        this.registerPredefinedType(HashSet.class, 0);
        this.registerPredefinedType(LinkedHashSet.class, 0);
        this.registerPredefinedType(HashMap.class, 0);
        this.registerPredefinedType(LinkedHashMap.class, 0);
        this.registerPredefinedType(AffinityKey.class, 0, BinaryContext.affinityFieldName(AffinityKey.class), true);
        this.registerPredefinedType(CollocatedSetItemKey.class, 0, BinaryContext.affinityFieldName(CollocatedSetItemKey.class), true);
        this.registerPredefinedType(CollocatedQueueItemKey.class, 0, BinaryContext.affinityFieldName(CollocatedQueueItemKey.class), true);
        this.registerPredefinedType(GridMapEntry.class, 60);
        this.registerPredefinedType(IgniteBiTuple.class, 61);
        this.registerPredefinedType(T2.class, 62);
        this.registerPredefinedType(IgniteUuid.class, 63);
        this.registerPredefinedType(PlatformJavaObjectFactoryProxy.class, 99);
        this.registerPredefinedType(BinaryObjectImpl.class, 0);
        this.registerPredefinedType(BinaryObjectOffheapImpl.class, 0);
        this.registerPredefinedType(BinaryMetadataKey.class, 0);
        this.registerPredefinedType(BinaryMetadata.class, 0);
        this.registerPredefinedType(BinaryEnumObjectImpl.class, 0);
        this.registerPredefinedType(BinaryTreeMap.class, 0);
        this.registerPredefinedType(PlatformDotNetSessionData.class, 0);
        this.registerPredefinedType(PlatformDotNetSessionLockResult.class, 0);
    }

    public IgniteLogger log() {
        return this.log;
    }

    public BinaryMarshaller marshaller() {
        return this.marsh;
    }

    public boolean mustDeserialize(Class cls) {
        BinaryClassDescriptor desc = (BinaryClassDescriptor)this.descByCls.get(cls);
        if (desc == null) {
            if (BinaryUtils.wrapTrees() && (cls == TreeMap.class || cls == TreeSet.class)) {
                return false;
            }
            return this.marshCtx.isSystemType(cls.getName()) || this.serializerForClass(cls) == null || QueryUtils.isGeometryClass(cls);
        }
        return desc.useOptimizedMarshaller();
    }

    public IgniteConfiguration configuration() {
        return this.igniteCfg;
    }

    public void configure(BinaryMarshaller marsh, IgniteConfiguration cfg) throws BinaryObjectException {
        if (marsh == null) {
            return;
        }
        this.marsh = marsh;
        this.marshCtx = marsh.getContext();
        BinaryConfiguration binaryCfg = cfg.getBinaryConfiguration();
        if (binaryCfg == null) {
            binaryCfg = new BinaryConfiguration();
        }
        assert (this.marshCtx != null);
        this.optmMarsh.setContext(this.marshCtx);
        this.configure(binaryCfg.getNameMapper(), binaryCfg.getIdMapper(), binaryCfg.getSerializer(), binaryCfg.getTypeConfigurations());
        this.compactFooter = binaryCfg.isCompactFooter();
    }

    private void configure(BinaryNameMapper globalNameMapper, BinaryIdMapper globalIdMapper, BinarySerializer globalSerializer, Collection<BinaryTypeConfiguration> typeCfgs) throws BinaryObjectException {
        TypeDescriptors descs = new TypeDescriptors();
        HashMap<String, String> affFields = new HashMap<String, String>();
        if (!F.isEmpty(this.igniteCfg.getCacheKeyConfiguration())) {
            for (CacheKeyConfiguration keyCfg : this.igniteCfg.getCacheKeyConfiguration()) {
                affFields.put(keyCfg.getTypeName(), keyCfg.getAffinityKeyFieldName());
            }
        }
        if (typeCfgs != null) {
            for (BinaryTypeConfiguration typeCfg : typeCfgs) {
                String clsName = typeCfg.getTypeName();
                if (clsName == null) {
                    throw new BinaryObjectException("Class name is required for binary type configuration.");
                }
                BinaryIdMapper idMapper = U.firstNotNull(typeCfg.getIdMapper(), globalIdMapper);
                BinaryNameMapper nameMapper = U.firstNotNull(typeCfg.getNameMapper(), globalNameMapper);
                BinarySerializer serializer = U.firstNotNull(typeCfg.getSerializer(), globalSerializer);
                BinaryArrayIdentityResolver identity = BinaryArrayIdentityResolver.instance();
                BinaryInternalMapper mapper = BinaryContext.resolveMapper(nameMapper, idMapper);
                if (clsName.endsWith(".*")) {
                    String pkgName = clsName.substring(0, clsName.length() - 2);
                    for (String clsName0 : BinaryContext.classesInPackage(pkgName)) {
                        String affField = (String)affFields.remove(clsName0);
                        descs.add(clsName0, mapper, serializer, identity, affField, typeCfg.isEnum(), typeCfg.getEnumValues(), true);
                    }
                    continue;
                }
                String affField = (String)affFields.remove(clsName);
                descs.add(clsName, mapper, serializer, identity, affField, typeCfg.isEnum(), typeCfg.getEnumValues(), false);
            }
        }
        for (TypeDescriptor desc : descs.descriptors()) {
            this.registerUserType(desc.clsName, desc.mapper, desc.serializer, desc.identity, desc.affKeyFieldName, desc.isEnum, desc.enumMap);
        }
        BinaryInternalMapper globalMapper = BinaryContext.resolveMapper(globalNameMapper, globalIdMapper);
        for (Map.Entry entry : affFields.entrySet()) {
            String typeName = (String)entry.getKey();
            int typeId = globalMapper.typeId(typeName);
            this.affKeyFieldNames.putIfAbsent(typeId, (String)entry.getValue());
        }
    }

    private static BinaryInternalMapper resolveMapper(BinaryNameMapper nameMapper, BinaryIdMapper idMapper) {
        if ((nameMapper == null || DFLT_MAPPER.nameMapper().equals(nameMapper)) && (idMapper == null || DFLT_MAPPER.idMapper().equals(idMapper))) {
            return DFLT_MAPPER;
        }
        if (nameMapper != null && nameMapper instanceof BinaryBasicNameMapper && ((BinaryBasicNameMapper)nameMapper).isSimpleName() && idMapper != null && idMapper instanceof BinaryBasicIdMapper && ((BinaryBasicIdMapper)idMapper).isLowerCase()) {
            return SIMPLE_NAME_LOWER_CASE_MAPPER;
        }
        if (nameMapper == null) {
            nameMapper = DFLT_MAPPER.nameMapper();
        }
        if (idMapper == null) {
            idMapper = DFLT_MAPPER.idMapper();
        }
        return new BinaryInternalMapper(nameMapper, idMapper, true);
    }

    public static BinaryInternalMapper defaultMapper() {
        return DFLT_MAPPER;
    }

    public static BinaryIdMapper defaultIdMapper() {
        return DFLT_MAPPER.idMapper();
    }

    public static BinaryNameMapper defaultNameMapper() {
        return DFLT_MAPPER.nameMapper();
    }

    private static Iterable<String> classesInPackage(String pkgName) {
        URL[] urls;
        assert (pkgName != null);
        ArrayList<String> clsNames = new ArrayList<String>();
        ClassLoader ldr = U.gridClassLoader();
        String pkgPath = pkgName.replaceAll("\\.", "/");
        for (URL url : urls = IgniteUtils.classLoaderUrls(ldr)) {
            String proto = url.getProtocol().toLowerCase();
            if (!"file".equals(proto)) continue;
            try {
                File cpElement = new File(url.toURI());
                if (cpElement.isDirectory()) {
                    File pkgDir = new File(cpElement, pkgPath);
                    if (!pkgDir.isDirectory()) continue;
                    for (File file : pkgDir.listFiles()) {
                        String fileName = file.getName();
                        if (!file.isFile() || !fileName.toLowerCase().endsWith(".class")) continue;
                        clsNames.add(pkgName + '.' + fileName.substring(0, fileName.length() - 6));
                    }
                    continue;
                }
                if (!cpElement.isFile()) continue;
                try {
                    JarFile jar = new JarFile(cpElement);
                    Enumeration<JarEntry> entries = jar.entries();
                    while (entries.hasMoreElements()) {
                        String clsName;
                        String entry = entries.nextElement().getName();
                        if (!entry.startsWith(pkgPath) || !entry.endsWith(".class") || (clsName = entry.substring(pkgPath.length() + 1, entry.length() - 6)).contains("/") || clsName.contains("\\")) continue;
                        clsNames.add(pkgName + '.' + clsName);
                    }
                }
                catch (IOException iOException) {
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return clsNames;
    }

    public BinaryClassDescriptor descriptorForClass(Class<?> cls, boolean deserialize) throws BinaryObjectException {
        assert (cls != null);
        BinaryClassDescriptor desc = (BinaryClassDescriptor)this.descByCls.get(cls);
        if (desc == null) {
            desc = this.registerClassDescriptor(cls, deserialize);
        } else if (!desc.registered()) {
            if (!desc.userType()) {
                BinaryClassDescriptor desc0 = new BinaryClassDescriptor(this, desc.describedClass(), false, desc.typeId(), desc.typeName(), desc.affFieldKeyName(), desc.mapper(), desc.initialSerializer(), false, true);
                if (this.descByCls.replace(cls, desc, desc0)) {
                    Set<BinarySchema> schemas = desc0.schema() != null ? Collections.singleton(desc.schema()) : null;
                    BinaryMetadata meta = new BinaryMetadata(desc0.typeId(), desc0.typeName(), desc0.fieldsMeta(), desc0.affFieldKeyName(), schemas, desc0.isEnum(), cls.isEnum() ? BinaryContext.enumMap(cls) : null);
                    this.metaHnd.addMeta(desc0.typeId(), meta.wrap(this));
                    return desc0;
                }
            } else {
                desc = this.registerUserClassDescriptor(desc);
            }
        }
        return desc;
    }

    public BinaryClassDescriptor descriptorForTypeId(boolean userType, int typeId, ClassLoader ldr, boolean deserialize) {
        Class cls;
        assert (typeId != 0);
        BinaryClassDescriptor desc = this.predefinedTypes.get(typeId);
        if (desc != null) {
            return desc;
        }
        if (ldr == null) {
            ldr = sysLdr;
        }
        try {
            cls = this.marshCtx.getClass(typeId, ldr);
            desc = (BinaryClassDescriptor)this.descByCls.get(cls);
        }
        catch (ClassNotFoundException e) {
            if (userType && !ldr.equals(sysLdr) && (desc = this.descriptorForTypeId(true, typeId, sysLdr, deserialize)) != null) {
                return desc;
            }
            throw new BinaryInvalidTypeException(e);
        }
        catch (IgniteCheckedException e) {
            if (userType && !ldr.equals(sysLdr) && (desc = this.descriptorForTypeId(true, typeId, sysLdr, deserialize)) != null) {
                return desc;
            }
            throw new BinaryObjectException("Failed resolve class for ID: " + typeId, e);
        }
        if (desc == null) {
            desc = this.registerClassDescriptor(cls, deserialize);
            assert (desc.typeId() == typeId) : "Duplicate typeId [typeId=" + typeId + ", cls=" + cls + ", desc=" + desc + "]";
        }
        return desc;
    }

    private BinaryClassDescriptor registerClassDescriptor(Class<?> cls, boolean deserialize) {
        BinaryClassDescriptor desc;
        String clsName = cls.getName();
        if (this.marshCtx.isSystemType(clsName)) {
            BinaryClassDescriptor old;
            BinaryReflectiveSerializer serializer = null;
            if (BINARYLIZABLE_SYS_CLSS.contains(clsName)) {
                serializer = new BinaryReflectiveSerializer();
            }
            if ((old = this.descByCls.putIfAbsent(cls, desc = new BinaryClassDescriptor(this, cls, false, clsName.hashCode(), clsName, null, SIMPLE_NAME_LOWER_CASE_MAPPER, serializer, false, true))) != null) {
                desc = old;
            }
        } else {
            desc = this.registerUserClassDescriptor(cls, deserialize);
        }
        return desc;
    }

    private BinaryClassDescriptor registerUserClassDescriptor(Class<?> cls, boolean deserialize) {
        String clsName = cls.getName();
        BinaryInternalMapper mapper = this.userTypeMapper(clsName);
        String typeName = mapper.typeName(clsName);
        int typeId = mapper.typeId(clsName);
        boolean registered = this.registerUserClassName(typeId, cls.getName());
        BinarySerializer serializer = this.serializerForClass(cls);
        String affFieldName = BinaryContext.affinityFieldName(cls);
        BinaryClassDescriptor desc = new BinaryClassDescriptor(this, cls, true, typeId, typeName, affFieldName, mapper, serializer, true, registered);
        if (!deserialize) {
            this.metaHnd.addMeta(typeId, new BinaryMetadata(typeId, typeName, desc.fieldsMeta(), affFieldName, null, desc.isEnum(), cls.isEnum() ? BinaryContext.enumMap(cls) : null).wrap(this));
        }
        this.descByCls.put(cls, desc);
        this.typeId2Mapper.putIfAbsent(typeId, mapper);
        return desc;
    }

    private BinaryClassDescriptor registerUserClassDescriptor(BinaryClassDescriptor desc) {
        boolean registered = this.registerUserClassName(desc.typeId(), desc.describedClass().getName());
        if (registered) {
            BinarySerializer serializer = desc.initialSerializer();
            if (serializer == null) {
                serializer = this.serializerForClass(desc.describedClass());
            }
            desc = new BinaryClassDescriptor(this, desc.describedClass(), true, desc.typeId(), desc.typeName(), desc.affFieldKeyName(), desc.mapper(), serializer, true, true);
            this.descByCls.put(desc.describedClass(), desc);
        }
        return desc;
    }

    @Nullable
    private BinarySerializer serializerForClass(Class cls) {
        BinarySerializer serializer = this.defaultSerializer();
        if (serializer == null && BinaryContext.canUseReflectiveSerializer(cls)) {
            serializer = new BinaryReflectiveSerializer();
        }
        return serializer;
    }

    private BinarySerializer defaultSerializer() {
        BinaryConfiguration binCfg = this.igniteCfg.getBinaryConfiguration();
        return binCfg != null ? binCfg.getSerializer() : null;
    }

    public byte collectionType(Class<? extends Collection> cls) {
        assert (cls != null);
        Byte type = this.colTypes.get(cls);
        if (type != null) {
            return type;
        }
        return Set.class.isAssignableFrom(cls) ? (byte)-1 : 0;
    }

    public byte mapType(Class<? extends Map> cls) {
        assert (cls != null);
        Byte type = this.mapTypes.get(cls);
        return type != null ? type : (byte)0;
    }

    public int typeId(String typeName) {
        Integer id = this.predefinedTypeNames.get(SIMPLE_NAME_LOWER_CASE_MAPPER.typeName(typeName));
        if (id != null) {
            return id;
        }
        if (this.marshCtx.isSystemType(typeName)) {
            return typeName.hashCode();
        }
        BinaryInternalMapper mapper = this.userTypeMapper(typeName);
        return mapper.typeId(typeName);
    }

    public int fieldId(int typeId, String fieldName) {
        BinaryInternalMapper mapper = this.userTypeMapper(typeId);
        return mapper.fieldId(typeId, fieldName);
    }

    BinaryInternalMapper userTypeMapper(int typeId) {
        BinaryInternalMapper mapper = (BinaryInternalMapper)this.typeId2Mapper.get(typeId);
        return mapper != null ? mapper : SIMPLE_NAME_LOWER_CASE_MAPPER;
    }

    BinaryInternalMapper userTypeMapper(String clsName) {
        BinaryInternalMapper mapper = (BinaryInternalMapper)this.cls2Mappers.get(clsName);
        if (mapper != null) {
            return mapper;
        }
        mapper = BinaryContext.resolveMapper(clsName, this.igniteCfg.getBinaryConfiguration());
        BinaryInternalMapper prevMap = this.cls2Mappers.putIfAbsent(clsName, mapper);
        if (prevMap != null && !mapper.equals(prevMap)) {
            throw new IgniteException("Different mappers [clsName=" + clsName + ", newMapper=" + mapper + ", prevMap=" + prevMap + "]");
        }
        prevMap = this.typeId2Mapper.putIfAbsent(mapper.typeId(clsName), mapper);
        if (prevMap != null && !mapper.equals(prevMap)) {
            throw new IgniteException("Different mappers [clsName=" + clsName + ", newMapper=" + mapper + ", prevMap=" + prevMap + "]");
        }
        return mapper;
    }

    private static BinaryInternalMapper resolveMapper(String clsName, BinaryConfiguration cfg) {
        assert (clsName != null);
        if (cfg == null) {
            return DFLT_MAPPER;
        }
        BinaryIdMapper globalIdMapper = cfg.getIdMapper();
        BinaryNameMapper globalNameMapper = cfg.getNameMapper();
        Collection<BinaryTypeConfiguration> typeCfgs = cfg.getTypeConfigurations();
        if (typeCfgs != null) {
            for (BinaryTypeConfiguration typeCfg : typeCfgs) {
                String typePkgName;
                String typeCfgName = typeCfg.getTypeName();
                if (typeCfgName == null || !typeCfgName.endsWith(".*")) continue;
                String pkgName = typeCfgName.substring(0, typeCfgName.length() - 2);
                int dotIndex = clsName.lastIndexOf(46);
                if (dotIndex <= 0 || !pkgName.equals(typePkgName = clsName.substring(0, dotIndex))) continue;
                BinaryIdMapper idMapper = globalIdMapper;
                if (typeCfg.getIdMapper() != null) {
                    idMapper = typeCfg.getIdMapper();
                }
                BinaryNameMapper nameMapper = globalNameMapper;
                if (typeCfg.getNameMapper() != null) {
                    nameMapper = typeCfg.getNameMapper();
                }
                return BinaryContext.resolveMapper(nameMapper, idMapper);
            }
        }
        return BinaryContext.resolveMapper(globalNameMapper, globalIdMapper);
    }

    public String userTypeName(String clsName) {
        BinaryInternalMapper mapper = this.userTypeMapper(clsName);
        return mapper.typeName(clsName);
    }

    public static String affinityFieldName(Class cls) {
        while (cls != Object.class && cls != null) {
            for (Field f : cls.getDeclaredFields()) {
                if (f.getAnnotation(AffinityKeyMapped.class) == null) continue;
                return f.getName();
            }
            cls = cls.getSuperclass();
        }
        return null;
    }

    public BinaryClassDescriptor registerPredefinedType(Class<?> cls, int id) {
        return this.registerPredefinedType(cls, id, null, true);
    }

    public BinaryClassDescriptor registerPredefinedType(Class<?> cls, int id, String affFieldName, boolean registered) {
        String simpleClsName = SIMPLE_NAME_LOWER_CASE_MAPPER.typeName(cls.getName());
        if (id == 0) {
            id = SIMPLE_NAME_LOWER_CASE_MAPPER.typeId(simpleClsName);
        }
        BinaryClassDescriptor desc = new BinaryClassDescriptor(this, cls, false, id, simpleClsName, affFieldName, SIMPLE_NAME_LOWER_CASE_MAPPER, new BinaryReflectiveSerializer(), false, registered);
        this.predefinedTypeNames.put(simpleClsName, id);
        this.predefinedTypes.put(id, desc);
        this.descByCls.put(cls, desc);
        if (affFieldName != null) {
            this.affKeyFieldNames.putIfAbsent(id, affFieldName);
        }
        return desc;
    }

    public void registerUserType(String clsName, BinaryInternalMapper mapper, @Nullable BinarySerializer serializer, @Nullable BinaryIdentityResolver identity, @Nullable String affKeyFieldName, boolean isEnum, @Nullable Map<String, Integer> enumMap) throws BinaryObjectException {
        assert (mapper != null);
        Class<?> cls = null;
        try {
            cls = U.resolveClassLoader(this.configuration()).loadClass(clsName);
        }
        catch (ClassNotFoundException | NoClassDefFoundError throwable) {
            // empty catch block
        }
        String typeName = mapper.typeName(clsName);
        int id = mapper.typeId(clsName);
        if (this.predefinedTypes.get(id) != null) {
            throw BinaryContext.duplicateTypeIdException(clsName, id);
        }
        if (this.typeId2Mapper.put(id, mapper) != null) {
            throw BinaryContext.duplicateTypeIdException(clsName, id);
        }
        if (identity != null && this.identities.put(id, identity) != null) {
            throw BinaryContext.duplicateTypeIdException(clsName, id);
        }
        if (affKeyFieldName != null && this.affKeyFieldNames.put(id, affKeyFieldName) != null) {
            throw BinaryContext.duplicateTypeIdException(clsName, id);
        }
        this.cls2Mappers.put(clsName, mapper);
        Map<String, BinaryFieldMetadata> fieldsMeta = null;
        if (cls != null) {
            if (serializer == null && BinaryContext.canUseReflectiveSerializer(cls)) {
                serializer = new BinaryReflectiveSerializer();
            }
            BinaryClassDescriptor desc = new BinaryClassDescriptor(this, cls, true, id, typeName, affKeyFieldName, mapper, serializer, true, true);
            fieldsMeta = desc.fieldsMeta();
            this.descByCls.put(cls, desc);
            this.predefinedTypes.put(id, desc);
        }
        this.metaHnd.addMeta(id, new BinaryMetadata(id, typeName, fieldsMeta, affKeyFieldName, null, isEnum, enumMap).wrap(this));
    }

    public void registerUserTypesSchema() {
        for (BinaryClassDescriptor desc : this.predefinedTypes.values()) {
            if (!desc.userType()) continue;
            desc.registerStableSchema();
        }
    }

    public boolean registerUserClassName(int typeId, String clsName) {
        IgniteCheckedException e = null;
        boolean res = false;
        try {
            res = this.marshCtx.registerClassName((byte)0, typeId, clsName);
        }
        catch (DuplicateTypeIdException dupEx) {
            BinaryInternalMapper mapper = this.userTypeMapper(typeId);
            String oldName = dupEx.getRegisteredClassName();
            if (!mapper.typeName(oldName).equals(clsName) && !mapper.typeName(clsName).equals(oldName)) {
                e = dupEx;
            }
        }
        catch (IgniteCheckedException igniteEx) {
            e = igniteEx;
        }
        if (e != null) {
            throw new BinaryObjectException("Failed to register class.", e);
        }
        return res;
    }

    private static BinaryObjectException duplicateTypeIdException(String clsName, int id) {
        return new BinaryObjectException("Duplicate type ID [clsName=" + clsName + ", id=" + id + ']');
    }

    private static boolean canUseReflectiveSerializer(Class cls) {
        return BinaryUtils.isBinarylizable(cls) || !BinaryUtils.isCustomJavaSerialization(cls);
    }

    public BinaryFieldImpl createField(int typeId, String fieldName) {
        BinarySchemaRegistry schemaReg = this.schemaRegistry(typeId);
        BinaryInternalMapper mapper = this.userTypeMapper(typeId);
        int fieldId = mapper.fieldId(typeId, fieldName);
        return new BinaryFieldImpl(this, typeId, schemaReg, fieldName, fieldId);
    }

    @Nullable
    public BinaryType metadata(int typeId) throws BinaryObjectException {
        return this.metaHnd != null ? this.metaHnd.metadata(typeId) : null;
    }

    @Nullable
    public BinaryMetadata metadata0(int typeId) throws BinaryObjectException {
        return this.metaHnd != null ? this.metaHnd.metadata0(typeId) : null;
    }

    public Collection<BinaryType> metadata() throws BinaryObjectException {
        return this.metaHnd != null ? this.metaHnd.metadata() : Collections.emptyList();
    }

    public BinaryType metadata(int typeId, int schemaId) throws BinaryObjectException {
        return this.metaHnd != null ? this.metaHnd.metadata(typeId, schemaId) : null;
    }

    public String affinityKeyFieldName(int typeId) {
        BinaryMetadata meta;
        String res = (String)this.affKeyFieldNames.get(typeId);
        if (res == null && (meta = this.metaHnd.metadata0(typeId)) != null) {
            res = meta.affinityKeyFieldName();
        }
        return res;
    }

    public BinaryIdentityResolver identity(int typeId) {
        BinaryIdentityResolver rslvr = (BinaryIdentityResolver)this.identities.get(typeId);
        return rslvr != null ? rslvr : BinaryArrayIdentityResolver.instance();
    }

    public void updateMetadata(int typeId, BinaryMetadata meta) throws BinaryObjectException {
        this.metaHnd.addMeta(typeId, meta.wrap(this));
    }

    public boolean isCompactFooter() {
        return this.compactFooter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BinarySchemaRegistry schemaRegistry(int typeId) {
        BinarySchemaRegistry reg;
        Map<Integer, BinarySchemaRegistry> schemas0 = this.schemas;
        if (schemas0 == null) {
            BinaryContext binaryContext = this;
            synchronized (binaryContext) {
                schemas0 = this.schemas;
                if (schemas0 == null) {
                    schemas0 = new HashMap<Integer, BinarySchemaRegistry>();
                    BinarySchemaRegistry reg2 = new BinarySchemaRegistry();
                    schemas0.put(typeId, reg2);
                    this.schemas = schemas0;
                    return reg2;
                }
            }
        }
        if ((reg = schemas0.get(typeId)) == null) {
            BinaryContext binaryContext = this;
            synchronized (binaryContext) {
                reg = this.schemas.get(typeId);
                if (reg == null) {
                    reg = new BinarySchemaRegistry();
                    schemas0 = new HashMap<Integer, BinarySchemaRegistry>(this.schemas);
                    schemas0.put(typeId, reg);
                    this.schemas = schemas0;
                }
            }
        }
        return reg;
    }

    public void unregisterBinarySchemas() {
        this.schemas = null;
    }

    public void unregisterUserTypeDescriptors() {
        Iterator it = this.descByCls.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            if (!((BinaryClassDescriptor)e.getValue()).userType()) continue;
            it.remove();
        }
    }

    OptimizedMarshaller optimizedMarsh() {
        return this.optmMarsh;
    }

    public void onUndeploy(ClassLoader ldr) {
        Iterator it = this.descByCls.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            if (!((BinaryClassDescriptor)e.getValue()).userType() || !ldr.equals(((Class)e.getKey()).getClassLoader())) continue;
            it.remove();
        }
        U.clearClassCache(ldr);
    }

    private static Map<String, Integer> enumMap(Class<?> cls) {
        assert (cls.isEnum());
        ?[] enumVals = cls.getEnumConstants();
        LinkedHashMap<String, Integer> enumMap = new LinkedHashMap<String, Integer>(enumVals.length);
        for (Object enumVal : enumVals) {
            enumMap.put(((Enum)enumVal).name(), ((Enum)enumVal).ordinal());
        }
        return enumMap;
    }

    static {
        HashSet<String> sysClss = new HashSet<String>();
        sysClss.add(IgfsPath.class.getName());
        sysClss.add(IgfsBlockKey.class.getName());
        sysClss.add(IgfsDirectoryInfo.class.getName());
        sysClss.add(IgfsFileAffinityRange.class.getName());
        sysClss.add(IgfsFileInfo.class.getName());
        sysClss.add(IgfsFileMap.class.getName());
        sysClss.add(IgfsListingEntry.class.getName());
        sysClss.add(IgfsDataPutProcessor.class.getName());
        sysClss.add(IgfsMetaDirectoryCreateProcessor.class.getName());
        sysClss.add(IgfsMetaDirectoryListingAddProcessor.class.getName());
        sysClss.add(IgfsMetaDirectoryListingRemoveProcessor.class.getName());
        sysClss.add(IgfsMetaDirectoryListingRenameProcessor.class.getName());
        sysClss.add(IgfsMetaDirectoryListingReplaceProcessor.class.getName());
        sysClss.add(IgfsMetaFileCreateProcessor.class.getName());
        sysClss.add(IgfsMetaFileLockProcessor.class.getName());
        sysClss.add(IgfsMetaFileRangeDeleteProcessor.class.getName());
        sysClss.add(IgfsMetaFileRangeUpdateProcessor.class.getName());
        sysClss.add(IgfsMetaFileReserveSpaceProcessor.class.getName());
        sysClss.add(IgfsMetaFileUnlockProcessor.class.getName());
        sysClss.add(IgfsMetaUpdatePropertiesProcessor.class.getName());
        sysClss.add(IgfsMetaUpdateTimesProcessor.class.getName());
        sysClss.add(IgfsClientMetaIdsForPathCallable.class.getName());
        sysClss.add(IgfsClientMetaInfoForPathCallable.class.getName());
        sysClss.add(IgfsClientMetaUnlockCallable.class.getName());
        sysClss.add(IgfsClientAffinityCallable.class.getName());
        sysClss.add(IgfsClientDeleteCallable.class.getName());
        sysClss.add(IgfsClientExistsCallable.class.getName());
        sysClss.add(IgfsClientInfoCallable.class.getName());
        sysClss.add(IgfsClientListFilesCallable.class.getName());
        sysClss.add(IgfsClientListPathsCallable.class.getName());
        sysClss.add(IgfsClientMkdirsCallable.class.getName());
        sysClss.add(IgfsClientRenameCallable.class.getName());
        sysClss.add(IgfsClientSetTimesCallable.class.getName());
        sysClss.add(IgfsClientSizeCallable.class.getName());
        sysClss.add(IgfsClientSummaryCallable.class.getName());
        sysClss.add(IgfsClientUpdateCallable.class.getName());
        sysClss.add(GridClosureProcessor.C1.class.getName());
        sysClss.add(GridClosureProcessor.C1MLA.class.getName());
        sysClss.add(GridClosureProcessor.C2.class.getName());
        sysClss.add(GridClosureProcessor.C2MLA.class.getName());
        sysClss.add(GridClosureProcessor.C4.class.getName());
        sysClss.add(GridClosureProcessor.C4MLA.class.getName());
        sysClss.add(IgniteUuid.class.getName());
        sysClss.add(BinaryTreeMap.class.getName());
        if (BinaryUtils.wrapTrees()) {
            sysClss.add(TreeMap.class.getName());
            sysClss.add(TreeSet.class.getName());
        }
        BINARYLIZABLE_SYS_CLSS = Collections.unmodifiableSet(sysClss);
    }

    static class Type {
        private final int id;
        private final boolean registered;

        public Type(int id, boolean registered) {
            this.id = id;
            this.registered = registered;
        }

        public int id() {
            return this.id;
        }

        public boolean registered() {
            return this.registered;
        }
    }

    private static class TypeDescriptor {
        private final String clsName;
        private BinaryInternalMapper mapper;
        private BinarySerializer serializer;
        private BinaryIdentityResolver identity;
        private String affKeyFieldName;
        private boolean isEnum;
        private Map<String, Integer> enumMap;
        private boolean canOverride;

        private TypeDescriptor(String clsName, BinaryInternalMapper mapper, BinarySerializer serializer, BinaryIdentityResolver identity, String affKeyFieldName, boolean isEnum, Map<String, Integer> enumMap, boolean canOverride) {
            this.clsName = clsName;
            this.mapper = mapper;
            this.serializer = serializer;
            this.identity = identity;
            this.affKeyFieldName = affKeyFieldName;
            this.isEnum = isEnum;
            this.enumMap = enumMap;
            this.canOverride = canOverride;
        }

        private void override(TypeDescriptor other) throws BinaryObjectException {
            assert (this.clsName.equals(other.clsName));
            if (this.canOverride) {
                this.mapper = other.mapper;
                this.serializer = other.serializer;
                this.identity = other.identity;
                this.affKeyFieldName = other.affKeyFieldName;
                this.isEnum = other.isEnum;
                this.enumMap = other.enumMap;
                this.canOverride = other.canOverride;
            } else if (!other.canOverride) {
                throw new BinaryObjectException("Duplicate explicit class definition in configuration: " + this.clsName);
            }
        }
    }

    private static class TypeDescriptors {
        private final Map<String, TypeDescriptor> descs = new LinkedHashMap<String, TypeDescriptor>();

        private TypeDescriptors() {
        }

        private void add(String clsName, BinaryInternalMapper mapper, BinarySerializer serializer, BinaryIdentityResolver identity, String affKeyFieldName, boolean isEnum, Map<String, Integer> enumMap, boolean canOverride) throws BinaryObjectException {
            TypeDescriptor desc = new TypeDescriptor(clsName, mapper, serializer, identity, affKeyFieldName, isEnum, enumMap, canOverride);
            TypeDescriptor oldDesc = this.descs.get(clsName);
            if (oldDesc == null) {
                this.descs.put(clsName, desc);
            } else {
                oldDesc.override(desc);
            }
        }

        private Iterable<TypeDescriptor> descriptors() {
            return this.descs.values();
        }
    }
}

