/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.binary.builder;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.ignite.binary.BinaryInvalidTypeException;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.binary.BinaryObjectBuilder;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryType;
import org.apache.ignite.internal.binary.BinaryContext;
import org.apache.ignite.internal.binary.BinaryEnumObjectImpl;
import org.apache.ignite.internal.binary.BinaryFieldMetadata;
import org.apache.ignite.internal.binary.BinaryMetadata;
import org.apache.ignite.internal.binary.BinaryObjectImpl;
import org.apache.ignite.internal.binary.BinaryObjectOffheapImpl;
import org.apache.ignite.internal.binary.BinarySchema;
import org.apache.ignite.internal.binary.BinarySchemaRegistry;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.binary.builder.BinaryBuilderReader;
import org.apache.ignite.internal.binary.builder.BinaryBuilderSerializer;
import org.apache.ignite.internal.binary.builder.BinaryValueWithType;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.jetbrains.annotations.Nullable;

public class BinaryObjectBuilderImpl
implements BinaryObjectBuilder {
    private static final Object REMOVED_FIELD_MARKER = new Object();
    private final BinaryContext ctx;
    private final int typeId;
    private String typeName;
    private String clsNameToWrite;
    private boolean registeredType = true;
    private Map<String, Object> assignedVals;
    private Map<Integer, Object> readCache;
    private final int start;
    private final short flags;
    private final int hdrLen;
    private final BinaryBuilderReader reader;
    private String affFieldName;

    public BinaryObjectBuilderImpl(BinaryContext ctx, String clsName) {
        this(ctx, ctx.typeId(clsName), ctx.userTypeName(clsName));
    }

    public BinaryObjectBuilderImpl(BinaryContext ctx, int typeId, String typeName) {
        this.typeId = typeId;
        this.typeName = typeName;
        this.ctx = ctx;
        this.start = -1;
        this.flags = (short)-1;
        this.reader = null;
        this.hdrLen = 24;
        this.readCache = Collections.emptyMap();
    }

    public BinaryObjectBuilderImpl(BinaryObjectImpl obj) {
        this(new BinaryBuilderReader(obj), obj.start());
        this.reader.registerObject(this);
    }

    BinaryObjectBuilderImpl(BinaryBuilderReader reader, int start) {
        assert (reader != null);
        this.reader = reader;
        this.start = start;
        this.flags = reader.readShortPositioned(start + 2);
        byte ver = reader.readBytePositioned(start + 1);
        BinaryUtils.checkProtocolVersion(ver);
        int typeId = reader.readIntPositioned(start + 4);
        this.ctx = reader.binaryContext();
        if (typeId == 0) {
            Class<?> cls;
            int mark = reader.position();
            reader.position(start + 24);
            this.clsNameToWrite = reader.readString();
            try {
                cls = U.forName(this.clsNameToWrite, this.ctx.configuration().getClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new BinaryInvalidTypeException("Failed to load the class: " + this.clsNameToWrite, e);
            }
            this.typeId = this.ctx.descriptorForClass(cls, false).typeId();
            this.registeredType = false;
            this.hdrLen = reader.position() - mark;
            reader.position(mark);
        } else {
            this.typeId = typeId;
            this.hdrLen = 24;
        }
    }

    @Override
    public BinaryObject build() {
        try (BinaryWriterExImpl writer = new BinaryWriterExImpl(this.ctx);){
            writer.typeId(this.typeId);
            BinaryBuilderSerializer serializationCtx = new BinaryBuilderSerializer();
            serializationCtx.registerObjectWriting(this, 0);
            this.serializeTo(writer, serializationCtx);
            byte[] arr = writer.array();
            BinaryObjectImpl binaryObjectImpl = new BinaryObjectImpl(this.ctx, arr, 0);
            return binaryObjectImpl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    void serializeTo(BinaryWriterExImpl writer, BinaryBuilderSerializer serializer) {
        try {
            writer.preWrite(this.registeredType ? null : this.clsNameToWrite);
            Set remainsFlds = null;
            BinaryType meta = this.ctx.metadata(this.typeId);
            Map<String, BinaryFieldMetadata> fieldsMeta = null;
            if (this.reader != null && BinaryUtils.hasSchema(this.flags)) {
                BinarySchema schema = this.reader.schema();
                if (this.assignedVals != null) {
                    HashMap<Integer, Object> hashMap = U.newHashMap(this.assignedVals.size());
                    for (Map.Entry<String, Object> entry : this.assignedVals.entrySet()) {
                        String name = entry.getKey();
                        Object val = entry.getValue();
                        int fieldId = this.ctx.fieldId(this.typeId, name);
                        hashMap.put(fieldId, val);
                        if (val == REMOVED_FIELD_MARKER) continue;
                        fieldsMeta = this.checkMetadata(meta, fieldsMeta, val, name, fieldId);
                    }
                    remainsFlds = hashMap.keySet();
                } else {
                    Map map = Collections.emptyMap();
                }
                int fieldIdLen = BinaryUtils.fieldIdLength(this.flags);
                int fieldOffsetLen = BinaryUtils.fieldOffsetLength(this.flags);
                IgniteBiTuple<Integer, Integer> footer = BinaryUtils.footerAbsolute(this.reader, this.start);
                int footerPos = footer.get1();
                int footerEnd = footer.get2();
                int rawPos = BinaryUtils.rawOffsetAbsolute(this.reader, this.start);
                this.reader.position(this.start + this.hdrLen);
                int idx = 0;
                while (this.reader.position() < rawPos) {
                    void var7_11;
                    int fieldId = schema.fieldId(idx++);
                    int fieldLen = this.fieldPositionAndLength(footerPos, footerEnd, rawPos, fieldIdLen, fieldOffsetLen).get2();
                    int postPos = this.reader.position() + fieldLen;
                    footerPos += fieldIdLen + fieldOffsetLen;
                    if (var7_11.containsKey(fieldId)) {
                        Object assignedVal = var7_11.remove(fieldId);
                        if (assignedVal != REMOVED_FIELD_MARKER) {
                            writer.writeFieldId(fieldId);
                            serializer.writeValue(writer, assignedVal);
                        }
                    } else {
                        byte type;
                        byte by = type = fieldLen != 0 ? this.reader.readByte(0) : (byte)0;
                        if (fieldLen != 0 && !BinaryUtils.isPlainArrayType(type) && BinaryUtils.isPlainType(type)) {
                            writer.writeFieldId(fieldId);
                            writer.write(this.reader.array(), this.reader.position(), fieldLen);
                        } else {
                            Object val;
                            writer.writeFieldId(fieldId);
                            if (fieldLen == 0) {
                                val = null;
                            } else if (this.readCache == null) {
                                val = this.reader.parseValue();
                                assert (this.reader.position() == postPos);
                            } else {
                                val = this.readCache.get(fieldId);
                            }
                            serializer.writeValue(writer, val);
                        }
                    }
                    this.reader.position(postPos);
                }
            }
            if (!(this.assignedVals == null || remainsFlds != null && remainsFlds.isEmpty())) {
                for (Map.Entry entry : this.assignedVals.entrySet()) {
                    Object val = entry.getValue();
                    if (val == REMOVED_FIELD_MARKER) continue;
                    String name = (String)entry.getKey();
                    int fieldId = this.ctx.fieldId(this.typeId, name);
                    if (remainsFlds != null && !remainsFlds.contains(fieldId)) continue;
                    writer.writeFieldId(fieldId);
                    serializer.writeValue(writer, val);
                    if (this.reader != null) continue;
                    fieldsMeta = this.checkMetadata(meta, fieldsMeta, val, name, fieldId);
                }
            }
            if (this.reader != null) {
                int n;
                int rawOff = BinaryUtils.rawOffsetAbsolute(this.reader, this.start);
                if (rawOff < (n = BinaryUtils.footerStartAbsolute(this.reader, this.start))) {
                    writer.rawWriter();
                    writer.write(this.reader.array(), rawOff, n - rawOff);
                }
                this.reader.position(this.start + BinaryUtils.length(this.reader, this.start));
            }
            writer.postWrite(true, this.registeredType);
            int schemaId = writer.schemaId();
            BinarySchemaRegistry binarySchemaRegistry = this.ctx.schemaRegistry(this.typeId);
            if (binarySchemaRegistry.schema(schemaId) == null) {
                String typeName = this.typeName;
                if (typeName == null) {
                    assert (meta != null);
                    typeName = meta.typeName();
                }
                BinarySchema curSchema = writer.currentSchema();
                String affFieldName0 = this.affFieldName;
                if (affFieldName0 == null) {
                    affFieldName0 = this.ctx.affinityKeyFieldName(this.typeId);
                }
                this.ctx.registerUserClassName(this.typeId, typeName);
                this.ctx.updateMetadata(this.typeId, new BinaryMetadata(this.typeId, typeName, fieldsMeta, affFieldName0, Collections.singleton(curSchema), false, null));
                binarySchemaRegistry.addSchema(curSchema.schemaId(), curSchema);
            }
            writer.postWriteHashCode(this.registeredType ? null : this.clsNameToWrite);
        }
        finally {
            writer.popSchema();
        }
    }

    private Map<String, BinaryFieldMetadata> checkMetadata(BinaryType meta, Map<String, BinaryFieldMetadata> fieldsMeta, Object newVal, String name, int fieldId) {
        String newFldTypeName;
        int newFldTypeId;
        String oldFldTypeName = meta == null ? null : meta.fieldTypeName(name);
        boolean nullFieldVal = false;
        if (newVal instanceof BinaryValueWithType) {
            newFldTypeId = ((BinaryValueWithType)newVal).typeId();
            if (((BinaryValueWithType)newVal).value() == null) {
                nullFieldVal = true;
            }
        } else {
            BinaryObject[] arr;
            newFldTypeId = newVal instanceof BinaryEnumObjectImpl ? 28 : (newVal.getClass().isArray() && newVal.getClass().getComponentType() == BinaryObject.class ? ((arr = (BinaryObject[])newVal).length > 0 && arr[0] instanceof BinaryEnumObjectImpl ? 29 : 23) : (int)BinaryUtils.typeByClass(newVal.getClass()));
        }
        if (oldFldTypeName == null) {
            if (fieldsMeta == null) {
                fieldsMeta = BinaryUtils.FIELDS_SORTED_ORDER ? new TreeMap<String, BinaryFieldMetadata>() : new LinkedHashMap<String, BinaryFieldMetadata>();
            }
            fieldsMeta.put((String)name, (BinaryFieldMetadata)new BinaryFieldMetadata(newFldTypeId, fieldId));
        } else if (!nullFieldVal && !F.eq(newFldTypeName = BinaryUtils.fieldTypeName(newFldTypeId), oldFldTypeName)) {
            throw new BinaryObjectException("Wrong value has been set [typeName=" + (this.typeName == null ? meta.typeName() : this.typeName) + ", fieldName=" + name + ", fieldType=" + oldFldTypeName + ", assignedValueType=" + newFldTypeName + ']');
        }
        return fieldsMeta;
    }

    private IgniteBiTuple<Integer, Integer> fieldPositionAndLength(int footerPos, int footerEnd, int rawPos, int fieldIdLen, int fieldOffsetLen) {
        int fieldLen;
        int fieldOffset = BinaryUtils.fieldOffsetRelative(this.reader, footerPos + fieldIdLen, fieldOffsetLen);
        int fieldPos = this.start + fieldOffset;
        if (footerPos + fieldIdLen + fieldOffsetLen == footerEnd) {
            fieldLen = rawPos - fieldPos;
        } else {
            int nextFieldOffset = BinaryUtils.fieldOffsetRelative(this.reader, footerPos + fieldIdLen + fieldOffsetLen + fieldIdLen, fieldOffsetLen);
            fieldLen = nextFieldOffset - fieldOffset;
        }
        return F.t(fieldPos, fieldLen);
    }

    private void ensureReadCacheInit() {
        assert (this.reader != null);
        if (this.readCache == null) {
            int fieldIdLen = BinaryUtils.fieldIdLength(this.flags);
            int fieldOffsetLen = BinaryUtils.fieldOffsetLength(this.flags);
            BinarySchema schema = this.reader.schema();
            HashMap<Integer, Object> readCache = new HashMap<Integer, Object>();
            IgniteBiTuple<Integer, Integer> footer = BinaryUtils.footerAbsolute(this.reader, this.start);
            int footerPos = footer.get1();
            int footerEnd = footer.get2();
            int rawPos = BinaryUtils.rawOffsetAbsolute(this.reader, this.start);
            int idx = 0;
            while (footerPos + fieldIdLen < footerEnd) {
                int fieldId = schema.fieldId(idx++);
                IgniteBiTuple<Integer, Integer> posAndLen = this.fieldPositionAndLength(footerPos, footerEnd, rawPos, fieldIdLen, fieldOffsetLen);
                Object val = this.reader.getValueQuickly(posAndLen.get1(), posAndLen.get2());
                readCache.put(fieldId, val);
                footerPos += fieldIdLen + fieldOffsetLen;
            }
            this.readCache = readCache;
        }
    }

    private Map<String, Object> assignedValues() {
        if (this.assignedVals == null) {
            this.assignedVals = BinaryUtils.FIELDS_SORTED_ORDER ? new TreeMap<String, Object>() : new LinkedHashMap<String, Object>();
        }
        return this.assignedVals;
    }

    @Override
    public <T> T getField(String name) {
        Object val;
        if (this.assignedVals != null && this.assignedVals.containsKey(name)) {
            val = this.assignedVals.get(name);
            if (val == REMOVED_FIELD_MARKER) {
                return null;
            }
        } else {
            this.ensureReadCacheInit();
            int fldId = this.ctx.fieldId(this.typeId, name);
            val = this.readCache.get(fldId);
        }
        return (T)BinaryUtils.unwrapLazy(val);
    }

    @Override
    public BinaryObjectBuilder setField(String name, Object val0) {
        Object val = this.assignedValues().get(name);
        if (val instanceof BinaryValueWithType) {
            ((BinaryValueWithType)val).value(val0);
        } else {
            Class valCls = val == null ? Object.class : val.getClass();
            val = val0 == null ? new BinaryValueWithType(BinaryUtils.typeByClass(valCls), null) : val0;
        }
        this.assignedValues().put(name, val);
        return this;
    }

    @Override
    public <T> BinaryObjectBuilder setField(String name, @Nullable T val, Class<? super T> type) {
        byte typeId = Collection.class.equals(type) ? (byte)24 : (Map.class.equals(type) ? (byte)25 : (byte)BinaryUtils.typeByClass(type));
        this.assignedValues().put(name, new BinaryValueWithType(typeId, val));
        return this;
    }

    @Override
    public BinaryObjectBuilder setField(String name, @Nullable BinaryObjectBuilder builder) {
        return this.setField(name, (Object)builder);
    }

    @Override
    public BinaryObjectBuilderImpl removeField(String name) {
        this.assignedValues().put(name, REMOVED_FIELD_MARKER);
        return this;
    }

    public static BinaryObjectBuilderImpl wrap(BinaryObject obj) {
        BinaryObjectImpl heapObj = obj instanceof BinaryObjectOffheapImpl ? (BinaryObjectImpl)((BinaryObjectOffheapImpl)obj).heapCopy() : (BinaryObjectImpl)obj;
        return new BinaryObjectBuilderImpl(heapObj);
    }

    int start() {
        return this.start;
    }

    public int typeId() {
        return this.typeId;
    }

    public void affinityFieldName(String affFieldName) {
        this.affFieldName = affFieldName;
    }
}

