/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersionConflictContext;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteBiTuple;
import org.jetbrains.annotations.Nullable;

public class GridCacheUpdateAtomicResult {
    private final UpdateOutcome outcome;
    @GridToStringInclude
    private final CacheObject oldVal;
    @GridToStringInclude
    private final CacheObject newVal;
    private final long newTtl;
    private final long conflictExpireTime;
    @GridToStringInclude
    private final GridCacheVersion rmvVer;
    @GridToStringInclude
    private final GridCacheVersionConflictContext<?, ?> conflictRes;
    private final long updateCntr;
    private IgniteBiTuple<Object, Exception> res;

    GridCacheUpdateAtomicResult(UpdateOutcome outcome, @Nullable CacheObject oldVal, @Nullable CacheObject newVal, @Nullable IgniteBiTuple<Object, Exception> res, long newTtl, long conflictExpireTime, @Nullable GridCacheVersion rmvVer, @Nullable GridCacheVersionConflictContext<?, ?> conflictRes, long updateCntr) {
        assert (outcome != null);
        this.outcome = outcome;
        this.oldVal = oldVal;
        this.newVal = newVal;
        this.res = res;
        this.newTtl = newTtl;
        this.conflictExpireTime = conflictExpireTime;
        this.rmvVer = rmvVer;
        this.conflictRes = conflictRes;
        this.updateCntr = updateCntr;
    }

    UpdateOutcome outcome() {
        return this.outcome;
    }

    @Nullable
    public IgniteBiTuple<Object, Exception> computedResult() {
        return this.res;
    }

    public boolean success() {
        return this.outcome.success();
    }

    @Nullable
    public CacheObject oldValue() {
        return this.oldVal;
    }

    @Nullable
    public CacheObject newValue() {
        return this.newVal;
    }

    public long newTtl() {
        return this.newTtl;
    }

    public long updateCounter() {
        return this.updateCntr;
    }

    public long conflictExpireTime() {
        return this.conflictExpireTime;
    }

    @Nullable
    public GridCacheVersion removeVersion() {
        return this.rmvVer;
    }

    @Nullable
    public GridCacheVersionConflictContext<?, ?> conflictResolveResult() {
        return this.conflictRes;
    }

    public boolean sendToDht() {
        return this.outcome.sendToDht();
    }

    public String toString() {
        return S.toString(GridCacheUpdateAtomicResult.class, this);
    }

    public static enum UpdateOutcome {
        CONFLICT_USE_OLD(false, false, false),
        VERSION_CHECK_FAILED(false, false, false),
        FILTER_FAILED(false, false, true),
        INVOKE_NO_OP(false, false, true),
        INTERCEPTOR_CANCEL(false, false, true),
        REMOVE_NO_VAL(false, true, true),
        SUCCESS(true, true, true);

        private final boolean success;
        private final boolean sndToDht;
        private final boolean updateReadMetrics;

        private UpdateOutcome(boolean success, boolean sndToDht, boolean updateReadMetrics) {
            this.success = success;
            this.sndToDht = sndToDht;
            this.updateReadMetrics = updateReadMetrics;
        }

        public boolean success() {
            return this.success;
        }

        public boolean sendToDht() {
            return this.sndToDht;
        }

        public boolean updateReadMetrics() {
            return this.updateReadMetrics;
        }
    }
}

