/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht;

import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.cluster.ClusterTopologyServerNotFoundException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheCompoundIdentityFuture;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheFuture;
import org.apache.ignite.internal.processors.cache.IgniteCacheExpiryPolicy;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.CacheGetFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtPartitionState;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public abstract class CacheDistributedGetFutureAdapter<K, V>
extends GridCacheCompoundIdentityFuture<Map<K, V>>
implements GridCacheFuture<Map<K, V>>,
CacheGetFuture {
    public static final int DFLT_MAX_REMAP_CNT = 3;
    protected static final int MAX_REMAP_CNT = IgniteSystemProperties.getInteger("IGNITE_NEAR_GET_MAX_REMAPS", 3);
    protected static final AtomicIntegerFieldUpdater<CacheDistributedGetFutureAdapter> REMAP_CNT_UPD = AtomicIntegerFieldUpdater.newUpdater(CacheDistributedGetFutureAdapter.class, "remapCnt");
    protected final GridCacheContext<K, V> cctx;
    protected Collection<KeyCacheObject> keys;
    protected boolean readThrough;
    protected boolean forcePrimary;
    protected IgniteUuid futId;
    protected boolean trackable;
    protected volatile int remapCnt;
    protected UUID subjId;
    protected String taskName;
    protected boolean deserializeBinary;
    protected boolean skipVals;
    protected IgniteCacheExpiryPolicy expiryPlc;
    protected boolean canRemap = true;
    protected final boolean needVer;
    protected final boolean keepCacheObjects;
    protected final boolean recovery;

    protected CacheDistributedGetFutureAdapter(GridCacheContext<K, V> cctx, Collection<KeyCacheObject> keys, boolean readThrough, boolean forcePrimary, @Nullable UUID subjId, String taskName, boolean deserializeBinary, @Nullable IgniteCacheExpiryPolicy expiryPlc, boolean skipVals, boolean needVer, boolean keepCacheObjects, boolean recovery) {
        super(CU.mapsReducer(keys.size()));
        assert (!F.isEmpty(keys));
        this.cctx = cctx;
        this.keys = keys;
        this.readThrough = readThrough;
        this.forcePrimary = forcePrimary;
        this.subjId = subjId;
        this.taskName = taskName;
        this.deserializeBinary = deserializeBinary;
        this.expiryPlc = expiryPlc;
        this.skipVals = skipVals;
        this.needVer = needVer;
        this.keepCacheObjects = keepCacheObjects;
        this.recovery = recovery;
        this.futId = IgniteUuid.randomUuid();
    }

    protected final boolean partitionOwned(int part) {
        return this.cctx.topology().partitionState(this.cctx.localNodeId(), part) == GridDhtPartitionState.OWNING;
    }

    protected final ClusterTopologyServerNotFoundException serverNotFoundError(AffinityTopologyVersion topVer) {
        return new ClusterTopologyServerNotFoundException("Failed to map keys for cache (all partition nodes left the grid) [topVer=" + topVer + ", cache=" + this.cctx.name() + ']');
    }
}

