/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.wal;

import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteOrder;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.pagemem.wal.WALIterator;
import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIO;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIOFactory;
import org.apache.ignite.internal.processors.cache.persistence.file.UnzipFileIO;
import org.apache.ignite.internal.processors.cache.persistence.wal.ByteBufferExpander;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileInput;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.apache.ignite.internal.processors.cache.persistence.wal.SegmentEofException;
import org.apache.ignite.internal.processors.cache.persistence.wal.WalSegmentTailReachedException;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordSerializer;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordSerializerFactory;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordV1Serializer;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.SegmentHeader;
import org.apache.ignite.internal.util.GridCloseableIteratorAdapter;
import org.apache.ignite.internal.util.typedef.P2;
import org.apache.ignite.lang.IgniteBiTuple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractWalRecordsIterator
extends GridCloseableIteratorAdapter<IgniteBiTuple<WALPointer, WALRecord>>
implements WALIterator {
    private static final long serialVersionUID = 0L;
    protected IgniteBiTuple<WALPointer, WALRecord> curRec;
    protected long curWalSegmIdx = -1L;
    private AbstractReadFileHandle currWalSegment;
    @NotNull
    protected final IgniteLogger log;
    @NotNull
    protected final GridCacheSharedContext sharedCtx;
    @NotNull
    private final RecordSerializerFactory serializerFactory;
    @NotNull
    protected final FileIOFactory ioFactory;
    private final ByteBufferExpander buf;

    protected AbstractWalRecordsIterator(@NotNull IgniteLogger log, @NotNull GridCacheSharedContext sharedCtx, @NotNull RecordSerializerFactory serializerFactory, @NotNull FileIOFactory ioFactory, int bufSize) {
        this.log = log;
        this.sharedCtx = sharedCtx;
        this.serializerFactory = serializerFactory;
        this.ioFactory = ioFactory;
        this.buf = new ByteBufferExpander(bufSize, ByteOrder.nativeOrder());
    }

    @Override
    protected IgniteBiTuple<WALPointer, WALRecord> onNext() throws IgniteCheckedException {
        IgniteBiTuple<WALPointer, WALRecord> ret = this.curRec;
        this.advance();
        return ret;
    }

    @Override
    protected boolean onHasNext() throws IgniteCheckedException {
        return this.curRec != null;
    }

    @Override
    protected void onClose() throws IgniteCheckedException {
        try {
            this.buf.close();
        }
        catch (Exception ex) {
            throw new IgniteCheckedException(ex);
        }
    }

    protected void advance() throws IgniteCheckedException {
        try {
            while (true) {
                this.curRec = this.advanceRecord(this.currWalSegment);
                if (this.curRec != null) {
                    if (this.curRec.get2().type() == null) continue;
                    return;
                }
                this.currWalSegment = this.advanceSegment(this.currWalSegment);
                if (this.currWalSegment == null) break;
            }
            return;
        }
        catch (WalSegmentTailReachedException e) {
            this.log.warning(e.getMessage());
            this.curRec = null;
            return;
        }
    }

    @Nullable
    protected AbstractReadFileHandle closeCurrentWalSegment() throws IgniteCheckedException {
        AbstractReadFileHandle walSegmentClosed = this.currWalSegment;
        if (walSegmentClosed != null) {
            walSegmentClosed.close();
            this.currWalSegment = null;
        }
        return walSegmentClosed;
    }

    protected abstract AbstractReadFileHandle advanceSegment(@Nullable AbstractReadFileHandle var1) throws IgniteCheckedException;

    private IgniteBiTuple<WALPointer, WALRecord> advanceRecord(@Nullable AbstractReadFileHandle hnd) throws IgniteCheckedException {
        if (hnd == null) {
            return null;
        }
        FileWALPointer actualFilePtr = new FileWALPointer(hnd.idx(), (int)hnd.in().position(), 0);
        try {
            WALRecord rec = hnd.ser().readRecord(hnd.in(), actualFilePtr);
            actualFilePtr.length(rec.size());
            return new IgniteBiTuple<WALPointer, WALRecord>(actualFilePtr, this.postProcessRecord(rec));
        }
        catch (IOException | IgniteCheckedException e) {
            if (e instanceof WalSegmentTailReachedException) {
                throw (WalSegmentTailReachedException)e;
            }
            if (!(e instanceof SegmentEofException)) {
                this.handleRecordException(e, actualFilePtr);
            }
            return null;
        }
    }

    @NotNull
    protected WALRecord postProcessRecord(@NotNull WALRecord rec) {
        return rec;
    }

    protected void handleRecordException(@NotNull Exception e, @Nullable FileWALPointer ptr) {
        if (this.log.isInfoEnabled()) {
            this.log.info("Stopping WAL iteration due to an exception: " + e.getMessage() + ", ptr=" + ptr);
        }
    }

    protected AbstractReadFileHandle initReadHandle(@NotNull AbstractFileDescriptor desc, @Nullable FileWALPointer start) throws IgniteCheckedException, FileNotFoundException {
        try {
            FileIO fileIO = desc.isCompressed() ? new UnzipFileIO(desc.file()) : this.ioFactory.create(desc.file());
            try {
                SegmentHeader segmentHeader = RecordV1Serializer.readSegmentHeader(fileIO, this.curWalSegmIdx);
                boolean isCompacted = segmentHeader.isCompacted();
                if (isCompacted) {
                    this.serializerFactory.skipPositionCheck(true);
                }
                FileInput in = new FileInput(fileIO, this.buf);
                if (start != null && desc.idx() == start.index()) {
                    if (isCompacted) {
                        if (start.fileOffset() != 0) {
                            this.serializerFactory.recordDeserializeFilter(new StartSeekingFilter(start));
                        }
                    } else {
                        long startOff = Math.max((long)start.fileOffset(), fileIO.position());
                        in.seek(startOff);
                    }
                }
                int serVer = segmentHeader.getSerializerVersion();
                return this.createReadFileHandle(fileIO, desc.idx(), this.serializerFactory.createSerializer(serVer), in);
            }
            catch (EOFException | SegmentEofException ignore) {
                try {
                    fileIO.close();
                }
                catch (IOException ce) {
                    throw new IgniteCheckedException(ce);
                }
                return null;
            }
            catch (IOException | IgniteCheckedException e) {
                try {
                    fileIO.close();
                }
                catch (IOException ce) {
                    e.addSuppressed(ce);
                }
                throw e;
            }
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Failed to initialize WAL segment: " + desc.file().getAbsolutePath(), e);
        }
    }

    protected abstract AbstractReadFileHandle createReadFileHandle(FileIO var1, long var2, RecordSerializer var4, FileInput var5);

    protected static interface AbstractFileDescriptor {
        public boolean isCompressed();

        public File file();

        public long idx();
    }

    protected static interface AbstractReadFileHandle {
        public void close() throws IgniteCheckedException;

        public long idx();

        public FileInput in();

        public RecordSerializer ser();

        public boolean workDir();
    }

    private static class StartSeekingFilter
    implements P2<WALRecord.RecordType, WALPointer> {
        private static final long serialVersionUID = 0L;
        private final FileWALPointer start;
        private boolean startReached;

        StartSeekingFilter(FileWALPointer start) {
            this.start = start;
        }

        @Override
        public boolean apply(WALRecord.RecordType type, WALPointer pointer) {
            if (this.start.fileOffset() == ((FileWALPointer)pointer).fileOffset()) {
                this.startReached = true;
            }
            return this.startReached;
        }
    }
}

